/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.business.helper.ChgAuditHelper;
import kd.pccs.concs.business.helper.ChgCfmBillHelper;
import kd.pccs.concs.business.helper.ConSettleBillHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.business.helper.SupplyConBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.enums.BizStatusEnum;
import kd.pccs.concs.common.enums.SettleTypeEnum;
import kd.pccs.concs.common.enums.SuppCtrlModeEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;

public class ContractBillHelper {
    public void updateContractInfo(String appId, long conId) {
        DynamicObject conbillObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (String)String.join((CharSequence)",", "billstatus", "bizstatus", "hassettled", "oriamt", "amount", "tax", "latestoriprice", "latestprice", "latesttax", "estchgoriamt", "estchgamt", "estsettleoriamt", "estsettleamt"));
        if (null == conbillObj) {
            return;
        }
        BigDecimal latestoriprice = null;
        BigDecimal latestprice = null;
        BigDecimal latesttax = null;
        BigDecimal chgOriAmt = null;
        BigDecimal chgAmt = null;
        BigDecimal balanceOriAmt = null;
        BigDecimal balanceAmt = null;
        boolean hasSettled = ConSettleBillHelper.hasSettled(appId, conId);
        String bizStatus = BizStatusEnum.INPROGRESS.getValue();
        if (hasSettled) {
            DynamicObject[] settleColl = ConSettleBillHelper.getSettleAmountByContract(appId, conId, true);
            if (null != settleColl && settleColl.length > 0) {
                for (DynamicObject settleObj : settleColl) {
                    latestoriprice = NumberUtil.add((Object)latestoriprice, (Object)settleObj.getBigDecimal("oriamt"));
                    latestprice = NumberUtil.add((Object)latestprice, (Object)settleObj.getBigDecimal("amount"));
                    latesttax = NumberUtil.add((Object)latesttax, (Object)settleObj.getBigDecimal("tax"));
                    if (!BillStatusEnum.AUDITTED.getValue().equals(settleObj.getString("billstatus"))) continue;
                    String settleType = settleObj.getString("settletype");
                    if (!SettleTypeEnum.FINALSETTLE.getValue().equals(settleType) && !SettleTypeEnum.SUSPENDSETTLE.getValue().equals(settleType)) continue;
                    bizStatus = BizStatusEnum.SETTLED.getValue();
                }
                conbillObj.set("estsettleoriamt", (Object)settleColl[0].getBigDecimal("oriamt"));
                conbillObj.set("estsettleamt", (Object)settleColl[0].getBigDecimal("amount"));
            }
        } else {
            DynamicObject[] chgAuditColl;
            DynamicObject[] chgCfmColl;
            if (BillStatusEnum.AUDITTED.getValue().equals(conbillObj.get("billstatus"))) {
                latestoriprice = conbillObj.getBigDecimal("oriamt");
                latestprice = conbillObj.getBigDecimal("amount");
                latesttax = conbillObj.getBigDecimal("tax");
            } else {
                bizStatus = BizStatusEnum.TODO.getValue();
            }
            DynamicObject[] supplyColl = SupplyConBillHelper.getSupplyConAmountByContract(appId, conId, true, null);
            if (null != supplyColl && supplyColl.length > 0) {
                for (DynamicObject supplyObj : supplyColl) {
                    latestoriprice = NumberUtil.add((Object)latestoriprice, (Object)supplyObj.getBigDecimal("oriamt"));
                    latestprice = NumberUtil.add((Object)latestprice, (Object)supplyObj.getBigDecimal("amount"));
                    latesttax = NumberUtil.add((Object)latesttax, (Object)supplyObj.getBigDecimal("tax"));
                    String ctrlModel = supplyObj.getString("ctrlmode");
                    if ("estChgCtrl".equals(ctrlModel)) {
                        chgOriAmt = NumberUtil.add((Object)chgOriAmt, (Object)supplyObj.getBigDecimal("oriamt"));
                        chgAmt = NumberUtil.add((Object)chgAmt, (Object)supplyObj.getBigDecimal("amount"));
                        continue;
                    }
                    balanceOriAmt = NumberUtil.add(balanceOriAmt, (Object)supplyObj.getBigDecimal("oriamt"));
                    balanceAmt = NumberUtil.add(balanceAmt, (Object)supplyObj.getBigDecimal("amount"));
                }
            }
            if (null != (chgCfmColl = this.getChgCfmAmountByContract(appId, conId, true, null)) && chgCfmColl.length > 0) {
                for (DynamicObject chgCfmObj : chgCfmColl) {
                    latestoriprice = NumberUtil.add((Object)latestoriprice, (Object)chgCfmObj.getBigDecimal("oriamt"));
                    latestprice = NumberUtil.add((Object)latestprice, (Object)chgCfmObj.getBigDecimal("amount"));
                    latesttax = NumberUtil.add((Object)latesttax, (Object)chgCfmObj.getBigDecimal("tax"));
                    chgOriAmt = NumberUtil.add((Object)chgOriAmt, (Object)chgCfmObj.getBigDecimal("oriamt"));
                    chgAmt = NumberUtil.add((Object)chgAmt, (Object)chgCfmObj.getBigDecimal("amount"));
                }
            }
            if (null != (chgAuditColl = this.getChgAuditAmountByContract(appId, conId, true, null)) && chgAuditColl.length > 0) {
                for (DynamicObject chgAuditObj : chgAuditColl) {
                    latestoriprice = NumberUtil.add((Object)latestoriprice, (Object)chgAuditObj.getBigDecimal("oriamt"));
                    latestprice = NumberUtil.add((Object)latestprice, (Object)chgAuditObj.getBigDecimal("amount"));
                    latesttax = NumberUtil.add((Object)latesttax, (Object)chgAuditObj.getBigDecimal("tax"));
                    chgOriAmt = NumberUtil.add((Object)chgOriAmt, (Object)chgAuditObj.getBigDecimal("oriamt"));
                    chgAmt = NumberUtil.add((Object)chgAmt, (Object)chgAuditObj.getBigDecimal("amount"));
                }
            }
        }
        if (NumberUtil.isNegativeNum(latestoriprice) || NumberUtil.isNegativeNum(latestprice)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u6700\u65b0\u9020\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ContractBillHelper_0", (String)"pccs-concs-business", (Object[])new Object[0]));
        }
        conbillObj.set("latestoriprice", (Object)latestoriprice);
        conbillObj.set("latestprice", (Object)latestprice);
        conbillObj.set("latesttax", (Object)latesttax);
        conbillObj.set("hassettled", (Object)hasSettled);
        conbillObj.set("bizstatus", (Object)bizStatus);
        if (!hasSettled) {
            BigDecimal estchgoriamt = conbillObj.getBigDecimal("estchgoriamt");
            BigDecimal estchgamt = conbillObj.getBigDecimal("estchgamt");
            Boolean moreThanEstChg = NumberUtil.compareTo(chgOriAmt, (Object)estchgoriamt) >= 0;
            BigDecimal estsettleoriamt = NumberUtil.add((Object)NumberUtil.add((Object)conbillObj.getBigDecimal("oriamt"), balanceOriAmt), (Object)(moreThanEstChg != false ? chgOriAmt : estchgoriamt));
            BigDecimal estsettleamt = NumberUtil.add((Object)NumberUtil.add((Object)conbillObj.getBigDecimal("amount"), balanceAmt), (Object)(moreThanEstChg != false ? chgAmt : estchgamt));
            conbillObj.set("estsettleoriamt", (Object)estsettleoriamt);
            conbillObj.set("estsettleamt", (Object)estsettleamt);
        }
        SaveServiceHelper.update((DynamicObject)conbillObj);
        ContractCenterHelper.synContractCenterInfo(appId, conId);
    }

    protected DynamicObject[] getChgAuditAmountByContract(String appId, long conId, boolean onlyAuditted, Long[] excludeBillIds) {
        return new ChgAuditHelper().getChgAuditAmountByContract(appId, conId, true, null);
    }

    protected DynamicObject[] getChgCfmAmountByContract(String appId, long conId, boolean onlyAuditted, Long[] excludeBillIds) {
        return new ChgCfmBillHelper().getChgCfmAmountByContract(appId, conId, true, null);
    }

    public void updateContractEstChgAmt(String appId, long conId, Map<String, Object> params) {
        if (null == params || params.size() == 0) {
            return;
        }
        DynamicObject conbillObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (String)String.join((CharSequence)",", "estchgoriamt", "estchgamt", "estchgscale"));
        if (null == conbillObj) {
            return;
        }
        conbillObj.set("estchgoriamt", params.get("estchgoriamt"));
        conbillObj.set("estchgamt", params.get("estchgamt"));
        conbillObj.set("estchgscale", params.get("estchgscale"));
        SaveServiceHelper.update((DynamicObject)conbillObj);
    }

    public Map<String, BigDecimal> getConRealHasChange(String appId, Long conId) {
        DynamicObject[] supplyChgs;
        DynamicObject[] conCfms;
        DynamicObject[] conChgs;
        String select = String.join((CharSequence)",", "oriamt", "amount", "notaxamt");
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        BigDecimal conChgOriAmt = BigDecimal.ZERO;
        BigDecimal conChgAmt = BigDecimal.ZERO;
        BigDecimal conChgNoTaxAmt = BigDecimal.ZERO;
        BigDecimal conCfmOriAmt = BigDecimal.ZERO;
        BigDecimal conCfmAmt = BigDecimal.ZERO;
        BigDecimal conCfmNoTaxAmt = BigDecimal.ZERO;
        BigDecimal supplyChgOriAmt = BigDecimal.ZERO;
        BigDecimal supplyChgAmt = BigDecimal.ZERO;
        BigDecimal supplyChgNoTaxAmt = BigDecimal.ZERO;
        BigDecimal supplyBalanceOriAmt = BigDecimal.ZERO;
        filter.add(new QFilter("contractbill", "=", (Object)conId));
        filter.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()));
        filter.add(new QFilter("refbillstatus", "!=", (Object)BillStatusEnum.AUDITTED.getValue()));
        for (DynamicObject conchg : conChgs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"conchgbill"), (String)select, (QFilter[])filter.toArray(new QFilter[filter.size()]))) {
            conChgOriAmt = NumberUtil.add((Object)conChgOriAmt, (Object)conchg.getBigDecimal("oriamt"));
            conChgAmt = NumberUtil.add((Object)conChgAmt, (Object)conchg.getBigDecimal("amount"));
            conChgNoTaxAmt = NumberUtil.add((Object)conChgNoTaxAmt, (Object)conchg.getBigDecimal("notaxamt"));
        }
        filter.clear();
        filter.add(new QFilter("contractbill", "=", (Object)conId));
        filter.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()));
        filter.add(new QFilter("refbillstatus", "!=", (Object)BillStatusEnum.AUDITTED.getValue()));
        for (DynamicObject conCfm : conCfms = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"chgcfmbill"), (String)select, (QFilter[])filter.toArray(new QFilter[filter.size()]))) {
            conCfmOriAmt = NumberUtil.add((Object)conCfmOriAmt, (Object)conCfm.getBigDecimal("oriamt"));
            conCfmAmt = NumberUtil.add((Object)conCfmAmt, (Object)conCfm.getBigDecimal("amount"));
            conCfmNoTaxAmt = NumberUtil.add((Object)conCfmNoTaxAmt, (Object)conCfm.getBigDecimal("notaxamt"));
        }
        filter.clear();
        filter.add(new QFilter("contractbill", "=", (Object)conId));
        filter.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()));
        filter.add(new QFilter("ctrlmode", "=", (Object)SuppCtrlModeEnum.ESTCHGCTRL.getValue()));
        for (DynamicObject supplyChg : supplyChgs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"supplyconbill"), (String)select, (QFilter[])filter.toArray(new QFilter[filter.size()]))) {
            supplyChgOriAmt = NumberUtil.add((Object)supplyChgOriAmt, (Object)supplyChg.getBigDecimal("oriamt"));
            supplyChgAmt = NumberUtil.add((Object)supplyChgAmt, (Object)supplyChg.getBigDecimal("amount"));
            supplyChgNoTaxAmt = NumberUtil.add((Object)supplyChgNoTaxAmt, (Object)supplyChg.getBigDecimal("notaxamt"));
        }
        BigDecimal realOriHasChange = NumberUtil.add((Object[])new BigDecimal[]{conChgOriAmt, conCfmOriAmt, supplyChgOriAmt});
        BigDecimal realHasChange = NumberUtil.add((Object[])new BigDecimal[]{conChgAmt, conCfmAmt, supplyChgAmt});
        BigDecimal realNoTaxHasChange = NumberUtil.add((Object[])new BigDecimal[]{conChgNoTaxAmt, conCfmNoTaxAmt, supplyChgNoTaxAmt});
        HashMap<String, BigDecimal> realHasChangeMap = new HashMap<String, BigDecimal>();
        realHasChangeMap.put("realOriHasChange", realOriHasChange);
        realHasChangeMap.put("realHasChange", realHasChange);
        realHasChangeMap.put("realNoTaxHasChange", realNoTaxHasChange);
        return realHasChangeMap;
    }

    public static Map<String, BigDecimal> getConSupplyBalanceAmt(String appId, long conId) {
        DynamicObject[] supplyBalances;
        BigDecimal supplyBalanceOriAmt = BigDecimal.ZERO;
        BigDecimal supplyBalanceAmt = BigDecimal.ZERO;
        BigDecimal supplyBalancNoTaxAmt = BigDecimal.ZERO;
        String select = String.join((CharSequence)",", "oriamt", "amount", "notaxamt");
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("contractbill", "=", (Object)conId));
        filter.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()));
        filter.add(new QFilter("ctrlmode", "=", (Object)SuppCtrlModeEnum.BALANCECTRL.getValue()));
        for (DynamicObject supplyBalance : supplyBalances = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"supplyconbill"), (String)select, (QFilter[])filter.toArray(new QFilter[filter.size()]))) {
            supplyBalanceOriAmt = NumberUtil.add((Object)supplyBalanceOriAmt, (Object)supplyBalance.getBigDecimal("oriamt"));
            supplyBalanceAmt = NumberUtil.add((Object)supplyBalanceAmt, (Object)supplyBalance.getBigDecimal("amount"));
            supplyBalancNoTaxAmt = NumberUtil.add((Object)supplyBalancNoTaxAmt, (Object)supplyBalance.getBigDecimal("notaxamt"));
        }
        HashMap<String, BigDecimal> supplyBalancAmtMap = new HashMap<String, BigDecimal>();
        supplyBalancAmtMap.put("supplyBalancOriAmt", supplyBalanceOriAmt);
        supplyBalancAmtMap.put("supplyBalancAmt", supplyBalanceAmt);
        supplyBalancAmtMap.put("supplyBalancNoTaxAmt", supplyBalancNoTaxAmt);
        return supplyBalancAmtMap;
    }
}

