/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.business.helper.ChgBillHelper;
import kd.pccs.concs.business.helper.InvoiceBillHelper;
import kd.pccs.concs.business.helper.PayReqBillHelper;
import kd.pccs.concs.business.helper.RewardDeductBillHelper;
import kd.pccs.concs.business.helper.SupplyConBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import org.apache.commons.lang.StringUtils;

public class ContractCenterHelper {
    public Map<String, Object> checkConHasOtherBill(String appId, Long contractBillId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        QFilter[] qFilters = new QFilter[]{new QFilter("contractbill", "=", (Object)contractBillId)};
        String entityId = MetaDataUtil.getEntityId((String)appId, (String)"supplyconbill");
        dataMap.put(entityId, QueryServiceHelper.exists((String)entityId, (QFilter[])qFilters));
        entityId = MetaDataUtil.getEntityId((String)appId, (String)"estchgadjustbill");
        dataMap.put(entityId, QueryServiceHelper.exists((String)entityId, (QFilter[])qFilters));
        entityId = MetaDataUtil.getEntityId((String)appId, (String)"conrevisebill");
        dataMap.put(entityId, QueryServiceHelper.exists((String)entityId, (QFilter[])qFilters));
        entityId = MetaDataUtil.getEntityId((String)appId, (String)"conchgbill");
        dataMap.put(entityId, QueryServiceHelper.exists((String)entityId, (QFilter[])qFilters));
        entityId = MetaDataUtil.getEntityId((String)appId, (String)"chgcfmbill");
        dataMap.put(entityId, QueryServiceHelper.exists((String)entityId, (QFilter[])qFilters));
        entityId = MetaDataUtil.getEntityId((String)appId, (String)"stagesettlebill");
        dataMap.put(entityId, QueryServiceHelper.exists((String)entityId, (QFilter[])qFilters));
        entityId = MetaDataUtil.getEntityId((String)appId, (String)"payreqbill");
        dataMap.put(entityId, QueryServiceHelper.exists((String)entityId, (QFilter[])qFilters));
        entityId = MetaDataUtil.getEntityId((String)appId, (String)"rewarddeductbill");
        dataMap.put(entityId, QueryServiceHelper.exists((String)entityId, (QFilter[])new QFilter[]{new QFilter("rewarddeductentry.entry_contractbill", "=", (Object)contractBillId)}));
        entityId = MetaDataUtil.getEntityId((String)appId, (String)"consettlebill");
        List settlePks = QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])qFilters, null, (int)1);
        if (settlePks.size() == 0) {
            dataMap.put(entityId, Boolean.FALSE);
        } else {
            dataMap.put(entityId, settlePks.get(0));
        }
        entityId = MetaDataUtil.getEntityId((String)appId, (String)"invoicebill");
        dataMap.put(entityId, QueryServiceHelper.exists((String)entityId, (QFilter[])qFilters));
        return dataMap;
    }

    public static void synContractCenterInfo(String appId, long conId) {
        DynamicObject contractBillObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (String)String.join((CharSequence)",", "billstatus", "bizstatus", "auditor", "auditdate", "estsettleoriamt", "estsettleamt", "latestoriprice", "latestprice", "estchgscale"));
        ContractCenterHelper.updateData(appId, contractBillObj, null);
    }

    public void synContractCenterInfo(String appId, DynamicObject object, String operateKey) {
        switch (operateKey) {
            case "save": {
                this.insertData(appId, object, "save");
                break;
            }
            case "submit": {
                this.insertData(appId, object, "submit");
                break;
            }
            case "unsubmit": {
                ContractCenterHelper.updateData(appId, object, "unsubmit");
                break;
            }
            case "audit": {
                ContractCenterHelper.updateData(appId, object, "audit");
                break;
            }
            case "unaudit": {
                ContractCenterHelper.updateData(appId, object, "unaudit");
                break;
            }
            case "delete": {
                DeleteServiceHelper.delete((String)MetaDataUtil.getEntityId((String)appId, (String)"contractcenter"), (QFilter[])new QFilter[]{new QFilter("id", "=", object.getPkValue())});
                break;
            }
        }
    }

    protected void insertData(String appId, DynamicObject object, String operateKey) {
        Object pk = object.getPkValue();
        String entityId = MetaDataUtil.getEntityId((String)appId, (String)"contractcenter");
        DynamicObject conCenter = null;
        if (QueryServiceHelper.exists((String)entityId, (Object)pk)) {
            conCenter = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityId);
        }
        if (null != conCenter) {
            this.assembleData(appId, object, conCenter, operateKey);
        } else {
            this.assembleData(appId, object, null, operateKey);
        }
    }

    protected void assembleData(String appId, DynamicObject object, DynamicObject conCenter, String operateKey) {
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)appId, (String)"contractcenter"));
        DynamicObject dynamicObject = conCenter;
        if (null == conCenter) {
            dynamicObject = new DynamicObject((DynamicObjectType)dynamicObjectType);
        }
        dynamicObject.set("id", object.getPkValue());
        dynamicObject.set("creator", object.get("creator"));
        dynamicObject.set("createtime", object.get("createtime"));
        dynamicObject.set("modifier", object.get("modifier"));
        dynamicObject.set("modifytime", object.get("modifytime"));
        dynamicObject.set("org", object.get("org"));
        dynamicObject.set("project", object.get("project"));
        dynamicObject.set("billno", object.get("billno"));
        dynamicObject.set("billname", (Object)object.getLocaleString("billname"));
        dynamicObject.set("billstatus", object.get("billstatus"));
        dynamicObject.set("bizstatus", object.get("bizstatus"));
        dynamicObject.set("bizdate", object.get("bizdate"));
        dynamicObject.set("handler", object.get("handler"));
        dynamicObject.set("description", object.get("description"));
        dynamicObject.set("applyoriamt", object.get("applyoriamt"));
        dynamicObject.set("applyamt", object.get("applyamt"));
        dynamicObject.set("oriamt", object.get("oriamt"));
        dynamicObject.set("amount", object.get("amount"));
        dynamicObject.set("oricurrency", object.get("oricurrency"));
        dynamicObject.set("currency", object.get("currency"));
        dynamicObject.set("contracttype", object.get("contracttype"));
        dynamicObject.set("partyb", object.get("partyb"));
        dynamicObject.set("partybname", object.get("partybname"));
        dynamicObject.set("partycnames", object.get("partycnames"));
        dynamicObject.set("bizdepart", object.get("bizdepart"));
        dynamicObject.set("marginscale", object.get("marginscale"));
        dynamicObject.set("estchgscale", object.get("estchgscale"));
        dynamicObject.set("paywarnscale", object.get("paywarnscale"));
        dynamicObject.set("latestoriprice", object.get("latestoriprice"));
        dynamicObject.set("latestprice", object.get("latestprice"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static void updateData(String appId, DynamicObject object, String operateKey) {
        DynamicObject conCenter = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"contractcenter"), (String)StringUtils.join((Object[])new Object[]{"id", "billstatus", "auditor", "auditdate", "bizstatus", "estsettleoriamt", "estsettleamt", "latestoriprice", "latestprice", "estchgoribalance", "estchgbalance", "estchgscale"}, (String)","), (QFilter[])new QFilter[]{new QFilter("id", "=", object.getPkValue())});
        if (null != conCenter) {
            conCenter.set("billstatus", object.get("billstatus"));
            conCenter.set("bizstatus", object.get("bizstatus"));
            conCenter.set("auditor", object.get("auditor"));
            conCenter.set("auditdate", object.get("auditdate"));
            conCenter.set("estsettleoriamt", object.get("estsettleoriamt"));
            conCenter.set("estsettleamt", object.get("estsettleamt"));
            conCenter.set("latestoriprice", object.get("latestoriprice"));
            conCenter.set("latestprice", object.get("latestprice"));
            conCenter.set("estchgscale", object.get("estchgscale"));
            if ("audit".equals(operateKey)) {
                BigDecimal estChgScale = (BigDecimal)object.get("estchgscale");
                BigDecimal estChgScaleT = NumberUtil.divide((Object)estChgScale, (Object)NumberUtil.ONE_HUNDRED, (int)4);
                conCenter.set("estchgoribalance", (Object)NumberUtil.multiply((Object)object.get("oriamt"), (Object)estChgScaleT));
                conCenter.set("estchgbalance", (Object)NumberUtil.multiply((Object)object.get("amount"), (Object)estChgScaleT));
            } else if ("unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) {
                conCenter.set("estchgoribalance", null);
                conCenter.set("estchgbalance", null);
            }
            SaveServiceHelper.update((DynamicObject)conCenter);
        }
    }

    public void syncChgAmt2CC(String appId, long conId) {
        DynamicObject conCenterObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractcenter"), (String)String.join((CharSequence)",", "allchgoriamt", "allchgamt", "oriamt", "allsupplyoriamt", "chgscale", "estchgoribalance", "estchgbalance"));
        if (null == conCenterObj) {
            return;
        }
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (String)String.join((CharSequence)",", "estchgoriamt", "estchgamt"));
        Map<String, BigDecimal> conChgAmtResult = this.getChgAmtExcSupply(appId, conId);
        conCenterObj.set("allchgoriamt", (Object)conChgAmtResult.get("oriamt"));
        conCenterObj.set("allchgamt", (Object)conChgAmtResult.get("amount"));
        BigDecimal chgScale = this.getChgScale(appId, conId, conChgAmtResult, conCenterObj);
        conCenterObj.set("chgscale", (Object)chgScale);
        DynamicObject conSettInfo = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"consettlebill"), (String)String.join((CharSequence)",", "billstatus", "oriamt", "amount"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", (Object)conId)});
        if (null != conSettInfo && (BillStatusEnum.SUBMITTED.getValue().equals(conSettInfo.getString("billstatus")) || BillStatusEnum.AUDITTED.getValue().equals(conSettInfo.getString("billstatus")))) {
            conCenterObj.set("estchgoribalance", (Object)NumberUtil.ZERO);
            conCenterObj.set("estchgbalance", (Object)NumberUtil.ZERO);
        } else {
            Map<String, BigDecimal> conChgAmtIncSupplyResult = this.getChgAmtIncSupply(appId, conId);
            BigDecimal estchgoribalance = NumberUtil.subtract((Object)contractBill.getBigDecimal("estchgoriamt"), (Object)conChgAmtIncSupplyResult.get("oriamt"));
            BigDecimal estchgbalance = NumberUtil.subtract((Object)contractBill.getBigDecimal("estchgamt"), (Object)conChgAmtIncSupplyResult.get("amount"));
            if (NumberUtil.compareTo((Object)estchgoribalance, (Object)NumberUtil.ZERO) < 0) {
                estchgoribalance = NumberUtil.ZERO;
                estchgbalance = NumberUtil.ZERO;
            }
            conCenterObj.set("estchgoribalance", (Object)estchgoribalance);
            conCenterObj.set("estchgbalance", (Object)estchgbalance);
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{conCenterObj});
    }

    public static void syncSuppAmt2CC(String appId, long conId) {
        DynamicObject conCenterObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractcenter"), (String)String.join((CharSequence)",", "allsupplyoriamt", "allsupplyamt"));
        if (null == conCenterObj) {
            return;
        }
        DynamicObject[] supplyColl = SupplyConBillHelper.getSupplyConAmountByContract(appId, conId, true, null);
        BigDecimal suppOriAmt = null;
        BigDecimal suppAmt = null;
        if (null != supplyColl && supplyColl.length > 0) {
            for (DynamicObject supplyObj : supplyColl) {
                suppOriAmt = NumberUtil.add(suppOriAmt, (Object)supplyObj.getBigDecimal("oriamt"));
                suppAmt = NumberUtil.add(suppAmt, (Object)supplyObj.getBigDecimal("amount"));
            }
        }
        conCenterObj.set("allsupplyoriamt", suppOriAmt);
        conCenterObj.set("allsupplyamt", suppAmt);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{conCenterObj});
    }

    public static void syncConSettAmt2CC(String appId, long conId) {
        DynamicObject conCenterObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractcenter"), (String)String.join((CharSequence)",", "settleoriamt", "settleamt", "estsettleoriamt", "estsettleamt", "estchgoribalance", "estchgbalance"));
        if (null == conCenterObj) {
            return;
        }
        DynamicObject conSettInfo = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"consettlebill"), (String)String.join((CharSequence)",", "billstatus", "oriamt", "amount"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", (Object)conId)});
        if (null != conSettInfo) {
            if (BillStatusEnum.AUDITTED.getValue().equals(conSettInfo.getString("billstatus"))) {
                BigDecimal settleOriAmt = conSettInfo.getBigDecimal("oriamt");
                BigDecimal settleAmt = conSettInfo.getBigDecimal("amount");
                conCenterObj.set("settleoriamt", (Object)settleOriAmt);
                conCenterObj.set("settleamt", (Object)settleAmt);
                conCenterObj.set("estsettleoriamt", (Object)settleOriAmt);
                conCenterObj.set("estsettleamt", (Object)settleAmt);
            } else {
                conCenterObj.set("settleoriamt", (Object)BigDecimal.ZERO);
                conCenterObj.set("settleamt", (Object)BigDecimal.ZERO);
            }
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{conCenterObj});
    }

    public static void syncPayedAmt2CC(String appId, long conId) {
        DynamicObject conCenterObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractcenter"), (String)String.join((CharSequence)",", "payedoriamt", "payedamt", "payscale", "latestoriprice", "payedconoriamt", "payedconamt"));
        if (null == conCenterObj) {
            return;
        }
        DynamicObject[] payReqColl = PayReqBillHelper.getPayReqAmountByContract(appId, conId, true, true);
        BigDecimal payedOriAmt = null;
        BigDecimal payedAmt = null;
        BigDecimal payedConOriAmt = null;
        BigDecimal payedConAmt = null;
        if (null != payReqColl && payReqColl.length > 0) {
            for (DynamicObject payReqObj : payReqColl) {
                payedOriAmt = NumberUtil.add(payedOriAmt, (Object)payReqObj.getBigDecimal("payedoriamt"));
                payedAmt = NumberUtil.add(payedAmt, (Object)payReqObj.getBigDecimal("payedamt"));
                payedConOriAmt = NumberUtil.add(payedConOriAmt, (Object)payReqObj.getBigDecimal("payedconoriamt"));
                payedConAmt = NumberUtil.add(payedConAmt, (Object)payReqObj.getBigDecimal("payedconamt"));
            }
        }
        BigDecimal payScale = NumberUtil.multiply((Object)NumberUtil.divide(payedConOriAmt, (Object)conCenterObj.getBigDecimal("latestoriprice"), (int)4), (Object)NumberUtil.ONE_HUNDRED);
        conCenterObj.set("payedoriamt", payedOriAmt);
        conCenterObj.set("payedamt", payedAmt);
        conCenterObj.set("payedconoriamt", payedConOriAmt);
        conCenterObj.set("payedconamt", payedConAmt);
        conCenterObj.set("payscale", (Object)payScale);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{conCenterObj});
    }

    public static void syncInvAmt2CC(String appId, long conId) {
        DynamicObject conCenterObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractcenter"), (String)String.join((CharSequence)",", "invoiceamt"));
        if (null == conCenterObj) {
            return;
        }
        DynamicObject[] invoiceBillColl = InvoiceBillHelper.getInvoiceAmountByContract(appId, conId, true);
        BigDecimal invoiceAmt = null;
        if (null != invoiceBillColl && invoiceBillColl.length > 0) {
            for (DynamicObject invoiceBillObj : invoiceBillColl) {
                invoiceAmt = NumberUtil.add(invoiceAmt, (Object)invoiceBillObj.getBigDecimal("amount"));
            }
        }
        conCenterObj.set("invoiceamt", invoiceAmt);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{conCenterObj});
    }

    public static void syncRewardDuctAmt2CC(String appId, long conId) {
        DynamicObject conCenterObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)appId, (String)"contractcenter"), (String)String.join((CharSequence)",", "allrewarddeductamt", "allrewarddeductoriamt"));
        if (null == conCenterObj) {
            return;
        }
        DynamicObject[] rewardDuctColl = RewardDeductBillHelper.getRewardDuctAmtByContract(appId, conId);
        BigDecimal rewardDuctAmt = null;
        BigDecimal rewardDuctOriAmt = null;
        if (null != rewardDuctColl && rewardDuctColl.length > 0) {
            for (DynamicObject rewardDuctObj : rewardDuctColl) {
                rewardDuctAmt = NumberUtil.add(rewardDuctAmt, (Object)rewardDuctObj.getBigDecimal("amount"));
                rewardDuctOriAmt = NumberUtil.add(rewardDuctOriAmt, (Object)rewardDuctObj.getBigDecimal("oriamt"));
            }
        }
        conCenterObj.set("allrewarddeductamt", rewardDuctAmt);
        conCenterObj.set("allrewarddeductoriamt", rewardDuctOriAmt);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{conCenterObj});
    }

    protected Map<String, BigDecimal> getChgAmtExcSupply(String appId, long conId) {
        return new ChgBillHelper().getChgAmtExcSupply(appId, conId, true, null);
    }

    protected Map<String, BigDecimal> getChgAmtIncSupply(String appId, long conId) {
        return new ChgBillHelper().getChgAmtIncSupply(appId, conId, true, null);
    }

    protected BigDecimal getChgScale(String appId, long conId, Map<String, BigDecimal> conChgAmtResult, DynamicObject conCenterObj) {
        Map<String, BigDecimal> conChgAmtMap = new ChgBillHelper().getChgAmtIncSupply(appId, conId, true, null);
        return NumberUtil.multiply((Object)NumberUtil.divide((Object)conChgAmtMap.get("oriamt"), (Object)conCenterObj.getBigDecimal("oriamt"), (int)4), (Object)NumberUtil.ONE_HUNDRED);
    }
}

