/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;

public class InvoiceBillHelper {
    public static void updateInvoiceRef(String appId, DynamicObject dataEntity, String OpreationType) {
        if (null == dataEntity) {
            return;
        }
        Object[] invoicBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"invoicebill"), (String)String.join((CharSequence)",", "refbillid", "refbillstatus"), (QFilter[])new QFilter[]{new QFilter("refbillid", "=", dataEntity.getPkValue())});
        if (ArrayUtils.isNotEmpty((Object[])invoicBills)) {
            Arrays.stream(invoicBills).forEach(invoiceInfo -> {
                invoiceInfo.set("refbillid", (Object)0L);
                invoiceInfo.set("refbillstatus", null);
            });
            SaveServiceHelper.update((DynamicObject[])invoicBills);
        }
        switch (OpreationType) {
            case "save": 
            case "submit": {
                invoicBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"invoicebill"), (String)String.join((CharSequence)",", "id", "refbillid", "refbillstatus"), (QFilter[])new QFilter[]{new QFilter("id", "in", dataEntity.getDynamicObjectCollection("invoiceentrys").stream().map(s -> s.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toSet()))});
                Arrays.stream(invoicBills).forEach(invoiceInfo -> {
                    invoiceInfo.set("refbillid", dataEntity.getPkValue());
                    invoiceInfo.set("refbillstatus", (Object)OpreationType);
                });
                SaveServiceHelper.update((DynamicObject[])invoicBills);
                break;
            }
        }
    }

    public static Map<String, Object> getModelMap4InvoiceCustomCtl(String appId, DynamicObject dataEntity) {
        HashMap<String, Object> model = new HashMap<String, Object>(32);
        model.put("invoicecode", dataEntity.getString("invoicecode"));
        model.put("invoiceno", dataEntity.getString("invoiceno"));
        model.put("invoicetype", dataEntity.getString("invoicetype"));
        model.put("description", dataEntity.getString("description"));
        String date = dataEntity.getString("bizdate");
        Optional.ofNullable(date).ifPresent(d -> model.put("bizdate", d.split(" ")[0]));
        model.put("purbankaccount", dataEntity.getString("purbankaccount"));
        model.put("purdepositbank", dataEntity.getString("purdepositbank"));
        model.put("purtelnumber", dataEntity.getString("purtelnumber"));
        model.put("puraddress", dataEntity.getString("puraddress"));
        model.put("purtaxpayer", dataEntity.getString("purtaxpayer"));
        DynamicObject purOrg = dataEntity.getDynamicObject("purorg");
        Optional.ofNullable(purOrg).map(org -> org.getString("name")).ifPresent(orgName -> model.put("purorg", orgName));
        model.put("salebankaccount", dataEntity.getString("salebankaccount"));
        model.put("saledepositbank", dataEntity.getString("saledepositbank"));
        model.put("saletelnumber", dataEntity.getString("saletelnumber"));
        model.put("saleaddress", dataEntity.getString("saleaddress"));
        model.put("saletaxpayer", dataEntity.getString("saletaxpayer"));
        DynamicObject saleOrg = dataEntity.getDynamicObject("saleorg");
        Optional.ofNullable(saleOrg).map(org -> org.getString("name")).ifPresent(orgName -> model.put("saleorg", orgName));
        model.put("capitalAmount", dataEntity.getString("capitalAmount"));
        model.put("amount", dataEntity.getBigDecimal("amount"));
        model.put("tax", dataEntity.getBigDecimal("tax"));
        model.put("notaxamt", dataEntity.getBigDecimal("notaxamt"));
        return model;
    }

    public void updateRequestBill(String appId, Object invoicePk, Object requestPK, boolean isAudit) {
        Optional.ofNullable(invoicePk).ifPresent(pk -> {
            DynamicObject project;
            DynamicObject invoiceBill = BusinessDataServiceHelper.loadSingle((Object)invoicePk, (String)MetaDataUtil.getEntityId((String)appId, (String)"invoicebill"), (String)String.join((CharSequence)",", "project", "contractbill", "payreqbill"));
            DynamicObject payReqBill = BusinessDataServiceHelper.loadSingle((Object)requestPK, (String)MetaDataUtil.getEntityId((String)appId, (String)"payreqbill"), (String)String.join((CharSequence)",", "project", "contractbill"));
            invoiceBill.set("payreqbill", isAudit ? requestPK : null);
            DynamicObject contract = payReqBill.getDynamicObject("contractbill");
            if (null != contract) {
                invoiceBill.set("contractbill", isAudit ? contract.getPkValue() : null);
            }
            if (null != (project = payReqBill.getDynamicObject("project"))) {
                invoiceBill.set("project", isAudit ? project.getPkValue() : null);
            }
            SaveServiceHelper.update((DynamicObject)invoiceBill);
        });
    }

    public static DynamicObject[] getInvoiceAmountByContract(String appId, long conId, boolean onlyAuditted) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("contractbill", "=", (Object)conId));
        if (onlyAuditted) {
            filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()));
        } else {
            filterList.add(new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMITTED.getValue(), BillStatusEnum.AUDITTED.getValue()}));
        }
        QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
        return BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"invoicebill"), (String)String.join((CharSequence)",", "billstatus", "bizstatus", "amount", "oriamt"), (QFilter[])filters);
    }

    public static boolean checkInvoiceNoAndCodeDuplicated(String appId, DynamicObject invoice) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("invoiceno", "=", (Object)invoice.getString("invoiceno")));
        qFilters.add(new QFilter("invoicecode", "=", (Object)invoice.getString("invoicecode")));
        qFilters.add(new QFilter("id", "!=", (Object)invoice.getString("id")));
        return QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)appId, (String)"invoicebill"), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
    }

    public static List<String> checkInvoiceEntryRequired(DynamicObject billObj) {
        DynamicObjectCollection invoiceEntrys = billObj.getDynamicObjectCollection("invoiceentry");
        ArrayList<String> errorMessage = new ArrayList<String>();
        for (int i = 0; i < invoiceEntrys.size(); ++i) {
            boolean needCheck = false;
            DynamicObject invoiceEntry = (DynamicObject)invoiceEntrys.get(i);
            if (invoiceEntry.getString("entry_content") != null && !invoiceEntry.getString("entry_content").equals("")) {
                needCheck = true;
            } else if (invoiceEntry.getString("entry_model") != null && !invoiceEntry.getString("entry_model").equals("")) {
                needCheck = true;
            } else if (invoiceEntry.getDynamicObject("entry_unit") != null) {
                needCheck = true;
            } else if (invoiceEntry.getBigDecimal("entry_qty") != null) {
                needCheck = true;
            } else if (invoiceEntry.getBigDecimal("entry_price") != null) {
                needCheck = true;
            } else if (invoiceEntry.getBigDecimal("entry_notaxamt") != null) {
                needCheck = true;
            } else if (invoiceEntry.getBigDecimal("entry_tax") != null) {
                needCheck = true;
            } else if (invoiceEntry.getDynamicObject("entry_taxrate") != null) {
                needCheck = true;
            }
            if (!needCheck) continue;
            if (invoiceEntry.getString("entry_content") == null || invoiceEntry.getString("entry_content").equals("")) {
                errorMessage.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%d\u884c,\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\uff0c\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"InvoiceBillHelper_0", (String)"pccs-concs-business", (Object[])new Object[0]), i + 1));
            }
            if (invoiceEntry.getBigDecimal("entry_notaxamt") == null) {
                errorMessage.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%d\u884c,\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"InvoiceBillHelper_1", (String)"pccs-concs-business", (Object[])new Object[0]), i + 1));
            }
            if (invoiceEntry.getBigDecimal("entry_tax") == null) {
                errorMessage.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%d\u884c,\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"InvoiceBillHelper_2", (String)"pccs-concs-business", (Object[])new Object[0]), i + 1));
            }
            if (invoiceEntry.getDynamicObject("entry_taxrate") != null) continue;
            errorMessage.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%d\u884c,\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"InvoiceBillHelper_3", (String)"pccs-concs-business", (Object[])new Object[0]), i + 1));
        }
        return errorMessage;
    }
}

