/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.common.constant.FiCasConst;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;

public class PayReqBillHelper {
    public static DynamicObject[] getPayReqAmountByContract(String appId, Long conId, boolean onlyAuditted, boolean includeAdvance) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("contractbill", "=", (Object)conId));
        if (onlyAuditted) {
            filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()));
        } else {
            filterList.add(new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMITTED.getValue(), BillStatusEnum.AUDITTED.getValue()}));
        }
        if (!includeAdvance) {
            filterList.add(new QFilter("paymenttype", "!=", (Object)FiCasConst.PRE_PAYMENT));
        }
        QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
        return BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"payreqbill"), (String)String.join((CharSequence)",", "billstatus", "bizstatus", "hasclosed", "paymenttype", "prepayoriamt", "prepayamt", "payedconoriamt", "payedconamt", "payedoriamt", "oriamt", "amount", "invoiceamt", "invoicetax", "applyoriamt", "applyamt", "payedamt"), (QFilter[])filters);
    }

    public static boolean checkHasClosed(String appId, Long billId) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)MetaDataUtil.getEntityId((String)appId, (String)"payreqbill"), (String)"hasclosed");
        return bill.getBoolean("hasclosed");
    }

    public static boolean checkMoreThanPayReqAmt(String appId, Long conId, BigDecimal billOriAmt, BigDecimal upStreamBillOriAmt) {
        DynamicObject[] payReqBills = PayReqBillHelper.getPayReqAmountByContract(appId, conId, true, true);
        if (payReqBills.length == 0) {
            return false;
        }
        BigDecimal payReqSum = Arrays.stream(payReqBills).map(p -> NumberUtil.subtract((Object)p.getBigDecimal("oriamt"), (Object)p.getBigDecimal("prepayoriamt"))).reduce(BigDecimal::add).get();
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (String)String.join((CharSequence)",", "latestoriprice", "marginoriamt"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)conId)});
        BigDecimal latestOriPrice = contractBill.getBigDecimal("latestoriprice");
        BigDecimal marginOriAmt = contractBill.getBigDecimal("marginoriamt");
        BigDecimal amount = NumberUtil.subtract((Object)NumberUtil.subtract((Object)latestOriPrice, (Object)marginOriAmt), (Object)billOriAmt);
        return NumberUtil.compareTo((Object)payReqSum, (Object)(amount = NumberUtil.add((Object)amount, (Object)upStreamBillOriAmt))) > 0;
    }

    public static void updateInvoiceInfo(String appId, Object payReqId, Object invoiceId, Object refBillId) {
        DynamicObject newInvoice;
        DynamicObjectCollection invoiceEntrys;
        DynamicObject invoiceBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"invoicebill"), (String)String.join((CharSequence)",", "refbillid", "refbillstatus", "amount", "tax", "notaxamt"), (QFilter[])new QFilter[]{new QFilter("id", "=", invoiceId)});
        BigDecimal invoiceAmt = invoiceBill.getBigDecimal("amount");
        BigDecimal invoiceTax = invoiceBill.getBigDecimal("tax");
        BigDecimal invoiceNoTaxAmt = invoiceBill.getBigDecimal("notaxamt");
        if (null != refBillId && !refBillId.equals(0L)) {
            DynamicObject srcRefPayReqBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"payreqbill"), (String)String.join((CharSequence)",", "invoiceentrys", "invoiceamt", "invoicetax", "invoicenotaxamt", "totalinvoiceamt", "totalinvoicetax"), (QFilter[])new QFilter[]{new QFilter("id", "=", refBillId)});
            srcRefPayReqBill.set("invoiceamt", (Object)NumberUtil.subtract((Object)srcRefPayReqBill.get("invoiceamt"), (Object)invoiceAmt));
            srcRefPayReqBill.set("invoicetax", (Object)NumberUtil.subtract((Object)srcRefPayReqBill.get("invoicetax"), (Object)invoiceTax));
            srcRefPayReqBill.set("invoicenotaxamt", (Object)NumberUtil.subtract((Object)srcRefPayReqBill.get("invoicenotaxamt"), (Object)invoiceNoTaxAmt));
            srcRefPayReqBill.set("totalinvoiceamt", (Object)NumberUtil.subtract((Object)srcRefPayReqBill.get("totalinvoiceamt"), (Object)invoiceAmt));
            srcRefPayReqBill.set("totalinvoicetax", (Object)NumberUtil.subtract((Object)srcRefPayReqBill.get("totalinvoicetax"), (Object)invoiceTax));
            invoiceEntrys = srcRefPayReqBill.getDynamicObjectCollection("invoiceentrys");
            newInvoice = invoiceEntrys.addNew();
            newInvoice.set("fbasedataid", (Object)invoiceBill);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcRefPayReqBill});
        }
        if (null == payReqId) {
            return;
        }
        DynamicObject payReqBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"payreqbill"), (String)String.join((CharSequence)",", "invoiceentrys", "invoiceamt", "invoicetax", "invoicenotaxamt", "totalinvoiceamt", "totalinvoicetax"), (QFilter[])new QFilter[]{new QFilter("id", "=", payReqId)});
        invoiceEntrys = payReqBill.getDynamicObjectCollection("invoiceentrys");
        newInvoice = invoiceEntrys.addNew();
        newInvoice.set("fbasedataid", (Object)invoiceBill);
        payReqBill.set("invoiceamt", (Object)NumberUtil.add((Object)payReqBill.get("invoiceamt"), (Object)invoiceAmt));
        payReqBill.set("invoicetax", (Object)NumberUtil.add((Object)payReqBill.get("invoicetax"), (Object)invoiceTax));
        payReqBill.set("invoicenotaxamt", (Object)NumberUtil.add((Object)payReqBill.get("invoicenotaxamt"), (Object)invoiceNoTaxAmt));
        payReqBill.set("totalinvoiceamt", (Object)NumberUtil.add((Object)payReqBill.get("totalinvoiceamt"), (Object)invoiceAmt));
        payReqBill.set("totalinvoicetax", (Object)NumberUtil.add((Object)payReqBill.get("totalinvoicetax"), (Object)invoiceTax));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payReqBill});
    }

    public static Map<String, BigDecimal> getPreUnPayOriAmt(String appId, Long conId, Long curPayReqId) {
        HashMap<String, BigDecimal> preUnPayAmtMap = new HashMap<String, BigDecimal>();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("contractbill", "=", (Object)conId));
        filterList.add(new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMITTED.getValue(), BillStatusEnum.AUDITTED.getValue()}));
        if (null != curPayReqId) {
            filterList.add(new QFilter("id", "!=", (Object)curPayReqId));
        }
        QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
        DynamicObject[] payReqBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"payreqbill"), (String)String.join((CharSequence)",", "paymenttype", "billstatus", "oriamt", "amount", "prepayoriamt", "prepayamt"), (QFilter[])filters);
        BigDecimal totalAdvanceOriAmt = NumberUtil.ZERO;
        BigDecimal totalAdvanceAmount = NumberUtil.ZERO;
        BigDecimal totalPrePayOriAmt = NumberUtil.ZERO;
        BigDecimal totalPrePayAmt = NumberUtil.ZERO;
        for (DynamicObject billObj : payReqBills) {
            DynamicObject paymentType = billObj.getDynamicObject("paymenttype");
            if (FiCasConst.PRE_PAYMENT.equals((Long)paymentType.getPkValue())) {
                if (!BillStatusEnum.AUDITTED.getValue().equals(billObj.get("billstatus"))) continue;
                totalAdvanceOriAmt = NumberUtil.add((Object)totalAdvanceOriAmt, (Object)billObj.getBigDecimal("oriamt"));
                totalAdvanceAmount = NumberUtil.add((Object)totalAdvanceAmount, (Object)billObj.getBigDecimal("amount"));
                continue;
            }
            totalPrePayOriAmt = NumberUtil.add((Object)totalPrePayOriAmt, (Object)billObj.getBigDecimal("prepayoriamt"));
            totalPrePayAmt = NumberUtil.add((Object)totalPrePayAmt, (Object)billObj.getBigDecimal("prepayamt"));
        }
        preUnPayAmtMap.put("preunpayoriamt", NumberUtil.subtract((Object)totalAdvanceOriAmt, (Object)totalPrePayOriAmt));
        preUnPayAmtMap.put("preunpayamt", NumberUtil.subtract((Object)totalAdvanceAmount, (Object)totalPrePayAmt));
        return preUnPayAmtMap;
    }
}

