/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.common.util.MetaDataUtil;

public class RewardDeductBillHelper {
    public static void syncRewardDeductBill2RewardDeductF7(String appId, DynamicObject model, String opreationType) {
        if (null == model) {
            return;
        }
        switch (opreationType) {
            case "audit": {
                RewardDeductBillHelper.afterAuditSyncRewardDeductBill(appId, model);
                break;
            }
            case "unaudit": {
                RewardDeductBillHelper.afterUnAuditSyncRewardDeductBill(appId, model);
                break;
            }
        }
    }

    public static void updateRewardDeductF7RefBillId(String appId, DynamicObject model, String opreationType) {
        if (null == model) {
            return;
        }
        Object[] rewardDeductF7Objs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"rewarddeduct_f7"), (String)"refbillid", (QFilter[])new QFilter[]{new QFilter("refbillid", "=", model.getPkValue())});
        if (ArrayUtils.isNotEmpty((Object[])rewardDeductF7Objs)) {
            Arrays.stream(rewardDeductF7Objs).forEach(rewardDeductF7Obj -> rewardDeductF7Obj.set("refbillid", null));
            SaveServiceHelper.update((DynamicObject[])rewardDeductF7Objs);
        }
        switch (opreationType) {
            case "save": 
            case "submit": 
            case "audit": {
                rewardDeductF7Objs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"rewarddeduct_f7"), (String)"refbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", model.getDynamicObjectCollection("payreqredeentry").stream().map(s -> s.getDynamicObject("inventry_rewarddeduct")).map(DataEntityBase::getPkValue).collect(Collectors.toSet()))});
                Arrays.stream(rewardDeductF7Objs).forEach(rewardDeductF7Obj -> rewardDeductF7Obj.set("refbillid", model.getPkValue()));
                SaveServiceHelper.update((DynamicObject[])rewardDeductF7Objs);
                break;
            }
        }
    }

    private static void afterAuditSyncRewardDeductBill(String appId, DynamicObject model) {
        DynamicObjectCollection entrys = model.getDynamicObjectCollection("rewarddeductentry");
        ArrayList rewardDeductF7List = new ArrayList(16);
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)appId, (String)"rewarddeduct_f7"));
        Long billId = model.getLong("id");
        Object billName = model.get("billname");
        Object billNo = model.get("billno");
        DynamicObject org = model.getDynamicObject("org");
        DynamicObject project = model.getDynamicObject("project");
        Date bizDate = model.getDate("bizdate");
        DynamicObject handler = model.getDynamicObject("handler");
        String billStatus = model.getString("billstatus");
        DynamicObject creator = model.getDynamicObject("creator");
        Date auditDate = model.getDate("auditdate");
        DynamicObject auditor = model.getDynamicObject("auditor");
        entrys.stream().forEach(arg_0 -> RewardDeductBillHelper.lambda$afterAuditSyncRewardDeductBill$3((DynamicObjectType)dynamicObjectType, bizDate, project, org, billName, billStatus, auditDate, auditor, billNo, creator, handler, billId, rewardDeductF7List, arg_0));
        SaveServiceHelper.save((DynamicObject[])rewardDeductF7List.toArray(new DynamicObject[rewardDeductF7List.size()]));
    }

    private static void afterUnAuditSyncRewardDeductBill(String appId, DynamicObject model) {
        DeleteServiceHelper.delete((String)MetaDataUtil.getEntityId((String)appId, (String)"rewarddeduct_f7"), (QFilter[])new QFilter[]{new QFilter("billId", "=", (Object)model.getLong("id"))});
    }

    public static DynamicObject[] getRewardDuctAmtByContract(String appId, long conId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("contractbill", "=", (Object)conId));
        QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
        return BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"rewarddeduct_f7"), (String)String.join((CharSequence)",", "amount", "oriamt"), (QFilter[])filters);
    }

    private static /* synthetic */ void lambda$afterAuditSyncRewardDeductBill$3(DynamicObjectType dynamicObjectType, Date bizDate, DynamicObject project, DynamicObject org, Object billName, String billStatus, Date auditDate, DynamicObject auditor, Object billNo, DynamicObject creator, DynamicObject handler, Long billId, List rewardDeductF7List, DynamicObject entry) {
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        long id = ORM.create().genLongId((IDataEntityType)dynamicObjectType);
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("bizdate", (Object)bizDate);
        dynamicObject.set("project", (Object)project);
        dynamicObject.set("org", (Object)org);
        dynamicObject.set("name", billName);
        dynamicObject.set("billstatus", (Object)billStatus);
        dynamicObject.set("auditdate", (Object)auditDate);
        dynamicObject.set("auditor", (Object)auditor);
        dynamicObject.set("number", billNo);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)creator);
        dynamicObject.set("handler", (Object)handler);
        dynamicObject.set("billId", (Object)billId);
        dynamicObject.set("entryId", (Object)Long.valueOf(entry.getPkValue().toString()));
        dynamicObject.set("contractbill", (Object)entry.getDynamicObject("entry_contractbill"));
        dynamicObject.set("supplier", (Object)entry.getDynamicObject("entry_supplier"));
        dynamicObject.set("suppliername", entry.get("entry_suppliername"));
        dynamicObject.set("payitem", (Object)entry.getDynamicObject("entry_payitem"));
        dynamicObject.set("paytype", (Object)entry.getDynamicObject("entry_payitem").getString("deductproperty"));
        dynamicObject.set("oriamt", (Object)entry.getBigDecimal("entry_oriamt"));
        dynamicObject.set("amount", (Object)entry.getBigDecimal("entry_amount"));
        dynamicObject.set("description", entry.get("entry_description"));
        dynamicObject.set("currency", entry.get("entry_currency"));
        dynamicObject.set("oricurrency", entry.get("entry_oricurrency"));
        rewardDeductF7List.add(dynamicObject);
    }
}

