/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper.bd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.pccs.concs.common.enums.DataStandardBillEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.OrgUtil;

public class DataStandardHelper {
    public static DynamicObject[] getDataStandardArrByContract(String appId, String billType, DynamicObject contract) {
        long orgId = OrgUtil.getCurrentOrgId((DynamicObject)contract);
        QFilter orgQFilter = BaseDataServiceHelper.getBaseDataFilter((String)MetaDataUtil.getEntityId((String)appId, (String)"datastandard"), (Long)orgId);
        if (orgQFilter == null) {
            orgQFilter = new QFilter("createorg", "=", (Object)orgId);
        }
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        DynamicObject[] dataStands = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"datastandard"), (String)String.join((CharSequence)",", "id", "name", "enable", "isrequired", "description"), (QFilter[])new QFilter[]{orgQFilter, new QFilter("billtype", "=", (Object)billType), new QFilter("group", "=", contractType.getPkValue()), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        return dataStands;
    }

    public static Map<String, Object> getDataStandardByContract(String appId, String billType, DynamicObject contract) {
        DynamicObject contractInfo = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (String)String.join((CharSequence)",", "contracttype", "org"));
        DynamicObject contractType = contractInfo.getDynamicObject("contracttype");
        if (null == contractType) {
            return null;
        }
        DynamicObject[] dataStandards = DataStandardHelper.getDataStandardArrByContract(appId, billType, contract);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        LinkedList<String> enableIds = new LinkedList<String>();
        HashMap<String, DynamicObject> dataStandardMap = new HashMap<String, DynamicObject>(dataStandards.length);
        result.put("enableIds", enableIds);
        result.put("dataStandardMap", dataStandardMap);
        for (int i = 0; i < dataStandards.length; ++i) {
            DynamicObject dataStandard = dataStandards[i];
            String id = dataStandard.getPkValue().toString();
            dataStandardMap.put(id, dataStandard);
            enableIds.add(id);
        }
        return result;
    }

    public static void updateDataStandEntry(String appId, IDataModel model, IFormView view, String billType) {
        DynamicObject billObj = model.getDataEntity();
        DynamicObject contract = billObj.getDynamicObject("contractbill");
        if (null == contract) {
            return;
        }
        Map<String, Object> result = DataStandardHelper.getDataStandardByContract(appId, billType, contract);
        if (null == result) {
            return;
        }
        List enableIds = (List)result.get("enableIds");
        Map dataStandardMap = (Map)result.get("dataStandardMap");
        String entryName = null;
        String dataentry_datastandard = null;
        String dataentry_verifyReport = null;
        String dataentry_verifyQty = null;
        if (DataStandardBillEnum.CONSETTLE.getValue().equals(billType)) {
            entryName = "settledataentry";
            dataentry_datastandard = "dataentry_datastandard";
            dataentry_verifyReport = "dataentry_reportflag";
            dataentry_verifyQty = "dataentry_verifyqty";
        } else if (DataStandardBillEnum.STAGESETTLE.getValue().equals(billType)) {
            entryName = "stagesettleentry";
            dataentry_datastandard = "dataentry_datastandard";
            dataentry_verifyReport = "dataentry_verifyReport";
            dataentry_verifyQty = "dataentry_verifyQty";
        } else if (DataStandardBillEnum.PAYREQUEST.getValue().equals(billType)) {
            entryName = "payreqdataentry";
            dataentry_datastandard = "dataentry_datastandard";
            dataentry_verifyReport = "dataentry_reportflag";
            dataentry_verifyQty = "dataentry_verifyqty";
        }
        if (null == entryName) {
            return;
        }
        DynamicObjectCollection entrys = billObj.getDynamicObjectCollection(entryName);
        for (int i = entrys.size() - 1; i >= 0; --i) {
            String id = ((DynamicObject)entrys.get(i)).getDynamicObject(dataentry_datastandard).getPkValue().toString();
            if (enableIds.contains(id)) {
                dataStandardMap.remove(id);
                continue;
            }
            entrys.remove(i);
        }
        Iterator it = dataStandardMap.keySet().iterator();
        DynamicObjectType entryType = entrys.getDynamicObjectType();
        while (it.hasNext()) {
            DynamicObject dataStand = (DynamicObject)dataStandardMap.get(it.next());
            DynamicObject entry = new DynamicObject(entryType);
            entry.set(dataentry_datastandard, (Object)dataStand);
            entry.set(dataentry_verifyReport, null);
            entry.set(dataentry_verifyQty, null);
            entrys.add((Object)entry);
        }
        model.updateEntryCache(entrys);
        view.updateView(entryName);
    }
}

