/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.common.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class CurrencyHelper {
    public static DynamicObject getCurrency(Long orgId) {
        Map<String, Long> map = CurrencyHelper.getCurrencyAndExRateTable(orgId);
        if (map != null && !map.isEmpty()) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get("baseCurrencyID"), (String)"bd_currency");
        }
        return null;
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (null != mapOrg && !mapOrg.isEmpty()) {
            return BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
        }
        return null;
    }

    public static BigDecimal getExchangeRate(Long srcCurId, Long targCurId, Long exRateTableId) {
        BigDecimal exChangeRate = BigDecimal.ZERO;
        exChangeRate = srcCurId.equals(targCurId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)targCurId, (Date)new Date());
        return exChangeRate;
    }

    public static BigDecimal getExchangeRate(Long orgId, Long sourceCurrencyID) {
        BigDecimal exChangeRate = BigDecimal.ONE;
        Map<String, Long> map = CurrencyHelper.getCurrencyAndExRateTable(orgId);
        if (map != null && !map.isEmpty()) {
            Long baseCurrencyID = map.get("baseCurrencyID");
            Long exchangeRateTableID = map.get("exchangeRateTableID");
            if (!sourceCurrencyID.equals(baseCurrencyID)) {
                exChangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableID, (Long)sourceCurrencyID, (Long)baseCurrencyID, (Date)new Date());
            }
        }
        return exChangeRate;
    }
}

