/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.common.util;

import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String DATE_FMT = "yyyy-MM-dd";
    public static final String DATETIME_FMT = "yyyy-MM-dd HH:mm:ss";

    public static Date getDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        return calendar.getTime();
    }

    public static int getYearMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (null == date) {
            date = new Date();
        }
        calendar.setTime(date);
        return calendar.get(1) * 100 + (calendar.get(2) + 1);
    }

    public static int getNextYearMonth(int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, month / 100);
        calendar.set(2, month % 100 - 1);
        calendar.set(5, 1);
        calendar.add(2, 1);
        return calendar.get(1) * 100 + (calendar.get(2) + 1);
    }

    public static Date getLastDayOfMonth(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        return calendar.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return 0;
        }
        long diffTimes = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        return (int)diffTimes + 1;
    }
}

