/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.common.util;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.pccs.concs.common.util.NumberUtil;
import org.apache.commons.lang.StringUtils;

public class DynamicObjectUtil {
    public static final String FORMAT = "yyyy-MM-dd";

    public static void copy(DynamicObject fromObj, DynamicObject toObj) {
        DynamicObjectUtil.copy(fromObj, toObj, null, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        DynamicObjectUtil.copy(fromObj, toObj, ignoreKeys, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Map<String, String> transKeyMap) {
        DynamicObjectUtil.copy(fromObj, toObj, null, transKeyMap);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (fromPros == null || fromPros.size() == 0) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (toPros == null || toPros.size() == 0) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (Object pro : fromPros) {
            fromPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        ISimpleProperty primaryKeyObj = toObj.getDataEntityType().getPrimaryKey();
        String primaryKey = "";
        if (primaryKeyObj != null) {
            primaryKey = primaryKeyObj.getName();
        }
        if (transKeyMap == null) {
            transKeyMap = new HashMap<String, String>(0);
        }
        for (IDataEntityProperty pro : toPros) {
            String toProName = pro.getName();
            String fromProName = toProName;
            String customKey = transKeyMap.get(fromProName);
            if (StringUtils.isNotBlank((String)customKey)) {
                toProName = customKey;
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            if (toProName.equals(primaryKey)) {
                toObj.set(toProName, null);
                continue;
            }
            Object value = fromObj.get(fromProName);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
                DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
                if (toEntity != null) {
                    toEntity.clear();
                    DynamicObjectType entityType = toEntity.getDynamicObjectType();
                    for (DynamicObject baseEntry : formEntity) {
                        DynamicObject newEntry = new DynamicObject(entityType);
                        newEntry.getDataEntityState().setFromDatabase(true);
                        DynamicObjectUtil.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
                        toEntity.add((Object)newEntry);
                    }
                }
                toObj.set(toProName, (Object)toEntity);
                continue;
            }
            toObj.set(toProName, value);
        }
    }

    public static LocaleString localeDynamicObjectCollectionToLocaleString(IDataEntityProperty property, LocaleDynamicObjectCollection localDoColl) {
        if (property == null) {
            return null;
        }
        return DynamicObjectUtil.localeDynamicObjectCollectionToLocaleString(property.getName(), localDoColl);
    }

    public static LocaleString localeDynamicObjectCollectionToLocaleString(String propName, LocaleDynamicObjectCollection localDoColl) {
        if (StringUtils.isEmpty((String)propName) || null == localDoColl || localDoColl.size() == 0) {
            return null;
        }
        IDataEntityProperty localeProp = localDoColl.getLocaleIdProperty();
        LocaleString ls = new LocaleString();
        int size = localDoColl.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject ldo = (DynamicObject)localDoColl.get(i);
            if (ldo == null) continue;
            String tmpLocaleID = ldo.getString(localeProp.getName());
            String localeText = ldo.getString(propName);
            ls.setItem(tmpLocaleID, (Object)localeText);
        }
        return ls;
    }

    public static String valueToString(IDataEntityProperty property, Object value) {
        if (property instanceof BooleanProp) {
            return null != value && (Boolean)value != false ? ResManager.loadKDString((String)"\u662f", (String)"DynamicObjectUtil_0", (String)"pccs-concs-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"DynamicObjectUtil_1", (String)"pccs-concs-common", (Object[])new Object[0]);
        }
        if (null == value) {
            return "";
        }
        if (property instanceof AmountProp) {
            return NumberUtil.setScale(value, 2).toString();
        }
        if (property instanceof DecimalProp) {
            return NumberUtil.setScale(value, ((DecimalProp)property).getScale()).toString();
        }
        if (property instanceof ComboProp) {
            return ((ComboProp)property).getItemByName(value.toString());
        }
        if (property instanceof MuliLangTextProp) {
            LocaleString localeString = null;
            if (!(value instanceof LocaleDynamicObjectCollection)) {
                return value.toString();
            }
            localeString = DynamicObjectUtil.localeDynamicObjectCollectionToLocaleString(property, (LocaleDynamicObjectCollection)value);
            return null != localeString ? localeString.getLocaleValue() : "";
        }
        if (property instanceof DateProp || property instanceof DateTimeProp) {
            return new SimpleDateFormat(FORMAT).format(value);
        }
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).get(((BasedataProp)property).getDisplayProp()).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            StringBuilder valStr = new StringBuilder();
            boolean isFirst = true;
            for (Object obj : coll) {
                if (!isFirst) {
                    valStr.append(';');
                }
                String val = null;
                if (obj instanceof DynamicObject) {
                    if (property instanceof MulBasedataProp) {
                        DynamicObject refBdObj = (DynamicObject)((DynamicObject)obj).get("fbasedataid");
                        BasedataProp prop = (BasedataProp)((MulBasedataProp)property).getRefBaseProp();
                        val = refBdObj.get(prop.getDisplayProp()).toString();
                    } else if (property instanceof BasedataProp) {
                        val = ((DynamicObject)obj).get(((BasedataProp)property).getDisplayProp()).toString();
                    }
                }
                if (null == val) {
                    val = obj.toString();
                }
                valStr.append(val);
                isFirst = false;
            }
            return valStr.toString();
        }
        return value.toString();
    }
}

