/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PermissionUtil {
    private static final String DIM_ORG = "DIM_ORG";
    private static final String LICENSE_GROUP = "lic_group";

    public static HasPermOrgResult getAllViewPermOrgs(Long userId, String appId, String entityNumber) {
        return PermissionUtil.getAllPermOrgs(userId, appId, entityNumber, "47150e89000000ac");
    }

    public static HasPermOrgResult getAllViewPermOrgs(String appId, String entityNumber) {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionUtil.getAllPermOrgs(userId, appId, entityNumber, "47150e89000000ac");
    }

    public static HasPermOrgResult getAllPermOrgs(Long userId, String appId, String entityNumber, String permItemId) {
        return PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNumber, (String)permItemId);
    }

    public static List<Long> getAllViewPermSubOrgs(Long orgId, Long userId, String appId, String entityNumber) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.parseLong("15"), orgIds, (boolean)true);
        HasPermOrgResult rst = PermissionUtil.getAllPermOrgs(userId, appId, entityNumber, "47150e89000000ac");
        if (!rst.hasAllOrgPerm()) {
            List permOrgIds = rst.getHasPermOrgs();
            Iterator itr = orgIds.iterator();
            while (itr.hasNext()) {
                orgId = (Long)itr.next();
                if (permOrgIds.contains(orgId)) continue;
                itr.remove();
            }
        }
        return orgIds;
    }

    public static String getPermItemId(String number) {
        DynamicObject permissionObj = BusinessDataServiceHelper.loadSingle((String)"perm_permitem", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        return permissionObj != null ? permissionObj.get("id").toString() : null;
    }

    public static Set<Long> getFormViewUser(String appId, String entityNumber) {
        HashSet<Long> formUser = new HashSet<Long>();
        Set appUser = PermissionServiceHelper.getAppUser((String)appId);
        for (Long appUserItem : appUser) {
            if (!PermissionServiceHelper.hasViewPermission((long)appUserItem, (String)appId, (String)entityNumber)) continue;
            formUser.add(appUserItem);
        }
        return formUser;
    }

    public static Set<Long> getFormViewUserByOrgId(String permItemNumber, String appId, String entityNumber, Long orgId) {
        String permItemId = PermissionUtil.getPermItemId(permItemNumber);
        return PermissionUtil.getFormViewUsersOrgById(permItemId, appId, entityNumber, orgId);
    }

    public static Set<Long> getFormViewUsersOrgById(String permItemId, String appId, String entityNumber, Long orgId) {
        HashSet<Long> formUser = new HashSet<Long>();
        Set appUser = PermissionServiceHelper.getAppUser((String)appId);
        for (Long appUserItem : appUser) {
            if (!PermissionUtil.checkPermissionById(permItemId, appUserItem, orgId, appId, entityNumber)) continue;
            formUser.add(appUserItem);
        }
        return formUser;
    }

    public static boolean checkPermission(String permItemNumber, Long userId, Long orgId, String appId, String entityNumber) {
        String permItemId = PermissionUtil.getPermItemId(permItemNumber);
        return PermissionUtil.checkPermissionById(permItemId, userId, orgId, appId, entityNumber);
    }

    public static boolean checkPermissionById(String permItemId, Long userId, Long orgId, String appId, String entityNumber) {
        return PermissionServiceHelper.checkPermission((long)userId, (String)DIM_ORG, (long)orgId, (String)appId, (String)entityNumber, (String)permItemId) == 1;
    }

    public static boolean checkPermissionNumber(String permItemNumber, Long orgId, String appId, String entityNumber) {
        Long userId = RequestContext.get().getCurrUserId();
        return PermissionUtil.checkPermission(permItemNumber, userId, orgId, appId, entityNumber);
    }

    public static boolean checkHasCasLicenseByUserId(Long userId, String groupNumber) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)LICENSE_GROUP, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)groupNumber)});
        boolean hasLicense = false;
        if (dynamicObjects.length > 0) {
            hasLicense = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)((Long)dynamicObjects[0].getPkValue())).getHasLicense();
        }
        return hasLicense;
    }

    @Deprecated
    public static boolean isSuperUser(String userId) {
        HasPermOrgResult allViewPermOrgs = PermissionUtil.getAllViewPermOrgs(Long.parseLong(userId), "concs", "concs_contractbill");
        return allViewPermOrgs.hasAllOrgPerm();
    }

    public static boolean isSuperUser(long userId) {
        HasPermOrgResult allViewPermOrgs = PermissionUtil.getAllViewPermOrgs(userId, "concs", "concs_contractbill");
        return allViewPermOrgs.hasAllOrgPerm();
    }
}

