/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.common.util.supplier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import org.apache.commons.lang.StringUtils;

public class SupplierUtil {
    public static String getSupplierNameByAppId(String appId) {
        switch (appId) {
            case "concs": {
                return "bd_supplier";
            }
            case "recon": {
                return "resm_official_supplier";
            }
            case "nprcon": 
            case "npecon": {
                return "resm_official_supplier";
            }
        }
        return "bd_supplier";
    }

    public static void handlerCommonSupplierName(SupplierParam params) {
        DynamicObject model = params.model;
        DynamicObject supplierObj = model.getDynamicObject(params.supplierObj_index);
        Optional.ofNullable(supplierObj).ifPresent(supplier -> SupplierUtil.setSupplierName(params, supplierObj));
    }

    public static void handleContractSupplierName(String entityName, DynamicObject model, String oprationKey) {
        DynamicObject supplierObj = model.getDynamicObject("partyb");
        Optional.ofNullable(supplierObj).ifPresent(supplier -> {
            SupplierParam supplierParam = new SupplierParam("partyb", "partybname", entityName, model, oprationKey);
            SupplierUtil.setSupplierName(supplierParam, supplierObj);
        });
        DynamicObjectCollection partCs = model.getDynamicObjectCollection("partycs");
        if (null == partCs || partCs.size() == 0) {
            return;
        }
        boolean isSaveOrSubmit = OperationUtil.isSubmitOp(oprationKey) || OperationUtil.isSaveOp(oprationKey);
        String appId = Optional.ofNullable(entityName).filter(name -> name.indexOf(95) > -1).map(name -> name.split("_")[0]).orElse("");
        if (isSaveOrSubmit) {
            Object[] partCIds = new ArrayList(partCs).stream().filter(data -> null != data.getDynamicObject("fbasedataid")).map(data -> data.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).toArray();
            LocaleString names = SupplierUtil.getMultiLangSupplierName(partCIds, appId);
            model.set("partycnames", (Object)names);
        } else {
            int i;
            Object partcNames = model.get("partycnames");
            if (null == partcNames || StringUtils.isEmpty((String)partcNames.toString())) {
                return;
            }
            int num = StringUtils.split((String)((OrmLocaleValue)partcNames).getLocaleValue(), (String)";").length;
            OrmLocaleValue partyCMultiLang = (OrmLocaleValue)partcNames;
            ArrayList<LocaleString> partycnames = new ArrayList<LocaleString>(16);
            Set entries = partyCMultiLang.entrySet();
            for (i = 0; i < num; ++i) {
                LocaleString locale = new LocaleString();
                for (Map.Entry next : entries) {
                    String[] nameArr;
                    if (null == next || !StringUtils.isNotEmpty((String)((String)next.getValue())) || i >= (nameArr = ((String)next.getValue()).split(";")).length) continue;
                    locale.put((String)next.getKey(), (Object)nameArr[i]);
                }
                partycnames.add(locale);
            }
            if (partycnames.size() != partCs.size()) {
                return;
            }
            for (i = 0; i < partycnames.size(); ++i) {
                DynamicObject supplier2 = ((DynamicObject)partCs.get(i)).getDynamicObject("fbasedataid");
                if (null == supplier2) continue;
                supplier2.set("name", partycnames.get(i));
            }
            MetaDataUtil.clearEntityCache(SupplierUtil.getSupplierNameByAppId(appId));
        }
    }

    public static void handleEntrySupplierName(SupplierParam params, String entryName) {
        DynamicObject model = params.model;
        DynamicObjectCollection entrys = model.getDynamicObjectCollection(entryName);
        entrys.forEach(entry -> {
            params.model = entry;
            SupplierUtil.setSupplierName(params, entry.getDynamicObject(params.supplierObj_index));
        });
    }

    private static void setSupplierName(SupplierParam params, DynamicObject supplierObj) {
        boolean isSaveOrSubmit;
        DynamicObject model = params.model;
        String supplierName_index = params.supplierName_index;
        String oprationKey = params.oprationKey;
        String appId = params.getAppId();
        if (null == model || null == supplierObj) {
            return;
        }
        boolean bl = isSaveOrSubmit = OperationUtil.isSubmitOp(oprationKey) || OperationUtil.isSaveOp(oprationKey);
        if (isSaveOrSubmit) {
            LocaleString names = SupplierUtil.getMultiLangSupplierName(new Object[]{supplierObj.getPkValue()}, appId);
            model.set(supplierName_index, (Object)names);
        } else {
            Object name = model.get(supplierName_index);
            if (null != name && StringUtils.isNotEmpty((String)name.toString())) {
                supplierObj.set("name", model.get(supplierName_index));
            }
            MetaDataUtil.clearEntityCache(SupplierUtil.getSupplierNameByAppId(params.getAppId()));
        }
    }

    private static LocaleString getMultiLangSupplierName(Object[] supplierIds, String appId) {
        DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)SupplierUtil.getSupplierNameByAppId(appId), (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)supplierIds)});
        Object[] names = Arrays.stream(suppliers).map(supplier -> supplier.get("name")).toArray();
        LocaleString resultName = new LocaleString();
        if (names.length == 0) {
            return resultName;
        }
        HashMap<String, StringBuilder> map = new HashMap<String, StringBuilder>(16);
        ((OrmLocaleValue)names[0]).entrySet().forEach(entry -> map.put((String)entry.getKey(), new StringBuilder((String)entry.getValue())));
        for (int i = 1; i < names.length; ++i) {
            ((OrmLocaleValue)names[i]).entrySet().forEach(entry -> {
                StringBuilder val = (StringBuilder)map.get(entry.getKey());
                Optional.ofNullable(val).ifPresent(v -> v.append(';').append((String)entry.getValue()));
            });
        }
        map.forEach((k, v) -> {
            String cfr_ignored_0 = (String)resultName.put(k, (Object)v.toString());
        });
        return resultName;
    }
}

