/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.mservice.bill;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.common.enums.BizStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.mservice.bill.IPayReqBillService;

public class PayReqBillServiceImpl
implements IPayReqBillService {
    public static final String PAY_SOURCEPK = "sourcepk";
    public static final String PAY_TARGETPK = "targetpk";
    public static final String PAY_OPERATE = "operate";
    public static final String PAY_SRCENTRYID = "sourceentrypk";
    public static final String PAY_AMOUNT = "amount";
    public static final String PAY_LOCALAMT = "localamt";

    public String getAppId() {
        return "concs";
    }

    public boolean paySyncReqBill(List<Map<String, Object>> dataList) {
        DynamicObject[] paymentBills;
        if (dataList == null || dataList.size() == 0) {
            return false;
        }
        if (null == dataList.get(0).get(PAY_SOURCEPK)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u6e90\u5355ID\uff0c\u53cd\u5199\u5931\u8d25\uff01", (String)"PayReqBillServiceImpl_0", (String)"pccs-concs-mservice", (Object[])new Object[0]));
        }
        Long payReqBillId = (Long)dataList.get(0).get(PAY_SOURCEPK);
        Long paymentBillId = (Long)dataList.get(0).get(PAY_TARGETPK);
        String operateType = String.valueOf(dataList.get(0).get(PAY_OPERATE));
        HashMap<String, Map<String, Object>> datas = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> entryData = dataList.get(i);
            String srcEntryId = String.valueOf(entryData.get(PAY_SRCENTRYID));
            if (null == srcEntryId) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5206\u5f55\u7684\u6e90\u5355\u5206\u5f55ID\u4e0d\u5b58\u5728\uff0c\u53cd\u5199\u5931\u8d25\uff01", (String)"PayReqBillServiceImpl_1", (String)"pccs-concs-mservice", (Object[])new Object[0]));
            }
            this.handleCurPayData(operateType, srcEntryId, entryData, datas);
        }
        DynamicObject payReqBill = BusinessDataServiceHelper.loadSingle((Object)payReqBillId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)this.getSelectorStr());
        if (null == payReqBill) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u9009\u62e9\u4ed8\u6b3e\u5355\u5bf9\u5e94\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff0c\u53cd\u5199\u5931\u8d25\uff01", (String)"PayReqBillServiceImpl_2", (String)"pccs-concs-mservice", (Object[])new Object[0]));
        }
        for (DynamicObject paymentBill : paymentBills = this.getPaymentBills(payReqBillId, paymentBillId)) {
            this.handlePaymentBill(paymentBill, datas);
        }
        this.setPayDetail(payReqBill, datas);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payReqBill});
        this.syncPayedAmtConCenter(payReqBill);
        return true;
    }

    protected void syncPayedAmtConCenter(DynamicObject payReqBill) {
        if (null != payReqBill.getDynamicObject("contractbill")) {
            DynamicObject contractBill = payReqBill.getDynamicObject("contractbill");
            ContractCenterHelper.syncPayedAmt2CC((String)this.getAppId(), (long)contractBill.getLong("id"));
        }
    }

    protected void handleCurPayData(String operateType, String srcEntryId, Map<String, Object> entryData, Map<String, Map<String, Object>> paymentDataMap) {
        HashMap<String, BigDecimal> payMap = new HashMap<String, BigDecimal>();
        if ("pay".equals(operateType)) {
            payMap.put("e_actamt", NumberUtil.add(payMap.get("e_actamt"), (Object)entryData.get(PAY_AMOUNT)));
            payMap.put("e_localamt", NumberUtil.add(payMap.get("e_localamt"), (Object)entryData.get(PAY_LOCALAMT)));
        } else {
            payMap.put("e_actamt", NumberUtil.ZERO);
            payMap.put("e_localamt", NumberUtil.ZERO);
        }
        paymentDataMap.put(srcEntryId, payMap);
    }

    protected void handlePaymentBill(DynamicObject paymentBill, Map<String, Map<String, Object>> datas) {
        if (null == paymentBill) {
            return;
        }
        DynamicObjectCollection payEntrys = paymentBill.getDynamicObjectCollection("entry");
        if (payEntrys.size() > 0) {
            for (int i = 0; i < payEntrys.size(); ++i) {
                this.setPayedAmtMap((DynamicObject)payEntrys.get(i), datas);
            }
        }
    }

    private void setPayedAmtMap(DynamicObject entry, Map<String, Map<String, Object>> datas) {
        String srcEntryId = entry.getString("e_sourcebillentryid");
        Map<String, Object> payMap = datas.get(srcEntryId);
        if (null == payMap) {
            payMap = new HashMap<String, Object>();
            datas.put(srcEntryId, payMap);
        }
        payMap.put("e_actamt", NumberUtil.add((Object)payMap.get("e_actamt"), (Object)entry.getBigDecimal("e_actamt")));
        payMap.put("e_localamt", NumberUtil.add((Object)payMap.get("e_localamt"), (Object)entry.getBigDecimal("e_localamt")));
    }

    private DynamicObject[] getPaymentBills(Long payReqId, Long paymentId) {
        return BusinessDataServiceHelper.load((String)"cas_paybill", (String)String.join((CharSequence)",", "entry", "e_corebillentryseq", "e_actamt", "e_localamt", "e_sourcebillentryid"), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)payReqId), new QFilter("billstatus", "=", (Object)"D"), new QFilter("id", "!=", (Object)paymentId)});
    }

    protected void setPayDetail(DynamicObject payReqBill, Map<String, Map<String, Object>> datas) {
        DynamicObjectCollection payDetailEntrys = payReqBill.getDynamicObjectCollection("payreqdetailentry");
        int entrySize = payDetailEntrys.size();
        if (entrySize == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u4e0d\u5b58\u5728\uff0c\u53cd\u5199\u5931\u8d25\uff01", (String)"PayReqBillServiceImpl_3", (String)"pccs-concs-mservice", (Object[])new Object[0]));
        }
        BigDecimal payedOriAmt = NumberUtil.ZERO;
        BigDecimal payedAmount = NumberUtil.ZERO;
        BigDecimal payedConOriAmt = NumberUtil.ZERO;
        BigDecimal payedConAmount = NumberUtil.ZERO;
        boolean isCompletePay = false;
        for (int j = 0; j < entrySize; ++j) {
            DynamicObject payEntry = (DynamicObject)payDetailEntrys.get(j);
            String entryId = String.valueOf(payEntry.getPkValue());
            Map<String, Object> map = datas.get(entryId);
            if (null == map) continue;
            BigDecimal payOriAmt = NumberUtil.toBigDecimal((Object)map.get("e_actamt"));
            BigDecimal payAmount = NumberUtil.toBigDecimal((Object)map.get("e_localamt"));
            if (NumberUtil.compareTo((Object)payOriAmt.abs(), (Object)NumberUtil.toBigDecimal((Object)payEntry.get("payentry_oriamt")).abs()) > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5206\u5f55\u7684%1$s\uff0c\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7684%2$s\u91d1\u989d\uff0c\u4e0d\u80fd\u4ed8\u6b3e\uff01", (String)"PayReqBillServiceImpl_4", (String)"pccs-concs-mservice", (Object[])new Object[0]), payEntry.get("payentry_description"), payEntry.get("payentry_description")));
            }
            payEntry.set("payentry_payedoriamt", (Object)payOriAmt);
            payEntry.set("payentry_payedamount", (Object)payAmount);
            payedOriAmt = NumberUtil.add((Object)payedOriAmt, (Object)payOriAmt);
            payedAmount = NumberUtil.add((Object)payedAmount, (Object)payAmount);
            int entrySeq = payEntry.getInt("payentry_entryseq");
            if (entrySeq == 1 || entrySeq == 2) {
                payedConOriAmt = NumberUtil.add((Object)payedConOriAmt, (Object)payOriAmt);
                payedConAmount = NumberUtil.add((Object)payedConAmount, (Object)payAmount);
            }
            if (entrySeq != 1 || NumberUtil.compareTo((Object)payOriAmt, (Object)NumberUtil.toBigDecimal((Object)payEntry.get("payentry_oriamt"))) != 0) continue;
            isCompletePay = true;
        }
        if (isCompletePay) {
            payReqBill.set("bizstatus", (Object)BizStatusEnum.FINISHED.getValue());
        } else {
            payReqBill.set("bizstatus", null);
        }
        payReqBill.set("payedoriamt", (Object)payedOriAmt);
        payReqBill.set("payedamt", (Object)payedAmount);
        payReqBill.set("payedconoriamt", (Object)payedConOriAmt);
        payReqBill.set("payedconamt", (Object)payedConAmount);
    }

    protected String getSelectorStr() {
        String selectorStr = String.join((CharSequence)",", "id", "payedoriamt", "payedamt", "payedconoriamt", "payedconamt", "payreqdetailentry", "payentry_entryseq", "payentry_oriamt", "payentry_amount", "payentry_payedoriamt", "payentry_payedamount", "payentry_description", "contractbill", "bizstatus");
        return selectorStr;
    }
}

