/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.billtpl;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import org.apache.commons.lang.StringUtils;

public class BillSaveOpPlugin
extends AbstractOperationServicePlugIn {
    protected String getAppId() {
        return this.billEntityType.getAppId();
    }

    public final void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AbstractBillValidator(){

            public void validate() {
                if (!OperationUtil.isSaveOp((String)this.getOperateKey())) {
                    return;
                }
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    BillSaveOpPlugin.this.checkBeforeOperation(this, dataEntity);
                }
            }
        });
    }

    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject billObj = dataEntity.getDataEntity();
        if (StringUtils.isEmpty((String)billObj.getString("billno"))) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (String)"BillSaveOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (null == billObj.get("org")) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a!", (String)"BillSaveOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Arrays.stream(e.getDataEntities()).forEach(model -> this.beforeSaveTransaction(e, (DynamicObject)model));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Arrays.stream(e.getDataEntities()).forEach(model -> this.afterSaveTransaction(e, (DynamicObject)model));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Arrays.stream(e.getDataEntities()).forEach(model -> this.beginSaveTransaction(e, (DynamicObject)model));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Arrays.stream(e.getDataEntities()).forEach(model -> this.endSaveTransaction(e, (DynamicObject)model));
    }

    protected void beforeSaveTransaction(BeforeOperationArgs args, DynamicObject model) {
    }

    protected void afterSaveTransaction(AfterOperationArgs args, DynamicObject model) {
    }

    protected void beginSaveTransaction(BeginOperationTransactionArgs args, DynamicObject model) {
        this.handlerApplyAmt(model);
        this.syncSupplierName(model);
    }

    protected void endSaveTransaction(EndOperationTransactionArgs args, DynamicObject model) {
    }

    protected void handlerApplyAmt(DynamicObject billObj) {
        DataEntityPropertyCollection properties = billObj.getDynamicObjectType().getProperties();
        if (!properties.containsKey((Object)"applyoriamt") || !properties.containsKey((Object)"oriamt")) {
            return;
        }
        Object oriamt = billObj.get("oriamt");
        Object amount = billObj.get("amount");
        billObj.set("applyoriamt", oriamt);
        billObj.set("applyamt", amount);
    }

    protected void syncSupplierName(DynamicObject model) {
    }
}

