/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.chgcfmbill;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.business.helper.ChgBillHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.common.util.ParameterUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.helper.EstChgCheckOpHelper;
import org.apache.commons.lang.StringUtils;

public class ChgCfmBillOpHelper {
    public void onPreparePropertys(List<String> fieldKeys) {
        fieldKeys.add("billno");
        fieldKeys.add("billname");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("billstatus");
        fieldKeys.add("bizstatus");
        fieldKeys.add("bizdate");
        fieldKeys.add("refbillstatus");
        fieldKeys.add("org");
        fieldKeys.add("project");
        fieldKeys.add("contractbill");
        fieldKeys.add("chgaudit");
        fieldKeys.add("supplier");
        fieldKeys.add("suppliername");
        fieldKeys.add("handler");
        fieldKeys.add("multitaxrateflag");
        fieldKeys.add("foreigncurrencyflag");
        fieldKeys.add("exchangerate");
        fieldKeys.add("applyoriamt");
        fieldKeys.add("applyamt");
        fieldKeys.add("oriamt");
        fieldKeys.add("amount");
        fieldKeys.add("changereason");
        fieldKeys.add("chgtype");
        fieldKeys.add("urgentdegree");
    }

    public void updateChgAuditf7Data(String appId, DynamicObject chgCfmBill) {
        DynamicObject[] chgAuditf7Col;
        if (!QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)appId, (String)"chgcfmbill"), (Object)chgCfmBill.getPkValue())) {
            return;
        }
        DynamicObject chgCfmBillInfo = BusinessDataServiceHelper.loadSingle((Object)chgCfmBill.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"chgcfmbill"));
        DynamicObject chgAudit = chgCfmBillInfo.getDynamicObject("chgaudit");
        if (null == chgAudit) {
            return;
        }
        DynamicObject tempChgAudit = chgCfmBill.getDynamicObject("chgaudit");
        if (!(null != tempChgAudit && chgAudit.getPkValue().equals(tempChgAudit.getPkValue()) || (chgAuditf7Col = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"chgaudit_f7"), (String)String.join((CharSequence)",", "id", "billid", "refbillstatus", "refbillid"), (QFilter[])new QFilter[]{new QFilter("refbillid", "=", chgCfmBill.getPkValue())})).length <= 0)) {
            for (DynamicObject chgAuditf7 : chgAuditf7Col) {
                chgAuditf7.set("refbillstatus", (Object)" ");
                chgAuditf7.set("refbillid", null);
                SaveServiceHelper.update((DynamicObject)chgAuditf7);
            }
        }
    }

    public void updateConChgRefBillStatus(String appId, DynamicObject model, String billStatus) {
        Object chgaudit = model.get("chgaudit");
        if (null != chgaudit) {
            DynamicObject conChgBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"conchgbill"), (String)"refbillstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", ((DynamicObject)chgaudit).get("billid"))});
            conChgBill.set("refbillstatus", (Object)billStatus);
            SaveServiceHelper.update((DynamicObject)conChgBill);
        }
    }

    public void updateChgAuditf7Data(String appId, DynamicObject chgCfmBill, String billStatus) {
        DynamicObject[] chgAuditf7Col;
        DynamicObject chgCfmBillInfo = BusinessDataServiceHelper.loadSingle((Object)chgCfmBill.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"chgcfmbill"));
        if (null != chgCfmBillInfo && null != chgCfmBillInfo.get("chgaudit") && (chgAuditf7Col = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"chgaudit_f7"), (String)StringUtils.join((Object[])new Object[]{"billid", "refbillstatus", "refbillid", "id"}, (String)","), (QFilter[])new QFilter[]{new QFilter("id", "=", chgCfmBill.getDynamicObject("chgaudit").getPkValue())})).length > 0) {
            for (DynamicObject chgAuditf7 : chgAuditf7Col) {
                chgAuditf7.set("refbillstatus", (Object)billStatus);
                if (StringUtils.isBlank((String)billStatus)) {
                    chgAuditf7.set("refbillid", null);
                } else {
                    chgAuditf7.set("refbillid", chgCfmBill.getPkValue());
                }
                SaveServiceHelper.update((DynamicObject)chgAuditf7);
            }
        }
    }

    public void checkOverConEstChg(String appId, AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject model = dataEntity.getDataEntity();
        DynamicObject org = model.getDynamicObject("org");
        Long orgId = org.getLong("id");
        String operateKey = validator.getOperateKey();
        String parameter = ParameterUtil.getParameter((String)appId, (String)"param_estchgctrl", (Long)orgId);
        DynamicObject contractBill = model.getDynamicObject("contractbill");
        Long contractBillId = (Long)contractBill.getPkValue();
        contractBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (String)String.join((CharSequence)",", "estchgoriamt", "billname"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)contractBillId)});
        Long billId = (Long)model.getPkValue();
        DynamicObject chgAudit = model.getDynamicObject("chgaudit");
        Map conChgAmt = null != chgAudit ? new ChgBillHelper().getChgAmtIncSupply(appId, contractBillId.longValue(), false, new Long[]{chgAudit.getLong("billid"), billId}) : new ChgBillHelper().getChgAmtIncSupply(appId, contractBillId.longValue(), false, new Long[]{billId});
        BigDecimal chgAmountSum = (BigDecimal)conChgAmt.get("oriamt");
        BigDecimal billAmt = model.getBigDecimal("oriamt");
        if (OperationUtil.isSubmitOp((String)operateKey)) {
            chgAmountSum = NumberUtil.toBigDecimal((Object)NumberUtil.add((Object)chgAmountSum, (Object)billAmt), (int)2);
        }
        if (OperationUtil.isUnAuditOp((String)operateKey)) {
            BigDecimal chgAuditOriAmt = null;
            if (null != chgAudit) {
                chgAuditOriAmt = chgAudit.getBigDecimal("oriamt");
            }
            chgAmountSum = NumberUtil.toBigDecimal((Object)NumberUtil.add((Object)chgAmountSum, chgAuditOriAmt), (int)2);
        }
        EstChgCheckOpHelper.checkOverConEstChg(validator, dataEntity, parameter, chgAmountSum, contractBill);
    }
}

