/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.chgcfmbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSubmitOpPlugin;
import kd.pccs.concs.opplugin.chgcfmbill.ChgCfmBillOpHelper;

public class ChgCfmBillSubmitOpPlugin
extends BillSubmitOpPlugin {
    protected ChgCfmBillOpHelper getOpHelper() {
        return new ChgCfmBillOpHelper();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        this.getOpHelper().onPreparePropertys(fieldKeys);
        fieldKeys.add("taxentry");
        fieldKeys.add("taxentry_amount");
        fieldKeys.add("taxentry_oriamt");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        if (dataEntity.getDataEntity().getDynamicObject("project") == null) {
            return;
        }
        this.checkTaxEntrySumAmount(validator, dataEntity);
        this.checkEstChgAmt(validator, dataEntity);
    }

    protected void checkEstChgAmt(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        this.getOpHelper().checkOverConEstChg(this.getAppId(), validator, dataEntity);
    }

    private void checkTaxEntrySumAmount(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject billObj = dataEntity.getDataEntity();
        if (!billObj.getBoolean("multitaxrateflag")) {
            return;
        }
        BigDecimal oriAmt = billObj.getBigDecimal("oriamt");
        BigDecimal amount = billObj.getBigDecimal("amount");
        DynamicObjectCollection taxEntryColl = billObj.getDynamicObjectCollection("taxentry");
        BigDecimal sumOriAmt = null;
        BigDecimal sumAmount = null;
        for (DynamicObject entryObj : taxEntryColl) {
            sumOriAmt = NumberUtil.add(sumOriAmt, (Object)entryObj.getBigDecimal("taxentry_oriamt"));
            sumAmount = NumberUtil.add(sumAmount, (Object)entryObj.getBigDecimal("taxentry_amount"));
        }
        if (billObj.getBoolean("foreigncurrencyflag") && NumberUtil.compareTo((Object)oriAmt, sumOriAmt) != 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u53d8\u66f4\u786e\u8ba4\u91d1\u989d(\u539f\u5e01)\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u53d8\u66f4\u786e\u8ba4\u91d1\u989d(\u539f\u5e01)\u7684\u5408\u8ba1\u503c\"\u4e0d\u76f8\u7b49,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ChgCfmBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (NumberUtil.compareTo((Object)amount, sumAmount) != 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u53d8\u66f4\u786e\u8ba4\u91d1\u989d\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u542b\u7a0e\u91d1\u989d\"\u7684\u5408\u8ba1\u503c\u4e0d\u76f8\u7b49,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ChgCfmBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void beginSubmitTransaction(BeginOperationTransactionArgs args, DynamicObject model) {
        super.beginSubmitTransaction(args, model);
        this.getOpHelper().updateChgAuditf7Data(this.getAppId(), model);
    }

    @Override
    protected void endSubmitTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endSubmitTransaction(args, model);
        ChgCfmBillOpHelper opHelper = this.getOpHelper();
        opHelper.updateConChgRefBillStatus(this.getAppId(), model, model.get("billstatus").toString());
        opHelper.updateChgAuditf7Data(this.getAppId(), model, model.get("billstatus").toString());
    }

    @Override
    protected void syncSupplierName(DynamicObject model) {
        super.syncSupplierName(model);
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("supplier", "suppliername", this.billEntityType.getExtendName(), model, "submit"));
    }
}

