/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.conchgbill;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.business.helper.ChgBillHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.common.util.ParameterUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.helper.EstChgCheckOpHelper;

public class ConChgBillOpHelper {
    public void onPreparePropertys(List<String> fieldKeys) {
        fieldKeys.add("billno");
        fieldKeys.add("billname");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("billstatus");
        fieldKeys.add("bizstatus");
        fieldKeys.add("bizdate");
        fieldKeys.add("refbillstatus");
        fieldKeys.add("urgentdegree");
        fieldKeys.add("changereason");
        fieldKeys.add("org");
        fieldKeys.add("project");
        fieldKeys.add("contractbill");
        fieldKeys.add("supplier");
        fieldKeys.add("suppliername");
        fieldKeys.add("handler");
        fieldKeys.add("multitaxrateflag");
        fieldKeys.add("foreigncurrencyflag");
        fieldKeys.add("oricurrency");
        fieldKeys.add("currency");
        fieldKeys.add("exchangerate");
        fieldKeys.add("applyoriamt");
        fieldKeys.add("applyamt");
        fieldKeys.add("oriamt");
        fieldKeys.add("amount");
        fieldKeys.add("taxrate");
    }

    public void checkOverConEstChg(String appId, AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject model = dataEntity.getDataEntity();
        DynamicObject org = model.getDynamicObject("org");
        Long orgId = org.getLong("id");
        String parameter = ParameterUtil.getParameter((String)appId, (String)"param_estchgctrl", (Long)orgId);
        if ("no".equals(parameter)) {
            return;
        }
        DynamicObject contractBill = model.getDynamicObject("contractbill");
        Long contractBillId = (Long)contractBill.getPkValue();
        contractBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (String)String.join((CharSequence)",", "estchgoriamt", "billname"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)contractBillId)});
        Map conChgAmt = new ChgBillHelper().getChgAmtIncSupply(appId, contractBillId.longValue(), false, new Long[]{(Long)model.getPkValue()});
        BigDecimal chgAmountSum = (BigDecimal)conChgAmt.get("oriamt");
        BigDecimal billAmt = model.getBigDecimal("oriamt");
        if (OperationUtil.isSubmitOp((String)validator.getOperateKey())) {
            chgAmountSum = NumberUtil.toBigDecimal((Object)NumberUtil.add((Object)chgAmountSum, (Object)billAmt), (int)2);
        }
        EstChgCheckOpHelper.checkOverConEstChg(validator, dataEntity, parameter, chgAmountSum, contractBill);
    }
}

