/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.conchgbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.pccs.concs.business.helper.ChgAuditHelper;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSubmitOpPlugin;
import kd.pccs.concs.opplugin.conchgbill.ConChgBillOpHelper;

public class ConChgBillSubmitOpPlugin
extends BillSubmitOpPlugin {
    protected ConChgBillOpHelper getOpHelper() {
        return new ConChgBillOpHelper();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        this.getOpHelper().onPreparePropertys(fieldKeys);
        fieldKeys.add("taxentry");
        fieldKeys.add("taxentry_amount");
        fieldKeys.add("taxentry_oriamt");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        this.checkTaxEntrySumAmount(validator, dataEntity);
        this.getOpHelper().checkOverConEstChg(this.getAppId(), validator, dataEntity);
    }

    private void checkTaxEntrySumAmount(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject billObj = dataEntity.getDataEntity();
        if (!billObj.getBoolean("multitaxrateflag")) {
            return;
        }
        BigDecimal oriAmt = billObj.getBigDecimal("oriamt");
        BigDecimal amount = billObj.getBigDecimal("amount");
        DynamicObjectCollection taxEntryColl = billObj.getDynamicObjectCollection("taxentry");
        BigDecimal sumOriAmt = null;
        BigDecimal sumAmount = null;
        for (DynamicObject entryObj : taxEntryColl) {
            sumOriAmt = NumberUtil.add(sumOriAmt, (Object)entryObj.getBigDecimal("taxentry_oriamt"));
            sumAmount = NumberUtil.add(sumAmount, (Object)entryObj.getBigDecimal("taxentry_amount"));
        }
        if (billObj.getBoolean("foreigncurrencyflag") && NumberUtil.compareTo((Object)oriAmt, sumOriAmt) != 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u53d8\u66f4\u91d1\u989d(\u539f\u5e01)\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u53d8\u66f4\u7533\u62a5\u91d1\u989d(\u539f\u5e01)\u7684\u5408\u8ba1\u503c\"\u4e0d\u76f8\u7b49,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConChgBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (NumberUtil.compareTo((Object)amount, sumAmount) != 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u53d8\u66f4\u91d1\u989d\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u542b\u7a0e\u91d1\u989d\"\u7684\u5408\u8ba1\u503c\u4e0d\u76f8\u7b49,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConChgBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void endSubmitTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endSubmitTransaction(args, model);
        new ChgAuditHelper().synChgBillData2ChgAuditf7(this.getAppId(), model, "submit");
    }

    @Override
    protected void syncSupplierName(DynamicObject model) {
        super.syncSupplierName(model);
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("supplier", "suppliername", this.billEntityType.getExtendName(), model, "submit"));
    }
}

