/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.conchgbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ChgAuditHelper;
import kd.pccs.concs.business.helper.ContractBillHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.business.helper.PayReqBillHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillUnAuditOpPlugin;
import kd.pccs.concs.opplugin.conchgbill.ConChgBillOpHelper;

public class ConChgBillUnAuditOpPlugin
extends BillUnAuditOpPlugin {
    protected ConChgBillOpHelper getOpHelper() {
        return new ConChgBillOpHelper();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        this.getOpHelper().onPreparePropertys(fieldKeys);
        fieldKeys.add("taxentry");
        fieldKeys.add("taxentry_amount");
        fieldKeys.add("taxentry_oriamt");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject model = dataEntity.getDataEntity();
        DynamicObject contractBill = model.getDynamicObject("contractbill");
        long conId = contractBill.getLong("id");
        boolean existsConSettleFlag = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", (Object)conId)});
        if (existsConSettleFlag) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5408\u540c\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"ConChgBillUnAuditOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            return;
        }
        boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"chgaudit_f7"), (QFilter[])new QFilter[]{new QFilter("billid", "=", model.getPkValue()), new QFilter("refbillid", "!=", (Object)0L)});
        if (exists) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u53d8\u66f4\u786e\u8ba4\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"ConChgBillUnAuditOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            return;
        }
        boolean moreThanPayReqAmtFlag = PayReqBillHelper.checkMoreThanPayReqAmt((String)this.getAppId(), (Long)conId, (BigDecimal)model.getBigDecimal("oriamt"), (BigDecimal)BigDecimal.ZERO);
        if (moreThanPayReqAmtFlag) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5408\u540c\u53d8\u66f4\u53cd\u5ba1\u6279\u540e\uff0c\u5b58\u5728\u8d85\u4ed8\u73b0\u8c61\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279", (String)"ConChgBillUnAuditOpPlugin_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        this.getOpHelper().checkOverConEstChg(this.getAppId(), validator, dataEntity);
    }

    @Override
    protected void endUnAuditTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endUnAuditTransaction(args, model);
        new ChgAuditHelper().synChgBillData2ChgAuditf7(this.getAppId(), model, "unaudit");
        this.syncContractData(model);
    }

    protected void syncContractData(DynamicObject model) {
        DynamicObject contractBill = model.getDynamicObject("contractbill");
        long conBillId = contractBill.getLong("id");
        new ContractBillHelper().updateContractInfo(this.getAppId(), conBillId);
        new ContractCenterHelper().syncChgAmt2CC(this.getAppId(), conBillId);
        ContractCenterHelper.synContractCenterInfo((String)this.getAppId(), (long)conBillId);
    }
}

