/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.conrevisebill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.pccs.concs.business.helper.EstChgAdjustBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OrgUtil;
import kd.pccs.concs.common.util.ParameterUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.contractbill.ContractBillSubmitOpPlugin;

public class ConReviseBillSubmitOpPlugin
extends ContractBillSubmitOpPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("contractbill");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        this.checkEstSettleAmt(validator, dataEntity);
        this.checkEstChgAmt(validator, dataEntity);
    }

    protected void checkEstSettleAmt(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject conReviseObj = dataEntity.getDataEntity();
        Long conId = (Long)conReviseObj.getDynamicObject("contractbill").getPkValue();
        DynamicObject conObj = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "id", "latestoriprice", "latestprice"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)conId)});
        BigDecimal estsettleoriamt = conReviseObj.getBigDecimal("estsettleoriamt");
        if (NumberUtil.compareTo((Object)estsettleoriamt, (Object)conObj.getBigDecimal("latestoriprice")) < 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fee\u8ba2\u540e\u9884\u4f30\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u5408\u540c\u6700\u65b0\u9020\u4ef7,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConReviseBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    protected void checkEstChgAmt(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        String confirmResultString;
        InteractionConfirmResult confirmResult;
        BigDecimal conUsedOriamt;
        DynamicObject conReviseObj = dataEntity.getDataEntity();
        String param = this.getEstChgControl(conReviseObj);
        if ("no".equals(param)) {
            return;
        }
        Long conId = (Long)conReviseObj.getDynamicObject("contractbill").getPkValue();
        BigDecimal estchgoriamt = conReviseObj.getBigDecimal("estchgoriamt");
        if (NumberUtil.compareTo((Object)estchgoriamt, (Object)(conUsedOriamt = new EstChgAdjustBillHelper().getConUsedEstChgOriAmt(this.getAppId(), conId))) >= 0) {
            return;
        }
        if ("strict".equals(param)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u8ba2\u540e\u9884\u4f30\u53d8\u66f4\u91d1\u989d\u5c0f\u4e8e\u5df2\u53d1\u751f\u53d8\u66f4\u91d1\u989d,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConReviseBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if ("tip".equals(param) && !(confirmResult = InteractionConfirmResult.fromJsonString((String)(confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "")))).getResults().containsKey("overEstChgAmtIndex")) {
            InteractionContext interactionContext = new InteractionContext();
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(ResManager.loadKDString((String)"\u4fee\u8ba2\u540e\u9884\u4f30\u53d8\u66f4\u91d1\u989d\u5c0f\u4e8e\u5df2\u53d1\u751f\u53d8\u66f4\u91d1\u989d", (String)"ConReviseBillSubmitOpPlugin_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            errorInfo.setLevel(ErrorLevel.Warning);
            interactionContext.addOperateInfo(errorInfo);
            throw new KDInteractionException("overEstChgAmtIndex", interactionContext);
        }
    }

    @Override
    protected void submitConPayPlan(Long conId) {
        String conPlayPlanEntityID = MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan");
        DynamicObject conpayplanObj = BusinessDataServiceHelper.loadSingle((String)conPlayPlanEntityID, (String)this.getConPayPlanSelectProperties(), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVED.getValue()), new QFilter("conrevisebill", "=", (Object)conId)});
        if (null != conpayplanObj) {
            OperationServiceHelper.executeOperate((String)"submit", (String)conPlayPlanEntityID, (DynamicObject[])new DynamicObject[]{conpayplanObj}, (OperateOption)OperateOption.create());
        }
    }

    @Override
    protected String getConPayPlanSelectProperties() {
        return String.join((CharSequence)",", "id", "billno", "billname", "billstatus", "auditor", "auditdate", "oriamt", "project", "contractbill", "conrevisebill", "schentry_paymenttype", "schentry_payway", "schentry_begindate", "schentry_enddate", "schentry_paydate", "schentry_payscale", "schentry_payoriamt", "schentry_payamt", "schentry_preflushoriamt", "schentry_preflushamt", "planentry_paymonth", "planentry_payoriamt", "planentry_payamt");
    }

    protected String getEstChgControl(DynamicObject conReviseObj) {
        String param = ParameterUtil.getParameter((String)this.getAppId(), (String)"param_estchgctrl", (Long)OrgUtil.getCurrentOrgId((DynamicObject)conReviseObj));
        return param;
    }

    @Override
    protected void syncContractCenterInfo(DynamicObject object) {
    }
}

