/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.consettlebill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSubmitOpPlugin;

public class ConSettleBillSubmitOpPlugin
extends BillSubmitOpPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("billno");
        fieldKeys.add("billname");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("org");
        fieldKeys.add("project");
        fieldKeys.add("billstatus");
        fieldKeys.add("bizstatus");
        fieldKeys.add("bizdate");
        fieldKeys.add("applyoriamt");
        fieldKeys.add("applyamt");
        fieldKeys.add("oriamt");
        fieldKeys.add("amount");
        fieldKeys.add("contractbill");
        fieldKeys.add("handler");
        fieldKeys.add("exchangerate");
        fieldKeys.add("multitaxrateflag");
        fieldKeys.add("foreigncurrencyflag");
        fieldKeys.add("taxentry");
        fieldKeys.add("taxentry_amount");
        fieldKeys.add("taxentry_oriamt");
        fieldKeys.add("settledataentry");
        fieldKeys.add("dataentry_datastandard");
        fieldKeys.add("dataentry_reportflag");
        fieldKeys.add("partyb");
        fieldKeys.add("partybname");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        this.checkTaxEntrySumAmount(validator, dataEntity);
        this.checkDataStdIsReport(validator, dataEntity);
    }

    protected void checkTaxEntrySumAmount(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject billObj = dataEntity.getDataEntity();
        if (!billObj.getBoolean("multitaxrateflag")) {
            return;
        }
        BigDecimal oriAmt = billObj.getBigDecimal("oriamt");
        BigDecimal amount = billObj.getBigDecimal("amount");
        DynamicObjectCollection taxEntryColl = billObj.getDynamicObjectCollection("taxentry");
        BigDecimal sumOriAmt = null;
        BigDecimal sumAmount = null;
        for (DynamicObject entryObj : taxEntryColl) {
            sumOriAmt = NumberUtil.add(sumOriAmt, (Object)entryObj.getBigDecimal("taxentry_oriamt"));
            sumAmount = NumberUtil.add(sumAmount, (Object)entryObj.getBigDecimal("taxentry_amount"));
        }
        if (billObj.getBoolean("foreigncurrencyflag") && NumberUtil.compareTo((Object)oriAmt, sumOriAmt) != 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u7ed3\u7b97\u91d1\u989d(\u539f\u5e01)\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u7ed3\u7b97\u91d1\u989d(\u539f\u5e01)\u7684\u5408\u8ba1\u503c\"\u4e0d\u76f8\u7b49,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConSettleBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (NumberUtil.compareTo((Object)amount, sumAmount) != 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u7ed3\u7b97\u91d1\u989d\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u542b\u7a0e\u91d1\u989d\u7684\u5408\u8ba1\u503c\"\u4e0d\u76f8\u7b49,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConSettleBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    protected void checkDataStdIsReport(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject settleObj = dataEntity.getDataEntity();
        DynamicObjectCollection dataStandEntrys = settleObj.getDynamicObjectCollection("settledataentry");
        if (dataStandEntrys.size() > 0) {
            for (DynamicObject dataStandEntry : dataStandEntrys) {
                Boolean verifyReport;
                DynamicObject dataStandard = (DynamicObject)dataStandEntry.get("dataentry_datastandard");
                Boolean isRequired = dataStandard.getBoolean("isrequired");
                if (!isRequired.booleanValue() || (verifyReport = Boolean.valueOf(dataStandEntry.getBoolean("dataentry_reportflag"))).booleanValue()) continue;
                validator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u8d44\u6599\u201c%s\u201d\u672a\u6838\u5b9e\u4e0a\u62a5\uff0c\u8bf7\u5f55\u5165\uff01", (String)"ConSettleBillSubmitOpPlugin_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]), dataStandard.getString("name")));
            }
        }
    }

    @Override
    protected void syncSupplierName(DynamicObject model) {
        super.syncSupplierName(model);
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("partyb", "partybname", this.billEntityType.getExtendName(), model, "submit"));
    }
}

