/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.contractbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.common.enums.BizStatusEnum;
import kd.pccs.concs.opplugin.billtpl.BillAuditOpPlugin;
import kd.pccs.concs.opplugin.contractbill.ContractBillOpHelper;

public class ContractBillAuditOpPlugin
extends BillAuditOpPlugin {
    protected ContractBillOpHelper getOpHelper() {
        return new ContractBillOpHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        this.getOpHelper().onPreparePropertys(fieldKeys);
    }

    @Override
    protected void beginAuditTransaction(BeginOperationTransactionArgs args, DynamicObject model) {
        super.beginAuditTransaction(args, model);
        model.set("bizstatus", (Object)BizStatusEnum.INPROGRESS.getValue());
        model.set("latestoriprice", model.get("oriamt"));
        model.set("latestprice", model.get("amount"));
        model.set("latesttax", model.get("tax"));
    }

    @Override
    protected void afterAuditTransaction(AfterOperationArgs args, DynamicObject model) {
        super.afterAuditTransaction(args, model);
        this.syncContractCenterInfo(model);
    }

    protected void syncContractCenterInfo(DynamicObject object) {
        new ContractCenterHelper().synContractCenterInfo(this.getAppId(), object, "audit");
    }
}

