/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.contractbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSubmitOpPlugin;
import kd.pccs.concs.opplugin.contractbill.ContractBillOpHelper;

public class ContractBillSubmitOpPlugin
extends BillSubmitOpPlugin {
    protected ContractBillOpHelper getOpHelper() {
        return new ContractBillOpHelper();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        this.getOpHelper().onPreparePropertys(fieldKeys);
        fieldKeys.add("taxentry_oriamt");
        fieldKeys.add("taxentry_amount");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        this.checkTaxEntrySumAmount(validator, dataEntity);
    }

    protected void checkTaxEntrySumAmount(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject conObj = dataEntity.getDataEntity();
        if (!conObj.getBoolean("multitaxrateflag")) {
            return;
        }
        BigDecimal oriAmt = conObj.getBigDecimal("oriamt");
        BigDecimal amount = conObj.getBigDecimal("amount");
        DynamicObjectCollection taxEntryColl = conObj.getDynamicObjectCollection("taxentry");
        BigDecimal sumOriAmt = null;
        BigDecimal sumAmount = null;
        for (DynamicObject entryObj : taxEntryColl) {
            sumOriAmt = NumberUtil.add(sumOriAmt, (Object)entryObj.getBigDecimal("taxentry_oriamt"));
            sumAmount = NumberUtil.add(sumAmount, (Object)entryObj.getBigDecimal("taxentry_amount"));
        }
        if (conObj.getBoolean("foreigncurrencyflag") && NumberUtil.compareTo((Object)oriAmt, sumOriAmt) != 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u5408\u540c\u91d1\u989d(\u539f\u5e01)\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u5408\u540c\u91d1\u989d(\u539f\u5e01)\u7684\u5408\u8ba1\u503c\"\u4e0d\u76f8\u7b49,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ContractBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (NumberUtil.compareTo((Object)amount, sumAmount) != 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u5408\u540c\u91d1\u989d\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u542b\u7a0e\u91d1\u989d\"\u7684\u5408\u8ba1\u503c\u4e0d\u76f8\u7b49,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ContractBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void endSubmitTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endSubmitTransaction(args, model);
        this.submitConPayPlan((Long)model.getPkValue());
    }

    @Override
    protected void afterSubmitTransaction(AfterOperationArgs args, DynamicObject model) {
        super.afterSubmitTransaction(args, model);
        this.syncContractCenterInfo(model);
    }

    protected void submitConPayPlan(Long conId) {
        String conPayPlanEntityId = MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan");
        DynamicObject conpayplanObj = BusinessDataServiceHelper.loadSingle((String)conPayPlanEntityId, (String)this.getConPayPlanSelectProperties(), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVED.getValue()), new QFilter("contractbill", "=", (Object)conId)});
        if (null != conpayplanObj) {
            OperationServiceHelper.executeOperate((String)"submit", (String)conPayPlanEntityId, (DynamicObject[])new DynamicObject[]{conpayplanObj}, (OperateOption)OperateOption.create());
        }
    }

    protected String getConPayPlanSelectProperties() {
        return String.join((CharSequence)",", "id", "billno", "billname", "billstatus", "auditor", "auditdate", "oriamt", "project", "contractbill", "conrevisebill", "schentry_paymenttype", "schentry_payway", "schentry_begindate", "schentry_enddate", "schentry_paydate", "schentry_payscale", "schentry_payoriamt", "schentry_payamt", "schentry_preflushoriamt", "schentry_preflushamt", "planentry_paymonth", "planentry_payoriamt", "planentry_payamt");
    }

    @Override
    protected void syncSupplierName(DynamicObject model) {
        super.syncSupplierName(model);
        SupplierUtil.handleContractSupplierName((String)this.billEntityType.getExtendName(), (DynamicObject)model, (String)"submit");
    }

    protected void syncContractCenterInfo(DynamicObject object) {
        new ContractCenterHelper().synContractCenterInfo(this.getAppId(), object, "submit");
    }
}

