/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.contractbill;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.enums.BizStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillUnAuditOpPlugin;
import kd.pccs.concs.opplugin.contractbill.ContractBillOpHelper;

public class ContractBillUnAuditOpPlugin
extends BillUnAuditOpPlugin {
    protected ContractBillOpHelper getOpHelper() {
        return new ContractBillOpHelper();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        this.getOpHelper().onPreparePropertys(fieldKeys);
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        this.checkHasRef(validator, dataEntity);
    }

    protected void checkHasRef(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject conObj = dataEntity.getDataEntity();
        QFilter[] qFilters = new QFilter[]{new QFilter("contractbill", "=", conObj.getPkValue())};
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"supplyconbill"), (QFilter[])qFilters)) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8865\u5145\u5408\u540c,\u4e0d\u80fd\u53cd\u5ba1\u6838!", (String)"ContractBillUnAuditOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"estchgadjustbill"), (QFilter[])qFilters)) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5408\u540c\u9884\u4f30\u53d8\u66f4\u8c03\u6574,\u4e0d\u80fd\u53cd\u5ba1\u6838!", (String)"ContractBillUnAuditOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conrevisebill"), (QFilter[])qFilters)) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5408\u540c\u4fee\u8ba2,\u4e0d\u80fd\u53cd\u5ba1\u6838!", (String)"ContractBillUnAuditOpPlugin_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conchgbill"), (QFilter[])qFilters)) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5408\u540c\u53d8\u66f4,\u4e0d\u80fd\u53cd\u5ba1\u6838!", (String)"ContractBillUnAuditOpPlugin_3", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"chgcfmbill"), (QFilter[])qFilters)) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u53d8\u66f4\u786e\u8ba4,\u4e0d\u80fd\u53cd\u5ba1\u6838!", (String)"ContractBillUnAuditOpPlugin_4", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"stagesettlebill"), (QFilter[])qFilters)) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9636\u6bb5\u7ed3\u7b97,\u4e0d\u80fd\u53cd\u5ba1\u6838!", (String)"ContractBillUnAuditOpPlugin_5", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (QFilter[])qFilters)) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5408\u540c\u7ed3\u7b97,\u4e0d\u80fd\u53cd\u5ba1\u6838!", (String)"ContractBillUnAuditOpPlugin_6", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (QFilter[])qFilters)) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4ed8\u6b3e\u7533\u8bf7,\u4e0d\u80fd\u53cd\u5ba1\u6838!", (String)"ContractBillUnAuditOpPlugin_7", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeductbill"), (QFilter[])new QFilter[]{new QFilter("rewarddeductentry.entry_contractbill", "=", conObj.getPkValue())})) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5956\u60e9\u5355,\u4e0d\u80fd\u53cd\u5ba1\u6838!", (String)"ContractBillUnAuditOpPlugin_8", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void beginUnAuditTransaction(BeginOperationTransactionArgs args, DynamicObject model) {
        super.beginUnAuditTransaction(args, model);
        model.set("bizstatus", (Object)BizStatusEnum.TODO.getValue());
        model.set("latestoriprice", null);
        model.set("latestprice", null);
        model.set("latesttax", null);
    }

    @Override
    protected void endUnAuditTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endUnAuditTransaction(args, model);
        this.unSubmitConPayPlan((Long)model.getPkValue());
    }

    @Override
    protected void afterUnAuditTransaction(AfterOperationArgs args, DynamicObject model) {
        super.afterUnAuditTransaction(args, model);
        this.syncContractCenterInfo(model);
    }

    protected void unSubmitConPayPlan(Long conId) {
        DynamicObject conpayplanObj = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan"), (String)String.join((CharSequence)",", "id", "billstatus", "auditor", "auditdate"), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMITTED.getValue()), new QFilter("contractbill", "=", (Object)conId)});
        if (null != conpayplanObj) {
            OperationServiceHelper.executeOperate((String)"unsubmit", (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan"), (DynamicObject[])new DynamicObject[]{conpayplanObj}, (OperateOption)OperateOption.create());
        }
    }

    protected void syncContractCenterInfo(DynamicObject object) {
        new ContractCenterHelper().synContractCenterInfo(this.getAppId(), object, "unaudit");
    }
}

