/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.contractbill;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.opplugin.billtpl.BillUnSubmitOpPlugin;
import kd.pccs.concs.opplugin.contractbill.ContractBillOpHelper;

public class ContractBillUnSubmitOpPlugin
extends BillUnSubmitOpPlugin {
    protected ContractBillOpHelper getOpHelper() {
        return new ContractBillOpHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        this.getOpHelper().onPreparePropertys(e.getFieldKeys());
    }

    @Override
    protected void endUnSubmitTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endUnSubmitTransaction(args, model);
        this.unSubmitConPayPlan((Long)model.getPkValue());
    }

    @Override
    protected void afterUnSubmitTransaction(AfterOperationArgs args, DynamicObject model) {
        super.afterUnSubmitTransaction(args, model);
        this.syncContractCenterInfo(model);
    }

    protected void unSubmitConPayPlan(Long conId) {
        String conPayPlanEntityId = MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan");
        DynamicObject conpayplanObj = BusinessDataServiceHelper.loadSingle((String)conPayPlanEntityId, (String)String.join((CharSequence)",", "id", "billstatus", "auditor", "auditdate"), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMITTED.getValue()), new QFilter("contractbill", "=", (Object)conId)});
        if (null != conpayplanObj) {
            OperationServiceHelper.executeOperate((String)"unsubmit", (String)conPayPlanEntityId, (DynamicObject[])new DynamicObject[]{conpayplanObj}, (OperateOption)OperateOption.create());
        }
    }

    protected void syncContractCenterInfo(DynamicObject object) {
        new ContractCenterHelper().synContractCenterInfo(this.getAppId(), object, "unsubmit");
    }
}

