/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.estchgadjustbill;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.pccs.concs.business.helper.ContractBillHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.opplugin.billtpl.BillAuditOpPlugin;

public class EstChgAdjustBillAuditOpPlugin
extends BillAuditOpPlugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("contractbill");
        fieldKeys.add("oriamt");
        fieldKeys.add("amount");
    }

    @Override
    protected void endAuditTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endAuditTransaction(args, model);
        this.syncContractData(model);
    }

    protected void syncContractData(DynamicObject model) {
        DynamicObject contract = model.getDynamicObject("contractbill");
        Long conId = contract.getLong("id");
        BigDecimal conOriAmt = contract.getBigDecimal("oriamt");
        BigDecimal estChgOriAmt = model.getBigDecimal("oriamt");
        BigDecimal estChgAmt = model.getBigDecimal("amount");
        BigDecimal estChgScale = NumberUtil.divide((Object)estChgOriAmt, (Object)conOriAmt, (int)4).multiply(NumberUtil.ONE_HUNDRED);
        HashMap<String, BigDecimal> estChgMap = new HashMap<String, BigDecimal>();
        estChgMap.put("estchgoriamt", estChgOriAmt);
        estChgMap.put("estchgamt", estChgAmt);
        estChgMap.put("estchgscale", estChgScale);
        new ContractBillHelper().updateContractEstChgAmt(this.getAppId(), conId.longValue(), estChgMap);
        new ContractBillHelper().updateContractInfo(this.getAppId(), conId.longValue());
        ContractCenterHelper.synContractCenterInfo((String)this.getAppId(), (long)conId);
    }
}

