/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.estchgadjustbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.pccs.concs.business.helper.EstChgAdjustBillHelper;
import kd.pccs.concs.common.util.ParameterUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSubmitOpPlugin;

public class EstChgAdjustBillSubmitOpPlugin
extends BillSubmitOpPlugin {
    private static final String OVERESTCHGCTRL = "concs_estchgadjustbill.submit.overEstChgCtrl";

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("contractbill");
        fieldKeys.add("oriamt");
        fieldKeys.add("amount");
        fieldKeys.add("applyoriamt");
        fieldKeys.add("applyamt");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject model = dataEntity.getDataEntity();
        Long conId = model.getDynamicObject("contractbill").getLong("id");
        BigDecimal oriAmt = (BigDecimal)dataEntity.getValue("oriamt");
        BigDecimal conUsedOriamt = new EstChgAdjustBillHelper().getConUsedEstChgOriAmt(this.getAppId(), conId);
        Long orgId = RequestContext.get().getOrgId();
        String estChgParam = ParameterUtil.getParameter((String)this.getAppId(), (String)"param_estchgctrl", (Long)orgId);
        if (oriAmt != null && oriAmt.compareTo(conUsedOriamt) < 0) {
            if ("strict".equals(estChgParam)) {
                validator.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5df2\u4f7f\u7528\u9884\u4f30\u53d8\u66f4\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u5927\u4e8e \u9884\u4f30\u53d8\u66f4\u91d1\u989d\uff08\u8c03\u6574\u524d\uff09\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4!", (String)"EstChgAdjustBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
                return;
            }
            if ("tip".equals(estChgParam)) {
                String warnMsg = ResManager.loadKDString((String)"\u5408\u540c\u5df2\u4f7f\u7528\u9884\u4f30\u53d8\u66f4\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u8d85\u9884\u4f30\u53d8\u66f4\u91d1\u989d ", (String)"EstChgAdjustBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]);
                String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
                InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
                if (!confirmResult.getResults().containsKey(OVERESTCHGCTRL)) {
                    InteractionContext interactionContext = new InteractionContext();
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setMessage(warnMsg);
                    errorInfo.setLevel(ErrorLevel.Warning);
                    interactionContext.addOperateInfo(errorInfo);
                    throw new KDInteractionException(OVERESTCHGCTRL, interactionContext);
                }
            } else if ("no".equals(estChgParam)) {
                // empty if block
            }
        }
    }
}

