/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.estchgadjustbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ContractBillHelper;
import kd.pccs.concs.business.helper.EstChgAdjustBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OrgUtil;
import kd.pccs.concs.common.util.ParameterUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillUnAuditOpPlugin;

public class EstChgAdjustBillUnAuditOpPlugin
extends BillUnAuditOpPlugin {
    private static final String OVERESTCHGCTRL = "concs_estchgadjustbill.unaudit.overEstChgCtrl";

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("contractbill");
        fieldKeys.add("srcoriamt");
        fieldKeys.add("srcamt");
        fieldKeys.add("oriamt");
        fieldKeys.add("amount");
        fieldKeys.add("auditdate");
        fieldKeys.add("billstatus");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject model = dataEntity.getDataEntity();
        Long conId = model.getDynamicObject("contractbill").getLong("id");
        ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
        filter.add(new QFilter("contractbill", "=", (Object)conId));
        filter.add(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDITTED.getValue()));
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"estchgadjustbill"), (QFilter[])filter.toArray(new QFilter[filter.size()]))) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5c1a\u5b58\u5728\u4fdd\u5b58\u3001\u63d0\u4ea4\u3001\u5ba1\u6279\u4e2d\u72b6\u6001\u7684\u9884\u4f30\u53d8\u66f4\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279!", (String)"EstChgAdjustBillUnAuditOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            return;
        }
        filter.clear();
        filter.add(new QFilter("contractbill", "=", (Object)conId));
        filter.add(new QFilter("auditdate", ">", (Object)model.getDate("auditdate")));
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"estchgadjustbill"), (QFilter[])filter.toArray(new QFilter[filter.size()]))) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6700\u65b0\u7684\u9884\u4f30\u53d8\u66f4\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279!", (String)"EstChgAdjustBillUnAuditOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal conUsedOriamt = this.getConUsedOriamt(conId);
        BigDecimal srcOriAmt = model.getBigDecimal("srcoriamt");
        String estChgParam = this.getEstChgParam(model);
        if (NumberUtil.compareTo((Object)conUsedOriamt, (Object)srcOriAmt) > 0) {
            if ("strict".equals(estChgParam)) {
                validator.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5df2\u4f7f\u7528\u9884\u4f30\u53d8\u66f4\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u5927\u4e8e \u9884\u4f30\u53d8\u66f4\u91d1\u989d\uff08\u8c03\u6574\u524d\uff09\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279!", (String)"EstChgAdjustBillUnAuditOpPlugin_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
                return;
            }
            if ("tip".equals(estChgParam)) {
                String warnMsg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u540e\uff0c\u5408\u540c\u5df2\u4f7f\u7528\u9884\u4f30\u53d8\u66f4\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u8d85\u9884\u4f30\u53d8\u66f4\u91d1\u989d ", (String)"EstChgAdjustBillUnAuditOpPlugin_3", (String)"pccs-concs-opplugin", (Object[])new Object[0]);
                String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
                InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
                if (!confirmResult.getResults().containsKey(OVERESTCHGCTRL)) {
                    InteractionContext interactionContext = new InteractionContext();
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setMessage(warnMsg);
                    errorInfo.setLevel(ErrorLevel.Warning);
                    interactionContext.addOperateInfo(errorInfo);
                    throw new KDInteractionException(OVERESTCHGCTRL, interactionContext);
                }
            } else if ("no".equals(estChgParam)) {
                // empty if block
            }
        }
    }

    protected String getEstChgParam(DynamicObject model) {
        long orgId = OrgUtil.getCurrentOrgId((DynamicObject)model);
        return ParameterUtil.getParameter((String)this.getAppId(), (String)"param_estchgctrl", (Long)orgId);
    }

    protected BigDecimal getConUsedOriamt(Long conId) {
        return new EstChgAdjustBillHelper().getConUsedEstChgOriAmt(this.getAppId(), conId);
    }

    @Override
    protected void endUnAuditTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endUnAuditTransaction(args, model);
        this.syncContractData(model);
    }

    protected void syncContractData(DynamicObject model) {
        DynamicObject contract = model.getDynamicObject("contractbill");
        Long conId = contract.getLong("id");
        BigDecimal conOriAmt = contract.getBigDecimal("oriamt");
        BigDecimal estChgOriAmt = model.getBigDecimal("srcoriamt");
        BigDecimal estChgAmt = model.getBigDecimal("srcamt");
        BigDecimal estChgScale = NumberUtil.divide((Object)estChgOriAmt, (Object)conOriAmt, (int)4).multiply(NumberUtil.ONE_HUNDRED);
        HashMap<String, BigDecimal> estChgMap = new HashMap<String, BigDecimal>();
        estChgMap.put("estchgoriamt", estChgOriAmt);
        estChgMap.put("estchgamt", estChgAmt);
        estChgMap.put("estchgscale", estChgScale);
        new ContractBillHelper().updateContractEstChgAmt(this.getAppId(), conId.longValue(), estChgMap);
        new ContractBillHelper().updateContractInfo(this.getAppId(), conId.longValue());
    }
}

