/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;

public class EstChgCheckOpHelper {
    public static final String OVERESTCHGAMTINDEX = "overEstChgAmtIndex";

    public static void checkOverConEstChg(AbstractBillValidator validator, ExtendedDataEntity dataEntity, String parameter, BigDecimal chgAmountSum, DynamicObject contractBill) {
        String confirmResultString;
        InteractionConfirmResult confirmResult;
        boolean isMoreThanEstAmt;
        BigDecimal estChgAmt = NumberUtil.toBigDecimal((Object)contractBill.getBigDecimal("estchgoriamt"), (int)2);
        boolean bl = isMoreThanEstAmt = NumberUtil.compareTo((Object)chgAmountSum, (Object)estChgAmt) > 0;
        if (!isMoreThanEstAmt) {
            return;
        }
        String contractName = contractBill.getString("billname");
        chgAmountSum = NumberUtil.setScale((Object)chgAmountSum, (int)2);
        estChgAmt = NumberUtil.setScale((Object)estChgAmt, (int)2);
        String operateKey = validator.getOperateKey();
        if ("strict".equals(parameter)) {
            if (OperationUtil.isSubmitOp((String)operateKey)) {
                String msg = ResManager.loadKDString((String)"\u5408\u540c\"%s\"\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u4e3a%s\uff0c\u8d85\u8fc7\u9884\u4f30\u53d8\u66f4\u4f59\u989d%s\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff0c\u5982\u9700\u63d0\u4ea4\uff0c\u8bf7\u8c03\u6574\u53d8\u66f4\u91d1\u989d\u6216\u8fdb\u884c\u9884\u4f30\u53d8\u66f4\u8c03\u6574\u540e\u91cd\u8bd5\uff01", (String)"EstChgCheckOpHelper_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]);
                validator.addErrorMessage(dataEntity, String.format(msg, contractName, chgAmountSum.toString(), estChgAmt.toString()));
                return;
            }
            if (OperationUtil.isUnAuditOp((String)operateKey)) {
                String msg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u540e\u5408\u540c\"%s\"\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u5927\u4e8e\u5408\u540c\u9884\u4f30\u53d8\u66f4\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\uff01", (String)"EstChgCheckOpHelper_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]);
                validator.addErrorMessage(dataEntity, String.format(msg, contractName));
                return;
            }
        } else if ("tip".equals(parameter) && !(confirmResult = InteractionConfirmResult.fromJsonString((String)(confirmResultString = validator.getOption().getVariableValue("interactionconfirmresult", "")))).getResults().containsKey(OVERESTCHGAMTINDEX)) {
            InteractionContext interactionContext = new InteractionContext();
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            String msg = "";
            if (OperationUtil.isSubmitOp((String)operateKey)) {
                msg = String.format(ResManager.loadKDString((String)"\u5408\u540c\"%s\"\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u4e3a%s\uff0c\u5927\u4e8e\u5408\u540c\u9884\u4f30\u53d8\u66f4\u91d1\u989d%s", (String)"EstChgCheckOpHelper_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]), contractName, chgAmountSum.toString(), estChgAmt.toString());
            } else if (OperationUtil.isUnAuditOp((String)operateKey)) {
                msg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u540e\u5408\u540c\"%s\"\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u4f1a\u5927\u4e8e\u5408\u540c\u9884\u4f30\u53d8\u66f4\u91d1\u989d", (String)"EstChgCheckOpHelper_3", (String)"pccs-concs-opplugin", (Object[])new Object[0]);
            }
            errorInfo.setMessage(String.format(msg, contractName));
            errorInfo.setLevel(ErrorLevel.Warning);
            interactionContext.addOperateInfo(errorInfo);
            throw new KDInteractionException(OVERESTCHGAMTINDEX, interactionContext);
        }
    }
}

