/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.invoicebill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.pccs.concs.business.helper.InvoiceBillHelper;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSaveOpPlugin;
import org.apache.commons.lang.StringUtils;

public class InvoiceBillSaveOpPlugin
extends BillSaveOpPlugin {
    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject billObj = dataEntity.getDataEntity();
        if (StringUtils.isEmpty((String)billObj.getString("invoicecode"))) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (String)"InvoiceBillSaveOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        if (InvoiceBillHelper.checkInvoiceNoAndCodeDuplicated((String)this.getAppId(), (DynamicObject)billObj)) {
            validator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u7f16\u53f7\u4e3a'%s'\uff0c\u53d1\u7968\u4ee3\u7801\u4e3a'%s'\u7684\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5f55\u5165!", (String)"InvoiceBillSaveOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]), billObj.getString("invoiceno"), billObj.getString("invoicecode")));
        }
    }

    @Override
    protected void syncSupplierName(DynamicObject model) {
        super.syncSupplierName(model);
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("saleorg", "saleorgname", this.billEntityType.getExtendName(), model, "save"));
    }
}

