/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.invoicebill;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.pccs.concs.business.helper.InvoiceBillHelper;
import kd.pccs.concs.common.enums.InvoiceTypeEnum;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSubmitOpPlugin;
import org.apache.commons.lang.StringUtils;

public class InvoiceBillSubmitOpPlugin
extends BillSubmitOpPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("invoicetype");
        fieldKeys.add("purorg");
        fieldKeys.add("purtaxpayer");
        fieldKeys.add("puraddress");
        fieldKeys.add("purbankaccount");
        fieldKeys.add("purdepositbank");
        fieldKeys.add("purtelnumber");
        fieldKeys.add("saleorg");
        fieldKeys.add("saleorgname");
        fieldKeys.add("saletaxpayer");
        fieldKeys.add("saleaddress");
        fieldKeys.add("salebankaccount");
        fieldKeys.add("saledepositbank");
        fieldKeys.add("saletelnumber");
        fieldKeys.add("contractbill");
        fieldKeys.add("payreqbill");
        fieldKeys.add("billstatus");
        fieldKeys.add("invoiceno");
        fieldKeys.add("invoicecode");
        fieldKeys.add("entry_content");
        fieldKeys.add("entry_model");
        fieldKeys.add("entry_unit");
        fieldKeys.add("entry_qty");
        fieldKeys.add("entry_price");
        fieldKeys.add("entry_notaxamt");
        fieldKeys.add("entry_taxrate");
        fieldKeys.add("entry_tax");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject invoiceBill = dataEntity.getDataEntity();
        LinkedHashMap<String, String> msgs = new LinkedHashMap<String, String>();
        msgs.put("invoiceno", ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        msgs.put("invoicecode", ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        msgs.put("purorg", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u5355\u4f4d", (String)"InvoiceBillSubmitOpPlugin_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        msgs.put("saleorg", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u5355\u4f4d", (String)"InvoiceBillSubmitOpPlugin_3", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        if (InvoiceTypeEnum.VATSPECIALINVOICE.getValue().equals(invoiceBill.getString("invoicetype"))) {
            msgs.put("purtaxpayer", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"InvoiceBillSubmitOpPlugin_4", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("puraddress", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u5730\u5740", (String)"InvoiceBillSubmitOpPlugin_5", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("purbankaccount", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u94f6\u884c\u8d26\u53f7", (String)"InvoiceBillSubmitOpPlugin_6", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("purtelnumber", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u7535\u8bdd", (String)"InvoiceBillSubmitOpPlugin_7", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("purdepositbank", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u5f00\u6237\u884c", (String)"InvoiceBillSubmitOpPlugin_8", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("saletaxpayer", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"InvoiceBillSubmitOpPlugin_9", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("saleaddress", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u5730\u5740", (String)"InvoiceBillSubmitOpPlugin_10", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("salebankaccount", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u94f6\u884c\u8d26\u53f7", (String)"InvoiceBillSubmitOpPlugin_11", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("saledepositbank", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u5f00\u6237\u884c", (String)"InvoiceBillSubmitOpPlugin_12", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("saletelnumber", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u7535\u8bdd", (String)"InvoiceBillSubmitOpPlugin_13", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        } else if (InvoiceTypeEnum.VATINVOICE.getValue().equals(invoiceBill.getString("invoicetype"))) {
            msgs.put("purtaxpayer", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"InvoiceBillSubmitOpPlugin_4", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            msgs.put("saletaxpayer", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"InvoiceBillSubmitOpPlugin_9", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        List names = msgs.keySet().stream().filter(o -> null == invoiceBill.get(o) || StringUtils.isEmpty((String)invoiceBill.getString(o))).map(k -> (String)msgs.get(k)).collect(Collectors.toList());
        if (!names.isEmpty()) {
            validator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u5f55\u5165", (String)"InvoiceBillSubmitOpPlugin_14", (String)"pccs-concs-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", names)));
        }
        if (InvoiceBillHelper.checkInvoiceNoAndCodeDuplicated((String)this.getAppId(), (DynamicObject)invoiceBill)) {
            validator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u7f16\u53f7\u4e3a'%s'\uff0c\u53d1\u7968\u4ee3\u7801\u4e3a'%s'\u7684\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5f55\u5165!", (String)"InvoiceBillSubmitOpPlugin_15", (String)"pccs-concs-opplugin", (Object[])new Object[0]), invoiceBill.getString("invoiceno"), invoiceBill.getString("invoicecode")));
        }
        List errorMessage = InvoiceBillHelper.checkInvoiceEntryRequired((DynamicObject)invoiceBill);
        errorMessage.forEach(message -> validator.addErrorMessage(dataEntity, (String)message));
    }

    @Override
    protected void syncSupplierName(DynamicObject model) {
        super.syncSupplierName(model);
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("saleorg", "saleorgname", this.billEntityType.getExtendName(), model, "submit"));
    }
}

