/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.invoicebill;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillUnAuditOpPlugin;

public class InvoiceBillUnAuditOpPlugin
extends BillUnAuditOpPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("contractbill");
        fieldKeys.add("payreqbill");
        fieldKeys.add("billstatus");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject model = dataEntity.getDataEntity();
        Optional.ofNullable(model.getDynamicObject("payreqbill")).map(info -> info.getLong("id")).ifPresent(pk -> {
            boolean existsPayReqFlag = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
            if (existsPayReqFlag) {
                validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u88ab\u4ed8\u6b3e\u7533\u8bf7\u5355\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"InvoiceBillUnAuditOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            }
        });
    }

    @Override
    protected void endUnAuditTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        Object contractId;
        super.endUnAuditTransaction(args, model);
        DynamicObject contractbill = model.getDynamicObject("contractbill");
        Object object = contractId = contractbill == null ? null : contractbill.getPkValue();
        if (null != contractId) {
            ContractCenterHelper.syncInvAmt2CC((String)this.getAppId(), (long)((Long)contractId));
        }
    }
}

