/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.payreqbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.pccs.concs.business.helper.InvoiceBillHelper;
import kd.pccs.concs.common.enums.DeductPropertyEnum;
import kd.pccs.concs.common.util.LicenseUtil;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.opplugin.billtpl.BillAuditOpPlugin;

public class PayReqBillAuditOpPlugin
extends BillAuditOpPlugin {
    protected InvoiceBillHelper getInvoiceBillHelper() {
        return new InvoiceBillHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("oriamt");
        fieldKeys.add("amount");
        fieldKeys.add("rewarddeductoriamt");
        fieldKeys.add("rewarddeductamt");
        fieldKeys.add("prepayoriamt");
        fieldKeys.add("prepayamt");
        fieldKeys.add("contractbill");
        fieldKeys.add("project");
        fieldKeys.add("payentry_entryseq");
        fieldKeys.add("payentry_oriamt");
        fieldKeys.add("payentry_amount");
        fieldKeys.add("payentry_description");
        fieldKeys.add("invoiceentrys");
        fieldKeys.add("payreqredeentry");
        fieldKeys.add("inventry_rewarddeduct");
        fieldKeys.add("inventry_oriamt");
        fieldKeys.add("inventry_amount");
        fieldKeys.add("inventry_paytype");
        fieldKeys.add("nocontractflag");
        fieldKeys.add("payreqdetailentry");
    }

    @Override
    protected void beforeAuditTransaction(BeforeOperationArgs args, DynamicObject model) {
        super.beforeAuditTransaction(args, model);
        this.synReqDataToPaymentEntry(model);
    }

    @Override
    protected void afterAuditTransaction(AfterOperationArgs args, DynamicObject model) {
        OperationResult result;
        super.afterAuditTransaction(args, model);
        DynamicObjectCollection invoiceEntrys = model.getDynamicObjectCollection("invoiceentrys");
        if (invoiceEntrys.size() > 0) {
            for (DynamicObject entry : invoiceEntrys) {
                DynamicObject invoce = entry.getDynamicObject("fbasedataid");
                this.getInvoiceBillHelper().updateRequestBill(this.getAppId(), invoce.getPkValue(), model.getPkValue(), true);
            }
        }
        if (LicenseUtil.checkCasGroupPermit() && !(result = OperationServiceHelper.executeOperate((String)"pushandsave", (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (DynamicObject[])new DynamicObject[]{model}, (OperateOption)OperateOption.create())).isSuccess()) {
            throw new KDBizException(((IOperateInfo)result.getAllErrorOrValidateInfo().get(0)).getMessage());
        }
    }

    protected void synReqDataToPaymentEntry(DynamicObject model) {
        DynamicObjectCollection payDetailColl = model.getDynamicObjectCollection("payreqdetailentry");
        payDetailColl.clear();
        DynamicObject payDeatil = payDetailColl.addNew();
        payDeatil.set("payentry_entryseq", (Object)1);
        payDeatil.set("payentry_oriamt", (Object)model.getBigDecimal("oriamt"));
        payDeatil.set("payentry_amount", (Object)model.getBigDecimal("amount"));
        payDeatil.set("payentry_description", (Object)ResManager.loadKDString((String)"\u7533\u8bf7\u91d1\u989d", (String)"PayReqBillAuditOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        if (!model.getBoolean("nocontractflag")) {
            BigDecimal prePayOriAmt = model.getBigDecimal("prepayoriamt");
            if (!NumberUtil.isZero((Object)prePayOriAmt)) {
                BigDecimal prePayAmt = model.getBigDecimal("prepayamt");
                payDeatil = payDetailColl.addNew();
                payDeatil.set("payentry_entryseq", (Object)2);
                payDeatil.set("payentry_oriamt", (Object)prePayOriAmt.negate());
                payDeatil.set("payentry_amount", (Object)prePayAmt.negate());
                payDeatil.set("payentry_description", (Object)ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u62b5\u6263", (String)"PayReqBillAuditOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            }
            BigDecimal rewardOriAmt = NumberUtil.ZERO;
            BigDecimal rewardAmount = NumberUtil.ZERO;
            BigDecimal deductOriAmt = NumberUtil.ZERO;
            BigDecimal deductAmount = NumberUtil.ZERO;
            DynamicObjectCollection redeEntrys = model.getDynamicObjectCollection("payreqredeentry");
            if (redeEntrys.size() > 0) {
                for (DynamicObject entry : redeEntrys) {
                    DynamicObject rewardDeduct = entry.getDynamicObject("inventry_rewarddeduct");
                    if (DeductPropertyEnum.ADD.getValue().equals(rewardDeduct.get("paytype"))) {
                        rewardOriAmt = NumberUtil.add((Object)rewardOriAmt, (Object)rewardDeduct.get("oriamt"));
                        rewardAmount = NumberUtil.add((Object)rewardAmount, (Object)rewardDeduct.get("amount"));
                        continue;
                    }
                    deductOriAmt = NumberUtil.add((Object)deductOriAmt, (Object)rewardDeduct.get("oriamt"));
                    deductAmount = NumberUtil.add((Object)deductAmount, (Object)rewardDeduct.get("amount"));
                }
            }
            if (!NumberUtil.isZero((Object)rewardOriAmt)) {
                payDeatil = payDetailColl.addNew();
                payDeatil.set("payentry_entryseq", (Object)3);
                payDeatil.set("payentry_oriamt", (Object)rewardOriAmt);
                payDeatil.set("payentry_amount", (Object)rewardAmount);
                payDeatil.set("payentry_description", (Object)ResManager.loadKDString((String)"\u5956\u52b1", (String)"PayReqBillAuditOpPlugin_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            }
            if (!NumberUtil.isZero((Object)deductOriAmt)) {
                payDeatil = payDetailColl.addNew();
                payDeatil.set("payentry_entryseq", (Object)4);
                payDeatil.set("payentry_oriamt", (Object)deductOriAmt);
                payDeatil.set("payentry_amount", (Object)deductAmount);
                payDeatil.set("payentry_description", (Object)ResManager.loadKDString((String)"\u6263\u6b3e", (String)"PayReqBillAuditOpPlugin_3", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

