/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.payreqbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.business.helper.InvoiceBillHelper;
import kd.pccs.concs.business.helper.PayReqBillHelper;
import kd.pccs.concs.business.helper.RewardDeductBillHelper;
import kd.pccs.concs.common.constant.FiCasConst;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSubmitOpPlugin;

public class PayReqBillSubmitOpPlugin
extends BillSubmitOpPlugin {
    private static final String OVERPAYWARNSCALE = "overPayWarnScale";

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("billno");
        fieldKeys.add("billname");
        fieldKeys.add("project");
        fieldKeys.add("paymenttype");
        fieldKeys.add("contractbill");
        fieldKeys.add("nocontractflag");
        fieldKeys.add("foreigncurrencyflag");
        fieldKeys.add("oriamt");
        fieldKeys.add("settleoriamt");
        fieldKeys.add("prepayoriamt");
        fieldKeys.add("preunpayoriamt");
        fieldKeys.add("prepayamt");
        fieldKeys.add("preunpayamt");
        fieldKeys.add("receiveunit");
        fieldKeys.add("receiveunitname");
        fieldKeys.add("invoiceentrys");
        fieldKeys.add("payreqredeentry");
        fieldKeys.add("inventry_rewarddeduct");
        fieldKeys.add("payreqdataentry");
        fieldKeys.add("dataentry_datastandard");
        fieldKeys.add("dataentry_reportflag");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject contractBill;
        super.checkBeforeOperation(validator, dataEntity);
        if (dataEntity.getDataEntity().getDynamicObject("project") == null) {
            return;
        }
        DynamicObject model = dataEntity.getDataEntity();
        if (this.needCheckPayWarnScale(model)) {
            this.checkOverPayscale(validator, dataEntity);
        }
        if (model.getBoolean("nocontractflag")) {
            return;
        }
        boolean hasConFlag = this.checkContractRequest(validator, dataEntity);
        if (!hasConFlag) {
            return;
        }
        DynamicObjectCollection dataStandEntrys = model.getDynamicObjectCollection("payreqdataentry");
        if (dataStandEntrys.size() > 0) {
            for (DynamicObject dataStandEntry : dataStandEntrys) {
                Boolean verifyReport;
                DynamicObject dataStandard = (DynamicObject)dataStandEntry.get("dataentry_datastandard");
                Boolean isRequired = dataStandard.getBoolean("isrequired");
                if (!isRequired.booleanValue() || (verifyReport = Boolean.valueOf(dataStandEntry.getBoolean("dataentry_reportflag"))).booleanValue()) continue;
                validator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d44\u6599\u201c%s\u201d\u672a\u6838\u5b9e\u4e0a\u62a5\uff0c\u8bf7\u5f55\u5165\uff01", (String)"PayReqBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]), dataStandard.getString("name")));
            }
        }
        if (null != (contractBill = model.getDynamicObject("contractbill"))) {
            BigDecimal totalApplyAmt;
            String verifyMsg;
            Long conId = (Long)contractBill.getPkValue();
            if (this.checkOverPreUnPayAmt(model)) {
                if (model.getBoolean("foreigncurrencyflag")) {
                    validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u62b5\u6263\u91d1\u989d\uff08\u539f\u5e01\uff09\u4e0d\u80fd\u5927\u4e8e\u5f85\u62b5\u6263\u91d1\u989d\uff08\u539f\u5e01\uff09\uff01", (String)"PayReqBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
                } else {
                    validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u62b5\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f85\u62b5\u6263\u91d1\u989d\uff01", (String)"PayReqBillSubmitOpPlugin_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
                }
            }
            if (null != (verifyMsg = this.checkOverPay(conId, totalApplyAmt = this.getTotalReqAmt(conId, model), model))) {
                validator.addErrorMessage(dataEntity, verifyMsg);
            }
        }
    }

    protected boolean checkContractRequest(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject model = dataEntity.getDataEntity();
        if (null == model.getDynamicObject("contractbill")) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"PayReqBillSubmitOpPlugin_3", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean checkOverPreUnPayAmt(DynamicObject model) {
        BigDecimal preUnPayOriAmt = model.getBigDecimal("preunpayoriamt");
        BigDecimal prePayOriAmt = model.getBigDecimal("prepayoriamt");
        return NumberUtil.compareTo((Object)prePayOriAmt, (Object)preUnPayOriAmt) > 0;
    }

    protected String checkOverPay(Long conId, BigDecimal totalReqAmt, DynamicObject model) {
        Long paymentType;
        if (null == model.getDynamicObject("paymenttype")) {
            return null;
        }
        String verifyMsg = null;
        DynamicObject conbillObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "latestoriprice", "marginoriamt"));
        BigDecimal latestOriPrice = conbillObj.getBigDecimal("latestoriprice");
        BigDecimal bailAmt = conbillObj.getBigDecimal("marginoriamt");
        DynamicObject conSettleBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (String)"bailoriamt", (QFilter[])new QFilter[]{new QFilter("contractbill", "=", (Object)conId)});
        if (null != conSettleBill) {
            bailAmt = conSettleBill.getBigDecimal("bailoriamt");
        }
        if (FiCasConst.PRE_PAYMENT.equals(paymentType = (Long)model.getDynamicObject("paymenttype").getPkValue())) {
            if (totalReqAmt.compareTo(NumberUtil.subtract((Object)latestOriPrice, (Object)bailAmt)) > 0) {
                verifyMsg = String.format(ResManager.loadKDString((String)"\u201c\u7d2f\u8ba1\u8bf7\u6b3e\u91d1\u989d\u201d\u5927\u4e8e\u201c%1$s-%2$s\u201d\uff0c\u5b58\u5728\u8d85\u4ed8\u73b0\u8c61\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01", (String)"PayReqBillSubmitOpPlugin_4", (String)"pccs-concs-opplugin", (Object[])new Object[0]), this.getLatestPriceName(), this.getBailAmtName());
            }
        } else if (FiCasConst.PROGRESS_PAYMENT.equals(paymentType) || FiCasConst.SETTLEMENT_PAYMENT.equals(paymentType)) {
            if (totalReqAmt.compareTo(NumberUtil.subtract((Object)latestOriPrice, (Object)bailAmt)) > 0) {
                verifyMsg = String.format(ResManager.loadKDString((String)"\u201c\u7d2f\u8ba1\u8bf7\u6b3e\u91d1\u989d\u201d\u5927\u4e8e\u201c%1$s-%2$s\u201d\uff0c\u5b58\u5728\u8d85\u4ed8\u73b0\u8c61\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01", (String)"PayReqBillSubmitOpPlugin_4", (String)"pccs-concs-opplugin", (Object[])new Object[0]), this.getLatestPriceName(), this.getBailAmtName());
            } else if (FiCasConst.SETTLEMENT_PAYMENT.equals(paymentType) && totalReqAmt.compareTo(model.getBigDecimal("settleoriamt")) > 0) {
                verifyMsg = ResManager.loadKDString((String)"\u201c\u7d2f\u8ba1\u8bf7\u6b3e\u91d1\u989d\u201d\u5927\u4e8e\u201c\u7ed3\u7b97\u91d1\u989d\u201d\uff0c\u5b58\u5728\u8d85\u4ed8\u73b0\u8c61\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01", (String)"PayReqBillSubmitOpPlugin_5", (String)"pccs-concs-opplugin", (Object[])new Object[0]);
            }
        } else if (totalReqAmt.compareTo(latestOriPrice) > 0) {
            verifyMsg = String.format(ResManager.loadKDString((String)"\u622a\u81f3\u672c\u6b21\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u8d85%s\uff01", (String)"PayReqBillSubmitOpPlugin_6", (String)"pccs-concs-opplugin", (Object[])new Object[0]), this.getLatestPriceName());
        }
        return verifyMsg;
    }

    protected void checkOverPayscale(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObject model = dataEntity.getDataEntity();
        DynamicObject contractBill = model.getDynamicObject("contractbill");
        Long conId = (Long)contractBill.getPkValue();
        BigDecimal totalReqAmt = this.getTotalReqAmt(conId, model);
        DynamicObject conbillObj = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "latestoriprice", "paywarnscale"));
        BigDecimal latestOriPrice = conbillObj.getBigDecimal("latestoriprice");
        BigDecimal reqScale = NumberUtil.multiply((Object)NumberUtil.divide((Object)totalReqAmt, (Object)latestOriPrice, (int)4), (Object)NumberUtil.ONE_HUNDRED);
        BigDecimal paywarnscale = conbillObj.getBigDecimal("paywarnscale");
        if (NumberUtil.isZero((Object)paywarnscale) || NumberUtil.compareTo((Object)reqScale, (Object)paywarnscale) <= 0) {
            return;
        }
        String confirmResultString = validator.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (!confirmResult.getResults().containsKey(OVERPAYWARNSCALE)) {
            InteractionContext interactionContext = new InteractionContext();
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            String warnMsg = ResManager.loadKDString((String)"\u622a\u81f3\u672c\u6b21\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u8d85\u4ed8\u6b3e\u63d0\u793a\u6bd4\u4f8b", (String)"PayReqBillSubmitOpPlugin_7", (String)"pccs-concs-opplugin", (Object[])new Object[0]);
            errorInfo.setMessage(warnMsg);
            errorInfo.setLevel(ErrorLevel.Warning);
            interactionContext.addOperateInfo(errorInfo);
            throw new KDInteractionException(OVERPAYWARNSCALE, interactionContext);
        }
    }

    protected BigDecimal getTotalReqAmt(Long conId, DynamicObject model) {
        DynamicObject[] payReqBills = PayReqBillHelper.getPayReqAmountByContract((String)this.getAppId(), (Long)conId, (boolean)true, (boolean)true);
        BigDecimal totalReqAmt = NumberUtil.ZERO;
        for (DynamicObject payReq : payReqBills) {
            totalReqAmt = payReq.getBoolean("hasclosed") ? NumberUtil.add((Object)totalReqAmt, (Object)payReq.getBigDecimal("payedoriamt")) : NumberUtil.add((Object)totalReqAmt, (Object)payReq.getBigDecimal("oriamt"));
        }
        return NumberUtil.add((Object)totalReqAmt, (Object)model.getBigDecimal("oriamt"));
    }

    protected String getBailAmtName() {
        return ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1", (String)"PayReqBillSubmitOpPlugin_8", (String)"pccs-concs-opplugin", (Object[])new Object[0]);
    }

    protected String getLatestPriceName() {
        return ResManager.loadKDString((String)"\u5408\u540c\u6700\u65b0\u4ef7\u6b3e", (String)"PayReqBillSubmitOpPlugin_9", (String)"pccs-concs-opplugin", (Object[])new Object[0]);
    }

    protected boolean needCheckPayWarnScale(DynamicObject model) {
        return !model.getBoolean("nocontractflag");
    }

    @Override
    protected void endSubmitTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endSubmitTransaction(args, model);
        model.set("billname", model.get("billno"));
        RewardDeductBillHelper.updateRewardDeductF7RefBillId((String)this.getAppId(), (DynamicObject)model, (String)"submit");
        InvoiceBillHelper.updateInvoiceRef((String)this.getAppId(), (DynamicObject)model, (String)"submit");
    }

    @Override
    protected void syncSupplierName(DynamicObject model) {
        super.syncSupplierName(model);
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("receiveunit", "receiveunitname", this.billEntityType.getExtendName(), model, "submit"));
    }
}

