/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.payreqbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.InvoiceBillHelper;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillUnAuditOpPlugin;

public class PayReqBillUnAuditOpPlugin
extends BillUnAuditOpPlugin {
    protected InvoiceBillHelper getInvoiceBillHelper() {
        return new InvoiceBillHelper();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("invoiceentrys");
        fieldKeys.add("contractbill");
        fieldKeys.add("payreqdetailentry");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject model = dataEntity.getDataEntity();
        boolean hasPayBillFlag = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", model.getPkValue())});
        if (hasPayBillFlag) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4ed8\u6b3e\u5355\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\uff01", (String)"PayReqBillUnAuditOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void afterUnAuditTransaction(AfterOperationArgs args, DynamicObject model) {
        super.afterUnAuditTransaction(args, model);
        DynamicObjectCollection invoiceEntrys = model.getDynamicObjectCollection("invoiceentrys");
        if (invoiceEntrys.size() > 0) {
            InvoiceBillHelper invoiceBillHelper = this.getInvoiceBillHelper();
            for (DynamicObject entry : invoiceEntrys) {
                DynamicObject invoce = entry.getDynamicObject("fbasedataid");
                invoiceBillHelper.updateRequestBill(this.getAppId(), invoce.getPkValue(), model.getPkValue(), false);
            }
            this.deletePayEntrys(model);
        }
    }

    protected void deletePayEntrys(DynamicObject model) {
        model.getDynamicObjectCollection("payreqdetailentry").clear();
    }
}

