/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.rewarddeductbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.business.helper.RewardDeductBillHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillUnAuditOpPlugin;

public class RewardDeductBillUnAuditOpPlugin
extends BillUnAuditOpPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("billno");
        fieldKeys.add("billname");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("org");
        fieldKeys.add("project");
        fieldKeys.add("bizdept");
        fieldKeys.add("billstatus");
        fieldKeys.add("bizdate");
        fieldKeys.add("entry_contractbill");
        fieldKeys.add("entry_supplier");
        fieldKeys.add("entry_payitem");
        fieldKeys.add("entry_paytype");
        fieldKeys.add("entry_amount");
        fieldKeys.add("entry_oriamt");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject model = dataEntity.getDataEntity();
        DynamicObjectCollection entrys = model.getDynamicObjectCollection("rewarddeductentry");
        entrys.stream().forEach(entry -> {
            boolean existsConSettleFlag;
            DynamicObject contractBill = entry.getDynamicObject("entry_contractbill");
            if (null != contractBill && (existsConSettleFlag = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", contractBill.getPkValue())}))) {
                validator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c : %s \u5b58\u5728\u5408\u540c\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"RewardDeductBillUnAuditOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]), contractBill.get("name")));
            }
        });
        boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeduct_f7"), (QFilter[])new QFilter[]{new QFilter("billId", "=", model.getPkValue()), new QFilter("refbillid", "!=", (Object)0L)});
        if (exists) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5956\u52b1\u6263\u6b3e\u5355\u5df2\u88ab\u4ed8\u6b3e\u7533\u8bf7\u5355\u5f15\u7528,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279", (String)"RewardDeductBillUnAuditOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void endUnAuditTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endUnAuditTransaction(args, model);
        RewardDeductBillHelper.syncRewardDeductBill2RewardDeductF7((String)this.getAppId(), (DynamicObject)model, (String)"unaudit");
        DynamicObjectCollection rewardDeductEntry = model.getDynamicObjectCollection("rewarddeductentry");
        if (null != rewardDeductEntry && !rewardDeductEntry.isEmpty()) {
            for (DynamicObject entry : rewardDeductEntry) {
                DynamicObject contract = entry.getDynamicObject("entry_contractbill");
                if (null == contract) continue;
                ContractCenterHelper.syncRewardDuctAmt2CC((String)this.getAppId(), (long)((Long)contract.getPkValue()));
            }
        }
    }
}

