/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.stagesettlebill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSubmitOpPlugin;

public class StageSettleBillSubmitOpPlugin
extends BillSubmitOpPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("oriamt");
        fieldKeys.add("amount");
        fieldKeys.add("applyoriamt");
        fieldKeys.add("applyamt");
        fieldKeys.add("totalsettleoriamt");
        fieldKeys.add("contractbill");
        fieldKeys.add("project");
        fieldKeys.add("supplier");
        fieldKeys.add("suppliername");
        fieldKeys.add("dataentry_datastandard");
        fieldKeys.add("dataentry_verifyReport");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        BigDecimal conLatestOriPrice;
        super.checkBeforeOperation(validator, dataEntity);
        if (dataEntity.getDataEntity().getDynamicObject("project") == null) {
            return;
        }
        DynamicObjectCollection dataEntrys = dataEntity.getDataEntity().getDynamicObjectCollection("stagesettleentry");
        for (DynamicObject dataEntry : dataEntrys) {
            Boolean verifyReport;
            DynamicObject dataStandard = dataEntry.getDynamicObject("dataentry_datastandard");
            Boolean isRequired = dataStandard.getBoolean("isrequired");
            if (!isRequired.booleanValue() || (verifyReport = Boolean.valueOf(dataEntry.getBoolean("dataentry_verifyReport"))).booleanValue()) continue;
            validator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u8d44\u6599\u201c%s\u201d\u672a\u6838\u5b9e\u4e0a\u62a5\uff0c\u8bf7\u5f55\u5165\uff01", (String)"StageSettleBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]), dataStandard.getString("name")));
        }
        DynamicObject contractBill = dataEntity.getDataEntity().getDynamicObject("contractbill");
        BigDecimal totalSettleOriAmt = dataEntity.getDataEntity().getBigDecimal("totalsettleoriamt");
        if (NumberUtil.compareTo((Object)totalSettleOriAmt, (Object)(conLatestOriPrice = contractBill.getBigDecimal("latestoriprice"))) > 0) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u622a\u81f3\u672c\u671f\u7d2f\u8ba1\u5df2\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u6700\u65b0\u9020\u4ef7\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff0c\u8bf7\u6838\u5b9e\u4fee\u6539\u540e\u91cd\u8bd5\uff01", (String)"StageSettleBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void syncSupplierName(DynamicObject model) {
        super.syncSupplierName(model);
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("supplier", "suppliername", this.billEntityType.getExtendName(), model, "submit"));
    }
}

