/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.supplyconbill;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ChgBillHelper;
import kd.pccs.concs.business.helper.ChgCfmBillHelper;
import kd.pccs.concs.common.enums.SuppFormWayEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.common.util.OrgUtil;
import kd.pccs.concs.common.util.ParameterUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.helper.EstChgCheckOpHelper;

public class SupplyConBillOpHelper {
    public void onPreparePropertys(List<String> fieldKeys) {
        fieldKeys.add("billstatus");
        fieldKeys.add("formway");
        fieldKeys.add("project");
        fieldKeys.add("contractbill");
        fieldKeys.add("partyb");
        fieldKeys.add("partybname");
        fieldKeys.add("foreigncurrencyflag");
        fieldKeys.add("multitaxrateflag");
        fieldKeys.add("amount");
        fieldKeys.add("oriamt");
    }

    public void beforeTransaction4UpdateConCfmRefBillStatus(String appId, DynamicObject model, String billStatus) {
        String entityId = MetaDataUtil.getEntityId((String)appId, (String)"supplyconbill");
        if (!QueryServiceHelper.exists((String)entityId, (Object)model.getPkValue())) {
            return;
        }
        DynamicObject oldSupplyBill = BusinessDataServiceHelper.loadSingle((Object)model.getPkValue(), (String)entityId);
        Optional.ofNullable(oldSupplyBill).ifPresent(o -> ChgCfmBillHelper.updateConCfmRefBillStatus((String)appId, (DynamicObjectCollection)o.getDynamicObjectCollection("supplyconchgentry"), (String)billStatus));
    }

    public void endTransaction4UpdateConCfmRefBillStatus(String appId, DynamicObject model, String billStatus) {
        if (!SuppFormWayEnum.CHGTOSUPP.getValue().equals(model.getString("formway"))) {
            return;
        }
        ChgCfmBillHelper.updateConCfmRefBillStatus((String)appId, (DynamicObjectCollection)model.getDynamicObjectCollection("supplyconchgentry"), (String)billStatus);
    }

    public void checkEstChgAmt(String appId, AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        Map conChgAmt;
        DynamicObject supplyBill = dataEntity.getDataEntity();
        long orgId = OrgUtil.getCurrentOrgId((DynamicObject)supplyBill);
        String param = ParameterUtil.getParameter((String)appId, (String)"param_supplyctrlmode", (Long)orgId);
        if ("balanceCtrl".equals(param)) {
            return;
        }
        param = ParameterUtil.getParameter((String)appId, (String)"param_estchgctrl", (Long)orgId);
        if ("no".equals(param)) {
            return;
        }
        DynamicObject contractBill = supplyBill.getDynamicObject("contractbill");
        Long contractBillId = (Long)contractBill.getPkValue();
        contractBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (String)String.join((CharSequence)",", "estchgoriamt", "billname"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)contractBillId)});
        Long billId = (Long)supplyBill.getPkValue();
        if (SuppFormWayEnum.CHGTOSUPP.getValue().equals(supplyBill.getString("formway"))) {
            DynamicObjectCollection chgEntry = supplyBill.getDynamicObjectCollection("supplyconchgentry");
            int size = chgEntry.size();
            Long[] excludeBillIds = new Long[size + 1];
            for (int i = 0; i < size; ++i) {
                excludeBillIds[i] = (Long)((DynamicObject)chgEntry.get(i)).getDynamicObject("chgentry_changebill").getPkValue();
            }
            excludeBillIds[size] = billId;
            conChgAmt = new ChgBillHelper().getChgAmtIncSupply(appId, contractBillId.longValue(), false, excludeBillIds);
        } else {
            conChgAmt = new ChgBillHelper().getChgAmtIncSupply(appId, contractBillId.longValue(), false, new Long[]{billId});
        }
        BigDecimal conUsedOriamt = (BigDecimal)conChgAmt.get("oriamt");
        BigDecimal billAmt = supplyBill.getBigDecimal("oriamt");
        if (OperationUtil.isSubmitOp((String)validator.getOperateKey())) {
            conUsedOriamt = NumberUtil.add((Object)conUsedOriamt, (Object)billAmt);
        } else if (OperationUtil.isUnAuditOp((String)validator.getOperateKey()) && SuppFormWayEnum.CHGTOSUPP.getValue().equals(supplyBill.getString("formway"))) {
            DynamicObjectCollection chgEntry = supplyBill.getDynamicObjectCollection("supplyconchgentry");
            BigDecimal chgCfmAmtSum = BigDecimal.ZERO;
            for (int i = chgEntry.size() - 1; i >= 0; --i) {
                DynamicObject chgCfm = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)chgEntry.get(i)).getDynamicObject("chgentry_changebill").getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"chgcfmbill"), (String)"oriamt");
                chgCfmAmtSum = NumberUtil.add((Object)chgCfmAmtSum, (Object)chgCfm.getBigDecimal("oriamt"));
            }
            conUsedOriamt = NumberUtil.add((Object)conUsedOriamt, (Object)chgCfmAmtSum);
        }
        EstChgCheckOpHelper.checkOverConEstChg(validator, dataEntity, param, conUsedOriamt, contractBill);
    }
}

