/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.supplyconbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.pccs.concs.common.enums.SuppFormWayEnum;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillSubmitOpPlugin;
import kd.pccs.concs.opplugin.supplyconbill.SupplyConBillOpHelper;

public class SupplyConBillSubmitOpPlugin
extends BillSubmitOpPlugin {
    protected SupplyConBillOpHelper getOpHelper() {
        return new SupplyConBillOpHelper();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        this.getOpHelper().onPreparePropertys(fieldKeys);
        fieldKeys.add("chgentry_changebill");
        fieldKeys.add("supplyconchgentry");
        fieldKeys.add("taxentry");
        fieldKeys.add("taxentry_oriamt");
        fieldKeys.add("taxentry_amount");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection chgCfmEntry;
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject supplyObj = dataEntity.getDataEntity();
        if (supplyObj.getBoolean("multitaxrateflag")) {
            DynamicObjectCollection taxEntry = supplyObj.getDynamicObjectCollection("taxentry");
            BigDecimal entryOriAmountSum = BigDecimal.ZERO;
            BigDecimal entryAmountSum = BigDecimal.ZERO;
            for (DynamicObject taxEntryRow : taxEntry) {
                BigDecimal entry_oriAmt = taxEntryRow.getBigDecimal("taxentry_oriamt");
                entryOriAmountSum = NumberUtil.add((Object)entryOriAmountSum, (Object)NumberUtil.toBigDecimal((Object)entry_oriAmt, (int)2));
                BigDecimal entry_amount = taxEntryRow.getBigDecimal("taxentry_amount");
                entryAmountSum = NumberUtil.add((Object)entryAmountSum, (Object)NumberUtil.toBigDecimal((Object)entry_amount, (int)2));
            }
            BigDecimal amount = supplyObj.getBigDecimal("amount");
            BigDecimal oriAmt = supplyObj.getBigDecimal("oriamt");
            if (supplyObj.getBoolean("foreigncurrencyflag") && NumberUtil.compareTo((Object)entryOriAmountSum, (Object)oriAmt) != 0) {
                validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u8865\u5145\u5408\u540c\u91d1\u989d(\u539f\u5e01)\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u91d1\u989d(\u539f\u5e01)\u7684\u5408\u8ba1\u503c\"\u4e0d\u76f8\u7b49,\u4e0d\u5141\u8bb8\u63d0\u4ea4!", (String)"SupplyConBillSubmitOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
                return;
            }
            if (NumberUtil.compareTo((Object)entryAmountSum, (Object)amount) != 0) {
                validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u8865\u5145\u5408\u540c\u91d1\u989d\"\u4e0e\"\u7a0e\u76ee\u660e\u7ec6\u4e2d\u542b\u7a0e\u91d1\u989d\u7684\u5408\u8ba1\u503c\"\u4e0d\u76f8\u7b49,\u4e0d\u5141\u8bb8\u63d0\u4ea4!", (String)"SupplyConBillSubmitOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (SuppFormWayEnum.CHGTOSUPP.getValue().equals(supplyObj.getString("formway")) && 0 == (chgCfmEntry = supplyObj.getDynamicObjectCollection("supplyconchgentry")).size()) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8865\u5145\u5408\u540c\u5f62\u6210\u65b9\u5f0f\u4e3a\u53d8\u66f4\u8f6c\u8865\u5145\uff0c\u8bf7\u9009\u62e9\u53d8\u66f4\u5217\u8868", (String)"SupplyConBillSubmitOpPlugin_2", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            return;
        }
        this.checkEstChgAmt(validator, dataEntity);
    }

    protected void checkEstChgAmt(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        this.getOpHelper().checkEstChgAmt(this.getAppId(), validator, dataEntity);
    }

    @Override
    protected void beforeSubmitTransaction(BeforeOperationArgs args, DynamicObject model) {
        super.beforeSubmitTransaction(args, model);
        this.getOpHelper().beforeTransaction4UpdateConCfmRefBillStatus(this.getAppId(), model, " ");
    }

    @Override
    protected void endSubmitTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endSubmitTransaction(args, model);
        this.getOpHelper().endTransaction4UpdateConCfmRefBillStatus(this.getAppId(), model, model.getString("billstatus"));
    }

    @Override
    protected void syncSupplierName(DynamicObject model) {
        super.syncSupplierName(model);
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("partyb", "partybname", this.billEntityType.getExtendName(), model, "submit"));
    }
}

