/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.opplugin.supplyconbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ContractBillHelper;
import kd.pccs.concs.business.helper.ContractCenterHelper;
import kd.pccs.concs.business.helper.PayReqBillHelper;
import kd.pccs.concs.common.enums.SuppFormWayEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.opplugin.base.AbstractBillValidator;
import kd.pccs.concs.opplugin.billtpl.BillUnAuditOpPlugin;
import kd.pccs.concs.opplugin.supplyconbill.SupplyConBillOpHelper;

public class SupplyConBillUnAuditOpPlugin
extends BillUnAuditOpPlugin {
    protected SupplyConBillOpHelper getOpHelper() {
        return new SupplyConBillOpHelper();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        this.getOpHelper().onPreparePropertys(fieldKeys);
        fieldKeys.add("chgentry_changebill");
        fieldKeys.add("supplyconchgentry");
        fieldKeys.add("taxentry");
        fieldKeys.add("taxentry_oriamt");
        fieldKeys.add("taxentry_amount");
    }

    @Override
    protected void checkBeforeOperation(AbstractBillValidator validator, ExtendedDataEntity dataEntity) {
        boolean moreThanPayReqAmtFlag;
        super.checkBeforeOperation(validator, dataEntity);
        DynamicObject model = dataEntity.getDataEntity();
        DynamicObject contractBill = model.getDynamicObject("contractbill");
        long conId = contractBill.getLong("id");
        boolean existsConSettleFlag = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", (Object)conId)});
        if (existsConSettleFlag) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5408\u540c\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"SupplyConBillUnAuditOpPlugin_0", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal curAmt = model.getBigDecimal("oriamt");
        if (SuppFormWayEnum.CHGTOSUPP.getValue().equals(model.getString("formway"))) {
            DynamicObjectCollection chgCfmCol = model.getDynamicObjectCollection("supplyconchgentry");
            BigDecimal totalCfmAmt = chgCfmCol.stream().map(chgCfm -> BusinessDataServiceHelper.loadSingle((Object)chgCfm.getDynamicObject("chgentry_changebill").getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"chgcfmbill"), (String)"oriamt")).map(chgCfnInfo -> chgCfnInfo.getBigDecimal("oriamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            curAmt = NumberUtil.subtract((Object)curAmt, (Object)totalCfmAmt);
        }
        if (moreThanPayReqAmtFlag = PayReqBillHelper.checkMoreThanPayReqAmt((String)this.getAppId(), (Long)conId, (BigDecimal)curAmt, (BigDecimal)BigDecimal.ZERO)) {
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u8865\u5145\u5408\u540c\u53cd\u5ba1\u6279\u540e\uff0c\u5b58\u5728\u8d85\u4ed8\u73b0\u8c61\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279", (String)"SupplyConBillUnAuditOpPlugin_1", (String)"pccs-concs-opplugin", (Object[])new Object[0]));
        }
        this.getOpHelper().checkEstChgAmt(this.getAppId(), validator, dataEntity);
    }

    @Override
    protected void beforeUnAuditTransaction(BeforeOperationArgs args, DynamicObject model) {
        super.beforeUnAuditTransaction(args, model);
        this.getOpHelper().beforeTransaction4UpdateConCfmRefBillStatus(this.getAppId(), model, " ");
    }

    @Override
    protected void endUnAuditTransaction(EndOperationTransactionArgs args, DynamicObject model) {
        super.endUnAuditTransaction(args, model);
        this.getOpHelper().endTransaction4UpdateConCfmRefBillStatus(this.getAppId(), model, model.getString("billstatus"));
        this.syncContractData(model);
    }

    protected void syncContractData(DynamicObject model) {
        DynamicObject contractBill = model.getDynamicObject("contractbill");
        Long conId = (Long)contractBill.getPkValue();
        new ContractBillHelper().updateContractInfo(this.getAppId(), conId.longValue());
        ContractCenterHelper.syncSuppAmt2CC((String)this.getAppId(), (long)conId);
        new ContractCenterHelper().syncChgAmt2CC(this.getAppId(), conId.longValue());
        ContractCenterHelper.synContractCenterInfo((String)this.getAppId(), (long)conId);
    }
}

