/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.base;

import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.base.F7CustomQFilter;

public abstract class AbstractF7SelectListener
implements AfterF7SelectListener,
BeforeF7SelectListener {
    protected AbstractFormPlugin plugin;
    protected IDataModel dataModel;
    protected IFormView view;
    protected IPageCache pageCache;
    protected F7CustomQFilter customQFilter;
    protected boolean onlyEnable = true;
    protected boolean onlyLeaf = true;
    protected boolean includeSysPreSet = true;
    protected boolean needCustomF7ViewFlag = false;

    public AbstractF7SelectListener(AbstractFormPlugin plugin, IDataModel dataModel) {
        this.plugin = plugin;
        this.dataModel = dataModel;
        this.view = plugin.getView();
        this.pageCache = plugin.getPageCache();
    }

    protected AbstractFormPlugin getPlugin() {
        return this.plugin;
    }

    protected IDataModel getModel() {
        return this.dataModel;
    }

    protected IFormView getView() {
        return this.view;
    }

    protected IPageCache getPageCache() {
        return this.pageCache;
    }

    protected String getAppId() {
        return MetaDataUtil.getAppIdByView((IFormView)this.view);
    }

    public final AbstractF7SelectListener setCustomQFilter(F7CustomQFilter f7CustomQFilter) {
        this.customQFilter = f7CustomQFilter;
        return this;
    }

    public final AbstractF7SelectListener setOnlyEnable(boolean onlyEnable) {
        this.onlyEnable = onlyEnable;
        return this;
    }

    public final AbstractF7SelectListener setOnlyLeaf(boolean onlyLeaf) {
        this.onlyLeaf = onlyLeaf;
        return this;
    }

    public final AbstractF7SelectListener setIncludeSysPreSet(boolean includeSysPreSet) {
        this.includeSysPreSet = includeSysPreSet;
        return this;
    }

    public final AbstractF7SelectListener setNeedCustomF7View(boolean needCustomF7ViewFlag) {
        this.needCustomF7ViewFlag = needCustomF7ViewFlag;
        return this;
    }

    public final AbstractF7SelectListener registerListener(BasedataEdit bdCtrl) {
        if (null == bdCtrl) {
            return this;
        }
        bdCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        if (this.needCustomF7ViewFlag) {
            bdCtrl.addBeforeF7ViewDetailListener(this::showF7FormBill);
        }
        return this;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (null != this.customQFilter) {
            this.customQFilter.customQFilters(evt, qFilters);
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
    }

    protected void showF7FormBill(BeforeF7ViewDetailEvent evt) {
        evt.setCancel(true);
        BillShowParameter param = new BillShowParameter();
        param.setFormId(this.getF7ViewFormId(evt.getPkId()));
        param.setPkId(this.getF7ViewBillId(evt.getPkId()));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }

    protected Object getF7ViewBillId(Object f7Id) {
        return f7Id;
    }

    protected String getF7ViewFormId(Object f7Id) {
        return null;
    }
}

