/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.bd.contemplate;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeFileType;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.control.model.WebOfficeTrackingType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.util.WebOfficeUtil;
import org.apache.commons.lang.StringUtils;

public class ConTemplateDesignPlugIn
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener,
WebOfficeDataListener {
    private static final Logger log = Logger.getLogger(ConTemplateDesignPlugIn.class.getName());
    public static final String ENTRYENTITYDOC = "entryentitydoc";
    public static final String DOCVARIABLE = "docvariable";
    public static final String DOCKEY = "dockey";
    public static final String DOCVALUE = "docvalue";
    public static final String DOCDEL = "docdel";
    public static final String DOCLOCATION = "doclocation";
    public static final String ENTRYENTITY = "entryentity";
    public static final String KEY = "key";
    public static final String OPERATION = "operation";
    public static final String EDIT_OPERATION = "edit_operation";
    public static final String EDIT_BOOKMARK = "edit_bookmark";
    public static final String ENTITY_EDIT = "entity_edit";
    public static final String UTF8 = "utf-8";
    public static final String BTN_UPLOAD = "btn_upload";
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_OPENNEWDOC = "btn_opennewdoc";
    protected static final String APPID = "appId";

    protected String getAppId() {
        return (String)this.getView().getFormShowParameter().getCustomParam(APPID);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Object id = param.getCustomParam("id");
        DynamicObject conTemplate = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contemplate"));
        String fileUrl = conTemplate.getString("currentdocurl");
        String name = StringUtils.isBlank((String)conTemplate.getString("currentdocname")) ? conTemplate.getString("name") : conTemplate.getString("currentdocname");
        this.getModel().setValue("id", id);
        this.getModel().setValue("billname", (Object)name);
        this.initVariableGrid(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
        this.initDocGrid(id);
        String docUrl = fileUrl;
        if (StringUtils.isNotBlank((String)docUrl) && StringUtils.isNotBlank((String)name)) {
            if (StringUtils.isEmpty((String)(docUrl = UrlService.getAttachmentFullUrl((String)docUrl)))) {
                return;
            }
            String encode = "";
            try {
                encode = URLEncoder.encode(name, UTF8);
            }
            catch (UnsupportedEncodingException ex) {
                log.info(ex.getMessage());
            }
            docUrl = docUrl.replace(name, encode);
            WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
            webOffice.open(docUrl);
        }
    }

    protected void initDocGrid(Object id) {
        DynamicObject contemplate = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contemplate"));
        DynamicObjectCollection list = contemplate.getDynamicObjectCollection("variableentry");
        if (null != list && !list.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITYDOC, list.size());
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject obj = (DynamicObject)list.get(i);
                String name = obj.getString("variablename");
                String markKey = obj.getString("variablekey");
                String markValue = obj.getString("variablevalue");
                String varaible = obj.getString("variablemap");
                this.getModel().setValue("docname", (Object)name, i);
                this.getModel().setValue(DOCVARIABLE, (Object)varaible, i);
                this.getModel().setValue(DOCKEY, (Object)markKey, i);
                this.getModel().setValue(DOCVALUE, (Object)markValue, i);
                this.getModel().setValue(DOCDEL, (Object)ResManager.loadKDString((String)"\u5220\u9664\u4e66\u7b7e", (String)"ConTemplateDesignPlugIn_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]), i);
                this.getModel().setValue(DOCLOCATION, (Object)ResManager.loadKDString((String)"\u5b9a\u4f4d\u4e66\u7b7e", (String)"ConTemplateDesignPlugIn_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]), i);
            }
        }
    }

    protected void initVariableGrid(String docNumber) {
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)docNumber);
        Map dataMap = mainEntity.getFields();
        dataMap.remove("condocfileid");
        dataMap.remove("condocname");
        dataMap.remove("condocurl");
        dataMap.remove("bizstatus");
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, dataMap.size());
        int i = 0;
        for (Map.Entry entry : dataMap.entrySet()) {
            String name = ((IDataEntityProperty)entry.getValue()).getDisplayName().toString();
            this.getModel().setValue("name", (Object)name, i);
            this.getModel().setValue(KEY, entry.getKey(), i);
            this.getModel().setValue(OPERATION, (Object)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"ConTemplateDesignPlugIn_2", (String)"pccs-concs-formplugin", (Object[])new Object[0]), i);
            ++i;
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        switch (fieldName) {
            case "operation": {
                this.insertVariable(rowIndex);
                break;
            }
            case "docdel": {
                this.deleteMark(rowIndex);
                break;
            }
            case "doclocation": {
                this.locateMark(rowIndex);
                break;
            }
        }
    }

    protected void locateMark(int rowIndex) {
        String markKey = (String)this.getModel().getValue(DOCKEY, rowIndex);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.locateMark(markKey);
    }

    protected void deleteMark(int rowIndex) {
        String markKey = (String)this.getModel().getValue(DOCKEY, rowIndex);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.deleteMarks(Collections.singletonList(markKey));
        this.getModel().deleteEntryRow(ENTRYENTITYDOC, rowIndex);
    }

    protected void insertVariable(int rowIndex) {
        String name = (String)this.getModel().getValue("name", rowIndex);
        String key = (String)this.getModel().getValue(KEY, rowIndex);
        int row = this.getModel().insertEntryRow(ENTRYENTITYDOC, 0);
        String markKey = key + "_" + System.currentTimeMillis();
        String markValue = "\u3010" + name + "\u3011";
        this.getModel().setValue("docname", (Object)name, row);
        this.getModel().setValue(DOCVARIABLE, (Object)key, row);
        this.getModel().setValue(DOCKEY, (Object)markKey, row);
        this.getModel().setValue(DOCVALUE, (Object)markValue, row);
        this.getModel().setValue(DOCDEL, (Object)ResManager.loadKDString((String)"\u5220\u9664\u4e66\u7b7e", (String)"ConTemplateDesignPlugIn_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]), row);
        this.getModel().setValue(DOCLOCATION, (Object)ResManager.loadKDString((String)"\u5b9a\u4f4d\u4e66\u7b7e", (String)"ConTemplateDesignPlugIn_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]), row);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addMarks(new WebOfficeMark(markKey, markValue));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_UPLOAD, BTN_OPENNEWDOC});
        Button uploadButton = (Button)this.getControl(BTN_UPLOAD);
        uploadButton.addUploadListener((UploadListener)this);
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid markGrid = (EntryGrid)this.getControl(ENTRYENTITYDOC);
        markGrid.addHyperClickListener((HyperLinkClickListener)this);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addUploadListener((UploadListener)this);
        webOffice.addDataListener((WebOfficeDataListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "btn_save": {
                this.saveDoc();
                break;
            }
            case "btn_opennewdoc": {
                this.openDoc();
                break;
            }
        }
    }

    private void openDoc() {
        this.clearEntryEntitydoc();
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.openNew(WebOfficeFileType.word);
    }

    private void clearEntryEntitydoc() {
        DynamicObjectCollection entryEntityDoc = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITYDOC);
        entryEntityDoc.clear();
        this.getView().updateView(ENTRYENTITYDOC);
    }

    protected void saveDoc() {
        String name = this.getModel().getDataEntity().getString("billname");
        if (StringUtils.isBlank((String)name)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ConTemplateDesignPlugIn_3", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            return;
        }
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String userName = RequestContext.get().getUserName();
        webOffice.setTrackingMode(userName, WebOfficeTrackingType.TRACKING_EDIT);
        webOffice.save(name);
    }

    public void afterUpload(UploadEvent evt) {
        Long id = (Long)this.getModel().getValue("id");
        DynamicObject conTemplate = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contemplate"));
        String docurl = conTemplate.getString("currentdocurl");
        String docname = conTemplate.getString("currentdocname");
        String name = conTemplate.getString("name");
        Object[] urls = evt.getUrls();
        if (null == urls || urls.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u6863", (String)"ConTemplateDesignPlugIn_4", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, String> urlMap = WebOfficeUtil.handleFileUrl(urls, docurl, docname, name);
        String filePath = urlMap.get("filePath");
        String fileName = urlMap.get("fileName");
        String url = urlMap.get("url");
        HashMap<String, Object> filePathDataMap = new HashMap<String, Object>();
        filePathDataMap.put(APPID, this.getAppId());
        filePathDataMap.put("formId", this.getView().getFormShowParameter().getFormId());
        filePathDataMap.put("pkId", id);
        Map<String, String> uploaDataMap = WebOfficeUtil.uploadTempFile(url, docurl, filePath, fileName, filePathDataMap);
        fileName = uploaDataMap.get("fileName");
        url = uploaDataMap.get("url");
        String key = evt.getCallbackKey();
        if (BTN_UPLOAD.equals(key)) {
            WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
            WebOfficeUtil.openWebOfficeFile(webOffice, url, fileName);
            this.clearEntryEntitydoc();
        } else if ("webofficeap".equals(key)) {
            DynamicObjectCollection bookMarks = this.getModel().getEntryEntity(ENTRYENTITYDOC);
            conTemplate.set("currentdocurl", (Object)url);
            conTemplate.set("currentdocname", (Object)fileName);
            Long conTempDocFileId = conTemplate.getLong("contempdocfileid");
            try {
                conTempDocFileId = WebOfficeUtil.uploadDoc(this.getAppId(), id, conTempDocFileId, fileName, url, false);
            }
            catch (IOException e) {
                log.info(e.getMessage());
            }
            conTemplate.set("contempdocfileid", (Object)conTempDocFileId);
            DynamicObjectCollection list = conTemplate.getDynamicObjectCollection("variableentry");
            list.clear();
            int index = 1;
            for (DynamicObject mark : bookMarks) {
                DynamicObject obj = new DynamicObject(list.getDynamicObjectType());
                obj.set("variablename", mark.get("docname"));
                obj.set("variablekey", mark.get(DOCKEY));
                obj.set("variablevalue", mark.get(DOCVALUE));
                obj.set("variablemap", mark.get(DOCVARIABLE));
                obj.set("seq", (Object)index++);
                list.add((Object)obj);
            }
            SaveServiceHelper.save((IDataEntityType)conTemplate.getDynamicObjectType(), (Object[])new Object[]{conTemplate});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ConTemplateDesignPlugIn_5", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        }
    }

    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent event) {
    }

    public void onGetAllBookmarks(WebOfficeBookmarkEvent event) {
    }

    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent event) {
    }

    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent event) {
    }

    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent event) {
    }

    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent arg0) {
    }

    public void onSendOpenStatus(WebOfficeOpenStatusEvent arg0) {
    }
}

