/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.bd.contracttype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.pccs.concs.common.entity.ContractBillConst;
import kd.pccs.concs.common.entity.bd.DataStandardConst;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.bdtpl.BaseTreeOrgTplListPlugin;
import org.apache.commons.lang.StringUtils;

public class ContractTypeListPlugin
extends BaseTreeOrgTplListPlugin {
    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operation = (FormOperate)args.getSource();
        if (StringUtils.equals((String)operation.getOperateKey(), (String)"delete")) {
            DynamicObject[] contractBills;
            ListSelectedRowCollection rowDatas = args.getListSelectedData();
            Object[] ids = new Object[rowDatas.size()];
            for (int i = 0; i < rowDatas.size(); ++i) {
                ids[i] = rowDatas.get(i).getPrimaryKeyValue();
            }
            DynamicObject[] contractTypeColl = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contracttype"), (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.FALSE), new QFilter("id", "in", (Object)ids)});
            if (contractTypeColl.length == 0) {
                return;
            }
            HashSet<Object> needDeletedIds = new HashSet<Object>(contractTypeColl.length);
            for (DynamicObject conType : contractTypeColl) {
                needDeletedIds.add(conType.getPkValue());
            }
            DynamicObject[] dataStandards = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard"), (String)"group", (QFilter[])new QFilter[]{new QFilter("group", "in", needDeletedIds)});
            if (dataStandards.length > 0) {
                for (DynamicObject dataStandard : dataStandards) {
                    DynamicObject conType = (DynamicObject)dataStandard.get("group");
                    needDeletedIds.remove(conType.getPkValue());
                }
            }
            if (needDeletedIds.size() > 0 && (contractBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)"contracttype", (QFilter[])new QFilter[]{new QFilter("contracttype", "in", needDeletedIds)})).length > 0) {
                for (DynamicObject contractBill : contractBills) {
                    DynamicObject conType = (DynamicObject)contractBill.get("contracttype");
                    needDeletedIds.remove(conType.get("id"));
                }
            }
            if (needDeletedIds.size() > 0) {
                DeleteServiceHelper.delete((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conctrlstand"), (QFilter[])new QFilter[]{new QFilter("group", "in", needDeletedIds)});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operation = (FormOperate)afterDoOperationEventArgs.getSource();
        if (StringUtils.equals((String)operation.getOperateKey(), (String)"delete")) {
            ValidateResultCollection validateResult;
            DynamicObject contractType;
            DynamicObject[] conStandards;
            String createOrgId = this.getPageCache().get("createOrg");
            DynamicObject[] contractTypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contracttype"), (String)String.join((CharSequence)",", "id", "name", "number", "org", "createorg", "useorg", "ctrlstrategy", "longnumber"), (QFilter[])new QFilter[]{new QFilter("isleaf", "=", (Object)true), new QFilter("createorg", "=", (Object)createOrgId)});
            HashMap<Long, DynamicObject> contractTypeMap = new HashMap<Long, DynamicObject>();
            HashSet<Long> idSet = new HashSet<Long>();
            if (contractTypes.length > 0) {
                for (DynamicObject contractType2 : contractTypes) {
                    idSet.add(contractType2.getLong("id"));
                    contractTypeMap.put(contractType2.getLong("id"), contractType2);
                }
            }
            if ((conStandards = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conctrlstand"), (String)String.join((CharSequence)",", "group", "id"), (QFilter[])new QFilter[]{new QFilter("group", "in", idSet)})).length > 0) {
                for (DynamicObject conStandard : conStandards) {
                    contractType = conStandard.getDynamicObject("group");
                    Long contractTypeId = contractType.getLong("id");
                    idSet.remove(contractTypeId);
                }
            }
            if (idSet.size() > 0) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conctrlstand"));
                for (Long conTypeId : idSet) {
                    DynamicObject conCtrlStand = new DynamicObject((DynamicObjectType)dataEntityType);
                    contractType = (DynamicObject)contractTypeMap.get(conTypeId);
                    conCtrlStand.set("number", contractType.get("longnumber"));
                    conCtrlStand.set("name", contractType.get("name"));
                    conCtrlStand.set("org", contractType.get("org"));
                    conCtrlStand.set("createorg", contractType.get("createorg"));
                    conCtrlStand.set("useorg", contractType.get("useorg"));
                    conCtrlStand.set("ctrlstrategy", contractType.get("ctrlstrategy"));
                    conCtrlStand.set("group", (Object)conTypeId);
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conctrlstand"), (DynamicObject[])new DynamicObject[]{conCtrlStand}, (OperateOption)OperateOption.create());
                    if (result.isSuccess()) continue;
                    throw new KDBizException(((IOperateInfo)result.getAllErrorOrValidateInfo().get(0)).getMessage());
                }
            }
            if ((validateResult = afterDoOperationEventArgs.getOperationResult().getValidateResult()).getValidateErrors() != null) {
                for (ValidateResult validateError : validateResult.getValidateErrors()) {
                    List errorInfos = validateError.getAllErrorInfo();
                    for (int j = 0; j < errorInfos.size(); ++j) {
                        String message = ((OperateErrorInfo)errorInfos.get(j)).getMessage();
                        if (message.indexOf(ResManager.loadKDString((String)"[\u5408\u540c\u7ba1\u63a7\u6807\u51c6]\u7684\u5b57\u6bb5[\u5408\u540c\u7c7b\u578b\u540d\u79f0]\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e", (String)"ContractTypeListPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0])) == -1) continue;
                        errorInfos.remove(j);
                        --j;
                    }
                }
            }
        }
    }

    @Override
    protected List<Map<String, String>> getRefBillList() {
        ArrayList<Map<String, String>> refBillList = new ArrayList<Map<String, String>>();
        HashMap<String, String> billMap = new HashMap<String, String>();
        billMap.put("refField", "group");
        billMap.put("entityName", "datastandard");
        billMap.put("billName", DataStandardConst.ENTITY_NAME_ALIAS);
        refBillList.add(billMap);
        billMap = new HashMap();
        billMap.put("refField", "contracttype");
        billMap.put("entityName", "contractbill");
        billMap.put("billName", ContractBillConst.ENTITY_NAME_ALIAS);
        refBillList.add(billMap);
        return refBillList;
    }
}

