/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.bd.datastandard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.bdtpl.BaseGroupOrgTplListPlugin;

public class DataStandardListPlugin
extends BaseGroupOrgTplListPlugin {
    private static final String IMPORTDATASTANDARD_BTN = "importdatastandard";
    private static final String CURBILLTYPE = "curbilltype";
    private static final String COMMONFILTER_USEORGID = "useorg.id";
    private static final String CTRL_FILTER = "ctrl_filter";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "importdatastandard": {
                String curNodeId = (String)this.getTreeModel().getCurrentNodeId();
                TreeNode curNode = this.getTreeModel().getRoot().getTreeNode(curNodeId, 10);
                if (curNode == null || curNode.getChildren() != null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6700\u672b\u7ea7\u5408\u540c\u7c7b\u578b\u540e\u518d\u5f15\u5165\uff01", (String)"DataStandardListPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.showImportDataStandard();
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        for (int i = 0; i < filters.size(); ++i) {
            QFilter filter = (QFilter)filters.get(i);
            if ("billtype".equals(filter.getProperty()) && this.getPageCache().get(CURBILLTYPE) == null) {
                this.getPageCache().put(CURBILLTYPE, (String)filter.getValue());
            }
            if (filter.getJoinEntityPath() == null || !filter.getJoinEntityPath().equals(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard"))) continue;
            this.getPageCache().put(CTRL_FILTER, filter.toSerializedString());
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if (this.getPageCache().get("createorg") == null) {
            FilterContainerInitEvent event = args.getFilterContainerInitEvent();
            List commonFilters = event.getCommonFilterColumns();
            for (FilterColumn commonFilter : commonFilters) {
                if (!COMMONFILTER_USEORGID.equals(commonFilter.getFieldName()) || commonFilter.getDefaultValues() == null || commonFilter.getDefaultValues().size() <= 0) continue;
                this.getPageCache().put("createorg", String.valueOf(commonFilter.getDefaultValues().get(0)));
            }
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        if (args == null || args.getCurrentCommonFilter() == null) {
            return;
        }
        if (args.getCurrentCommonFilter() != null) {
            Map commonFilter = args.getCurrentCommonFilter();
            List fieldNames = (List)commonFilter.get("FieldName");
            for (Object fieldName : fieldNames) {
                if ("billtype".equals(fieldName.toString())) {
                    this.getPageCache().put(CURBILLTYPE, (String)((List)commonFilter.get("Value")).get(0));
                    continue;
                }
                if (!COMMONFILTER_USEORGID.equals(fieldName.toString())) continue;
                this.getPageCache().put("createorg", (String)((List)commonFilter.get("Value")).get(0));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard_import").equals(actionId)) {
            ListSelectedRowCollection datas = (ListSelectedRowCollection)e.getReturnData();
            this.addNewDatastandard(datas);
            this.treeListView.refresh();
        }
    }

    protected void showImportDataStandard() {
        if (this.getPageCache().get("createorg") == null) {
            this.getPageCache().put("createorg", String.valueOf(RequestContext.get().getOrgId()));
        }
        ListShowParameter listParam = ShowFormHelper.createShowListForm((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard"), (boolean)true);
        listParam.setCustomParam(CTRL_FILTER, (Object)this.getPageCache().get(CTRL_FILTER));
        listParam.setCustomParam("createorg", (Object)this.getPageCache().get("createorg"));
        listParam.setCaption(ResManager.loadKDString((String)"\u5f15\u7528\u5355\u636e", (String)"DataStandardListPlugin_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard_import")));
        this.getView().showForm((FormShowParameter)listParam);
    }

    protected void addNewDatastandard(ListSelectedRowCollection selectRows) {
        if (selectRows == null || selectRows.size() <= 0) {
            return;
        }
        Object[] rowIds = selectRows.getPrimaryKeyValues();
        String selectProperties = String.join((CharSequence)",", "id", "billtype", "name", "group", "description", "enable", "isrequired", "status", "org", "createorg", "useorg", "ctrlstrategy");
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", new HashSet<Object>(Arrays.asList(rowIds)))};
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard"), (String)selectProperties, (QFilter[])filter);
        long curUserId = UserServiceHelper.getCurrentUserId();
        String orgId = this.getPageCache().get("createorg");
        String billType = this.getPageCache().get(CURBILLTYPE);
        String curContypeId = (String)this.getTreeModel().getCurrentNodeId();
        HashSet<DynamicObject> newdatas = new HashSet<DynamicObject>();
        HashSet<String> newdataNames = new HashSet<String>();
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject data = datas[i];
            QFilter[] vaildFilter = new QFilter[]{new QFilter("name", "=", (Object)data.getString("name")), new QFilter("billtype", "=", (Object)billType), new QFilter("group", "=", (Object)curContypeId), new QFilter("createorg", "=", (Object)orgId)};
            if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard"), (QFilter[])vaildFilter) || newdataNames.contains(data.get("name").toString())) continue;
            newdataNames.add(data.get("name").toString());
            DynamicObject newdata = BusinessDataServiceHelper.newDynamicObject((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard"));
            newdata.set("billtype", (Object)billType);
            newdata.set("name", data.get("name"));
            newdata.set("group", (Object)Long.parseLong(curContypeId));
            newdata.set("description", data.get("description"));
            newdata.set("enable", data.get("enable"));
            newdata.set("isrequired", data.get("isrequired"));
            newdata.set("status", data.get("status"));
            newdata.set("ctrlstrategy", data.get("ctrlstrategy"));
            newdata.set("creator", (Object)curUserId);
            newdata.set("createtime", (Object)new Date());
            newdata.set("modifier", (Object)curUserId);
            newdata.set("modifytime", (Object)new Date());
            newdata.set("org", (Object)orgId);
            newdata.set("createorg", (Object)orgId);
            newdata.set("useorg", (Object)orgId);
            newdatas.add(newdata);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard"));
        SaveServiceHelper.save((IDataEntityType)type, (Object[])newdatas.toArray());
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(Long.valueOf(orgId));
        BaseDataServiceHelper.refreshBaseDataUseRange((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"datastandard"), orgIds);
    }
}

