/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.bdtpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.concs.business.helper.bdtpl.BaseParamSetFormHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.ParameterUtil;
import kd.pccs.concs.common.util.PermissionUtil;
import kd.pccs.concs.common.util.TreeUtil;

public class BaseParamSetFormPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    protected static final String CONTROL_STRATEGYLIST = "strategylist";
    protected static final String CONTROL_ORGPROJECTTREE = "orgprojecttree";
    protected static final String CONTROL_BTN_SAVE = "btn_save";
    protected static final String CONTROL_BTN_MODIFY = "btn_modify";
    protected static final String CACHE_MODIFYDATAS = "modifyDatas";
    protected static final String CACHE_ROOTNODE = "rootNode";
    protected static final String CACHE_MODIFYFLAG = "modifyFlag";
    protected static final String PRESEARCHTEXT = "preSearchText";
    protected static final String PRESEARCHNODES = "preSearchNodes";
    protected static final String PRESEARCHNODEINDEX = "preSearchNodeIndex";

    public String getAppId() {
        return MetaDataUtil.getAppIdByView((IFormView)this.getView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((TreeView)this.getView().getControl(CONTROL_ORGPROJECTTREE)).addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeNode root = this.loadTreeData();
        ((TreeView)this.getView().getControl(CONTROL_ORGPROJECTTREE)).addNode(root);
        this.loadStrategyListData(root);
        this.getPageCache().put(CACHE_ROOTNODE, SerializationUtils.toJsonString((Object)root));
        if (this.getPageCache().get(CACHE_MODIFYFLAG) == null || "false".equals(this.getPageCache().get(CACHE_MODIFYFLAG))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTN_SAVE});
        }
    }

    protected TreeNode loadTreeData() {
        return null;
    }

    protected List<String> getParamColNames() {
        return new ArrayList<String>();
    }

    protected DynamicObjectCollection loadStrategyListData(TreeNode node) {
        EntryGrid strategyList = (EntryGrid)this.getView().getControl(CONTROL_STRATEGYLIST);
        List<String> paramColNames = this.getParamColNames();
        Map<String, Map<String, String>> nodeDetailDatas = this.getNodeDetailDatas(node);
        Map paramDatas = BaseParamSetFormHelper.getParameterDatas((String)this.getAppId(), nodeDetailDatas.keySet());
        DynamicObjectCollection rows = strategyList.getModel().getDataEntity().getDynamicObjectCollection(CONTROL_STRATEGYLIST);
        DynamicObjectType type = rows.getDynamicObjectType();
        for (Map.Entry<String, Map<String, String>> headData : nodeDetailDatas.entrySet()) {
            String bizId = headData.getKey();
            Map<String, String> nodeDetail = headData.getValue();
            DynamicObject param = (DynamicObject)paramDatas.get(bizId);
            if (param == null) {
                param = nodeDetail.get("isproject").equals(Boolean.TRUE.toString()) ? ParameterUtil.getProjectParam((String)this.getAppId(), (String)bizId) : ParameterUtil.getOrgParam((String)this.getAppId(), (String)bizId);
            }
            DynamicObject row = new DynamicObject(type);
            row.set("id", param.get("id"));
            row.set("bizid", (Object)bizId);
            row.set("bizname", (Object)nodeDetail.get("bizname"));
            row.set("bizorgid", (Object)nodeDetail.get("bizorgid"));
            row.set("isproject", (Object)nodeDetail.get("isproject"));
            for (String col : paramColNames) {
                row.set(col, (Object)param.getString(col));
            }
            rows.add((Object)row);
        }
        this.getModel().updateEntryCache(rows);
        this.tableSetEditable();
        return rows;
    }

    protected Map<String, Map<String, String>> getNodeDetailDatas(TreeNode node) {
        List allNodes = TreeUtil.getNodeAndAllChildrens((TreeNode)node);
        LinkedHashMap<String, Map<String, String>> map = new LinkedHashMap<String, Map<String, String>>(allNodes.size());
        for (int i = 0; i < allNodes.size(); ++i) {
            TreeNode treeNode = (TreeNode)allNodes.get(i);
            Boolean isProject = treeNode.getData() == null ? Boolean.FALSE : (Boolean)treeNode.getData();
            HashMap<String, String> nodeData = new HashMap<String, String>();
            nodeData.put("bizname", treeNode.getText());
            nodeData.put("bizorgid", isProject != false ? treeNode.getParentid() : treeNode.getId());
            nodeData.put("isproject", Boolean.toString(isProject));
            nodeData.put("rowIndex", String.valueOf(i));
            map.put(treeNode.getId(), nodeData);
        }
        return map;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newVal = changeData.getNewValue();
        Object oldVal = changeData.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        this.comboPropertyChanged(e, changeData, newVal);
    }

    protected void comboPropertyChanged(PropertyChangedArgs e, ChangeData changeData, Object newVal) {
        if (newVal == null) {
            return;
        }
        String paramName = e.getProperty().getName();
        String id = changeData.getDataEntity().getString("id");
        Map modifyDatas = new HashMap();
        Map<String, String> modifyData = new HashMap<String, String>();
        if (this.getPageCache().get(CACHE_MODIFYDATAS) != null && (modifyDatas = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_MODIFYDATAS), Map.class)).get(id) != null) {
            modifyData = (Map)modifyDatas.get(id);
        }
        modifyData.put(paramName, newVal.toString());
        modifyDatas.put(id, modifyData);
        this.getPageCache().put(CACHE_MODIFYDATAS, SerializationUtils.toJsonString(modifyDatas));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        switch (operateKey = formOp.getOperateKey()) {
            case "modify": {
                this.modifyOperation();
                break;
            }
            case "save": {
                this.saveOperation();
                break;
            }
            case "refresh": {
                this.refreshOperation();
                break;
            }
            case "close": {
                this.closeOperation();
                break;
            }
        }
    }

    protected void modifyOperation() {
        this.getPageCache().put(CACHE_MODIFYFLAG, "true");
        this.tableSetEditable();
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTN_MODIFY});
        this.getView().setEnable(Boolean.TRUE, new String[]{CONTROL_BTN_SAVE});
    }

    public void tableSetEditable() {
        this.tableSetRowEditable();
        this.tableSetCellEditable();
    }

    public void tableSetRowEditable() {
        String modifyFlag = this.getPageCache().get(CACHE_MODIFYFLAG);
        if (modifyFlag == null || "false".equals(modifyFlag)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_STRATEGYLIST});
            return;
        }
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)UserServiceHelper.getCurrentUserId(), (String)this.getAppId(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"ctrlstrategy_set"), (String)PermissionUtil.getPermItemId((String)"QXX0003"));
        List orgLists = result.getHasPermOrgs();
        ArrayList<Integer> lock = new ArrayList<Integer>();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(CONTROL_STRATEGYLIST);
        if (!result.hasAllOrgPerm()) {
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                String bizOrgId = row.getString("bizorgid");
                if (orgLists.contains(Long.valueOf(bizOrgId))) continue;
                lock.add(i);
            }
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{CONTROL_STRATEGYLIST});
        EntryGrid strategyList = (EntryGrid)this.getView().getControl(CONTROL_STRATEGYLIST);
        int[] lockRow = lock.stream().mapToInt(Integer::valueOf).toArray();
        strategyList.setRowLock(true, lockRow);
    }

    public void tableSetCellEditable() {
    }

    public void closeOperation() {
        this.checkHasModifyDatas();
    }

    public void saveOperation() {
        if (this.getPageCache().get(CACHE_MODIFYDATAS) != null) {
            long userId = UserServiceHelper.getCurrentUserId();
            Map modifyDatas = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_MODIFYDATAS), Map.class);
            ArrayList modifyDataArray = new ArrayList();
            Set modifyDataMap = modifyDatas.entrySet();
            modifyDataMap.forEach(modifyData -> {
                String id = (String)modifyData.getKey();
                DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"ctrlstrategy"));
                data.set("id", (Object)id);
                data.set("modifier", (Object)userId);
                data.set("modifydate", (Object)new Date());
                Set dataMap = ((Map)modifyData.getValue()).entrySet();
                dataMap.forEach(d -> data.set((String)d.getKey(), d.getValue()));
                modifyDataArray.add(data);
            });
            SaveServiceHelper.update((DynamicObject[])modifyDataArray.toArray(new DynamicObject[0]));
        }
        this.getPageCache().put(CACHE_MODIFYDATAS, null);
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTN_SAVE});
        this.getView().setEnable(Boolean.TRUE, new String[]{CONTROL_BTN_MODIFY});
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_STRATEGYLIST});
        this.getPageCache().put(CACHE_MODIFYFLAG, "false");
    }

    public void refreshOperation() {
        this.checkHasModifyDatas();
        this.getView().updateView();
        if (this.getPageCache().get(CACHE_ROOTNODE) != null) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ROOTNODE), TreeNode.class);
            TreeView treeView = (TreeView)this.getView().getControl(CONTROL_ORGPROJECTTREE);
            treeView.updateNode(root);
        }
    }

    public void checkHasModifyDatas() {
        Map modifyDatas;
        if (this.getPageCache().get(CACHE_MODIFYDATAS) != null && (modifyDatas = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_MODIFYDATAS), Map.class)).size() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\u5c1a\u672a\u4fdd\u5b58\uff0c\u64cd\u4f5c\u5c06\u4e22\u5931\u4fee\u6539", (String)"BaseParamSetFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        this.checkHasModifyDatas();
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ROOTNODE), TreeNode.class);
        TreeNode clickNode = rootNode.getTreeNode((String)e.getNodeId(), 20);
        this.loadStrategyListData(clickNode);
        this.getView().updateView(CONTROL_STRATEGYLIST);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (searchText != null && searchText.equals(this.getPageCache().get(PRESEARCHTEXT))) {
            List preSearchNodes = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(PRESEARCHNODES), TreeNode.class);
            int preSearchNodeIndex = Integer.parseInt(this.getPageCache().get(PRESEARCHNODEINDEX));
            int searchNodeIndex = (preSearchNodeIndex + 1) % preSearchNodes.size();
            TreeNode searchNode = (TreeNode)preSearchNodes.get(searchNodeIndex);
            TreeView treeView = (TreeView)this.getView().getControl(CONTROL_ORGPROJECTTREE);
            treeView.treeNodeClick(searchNode.getParentid(), searchNode.getId());
            treeView.focusNode(searchNode);
            treeView.expand(searchNode.getId());
            this.getPageCache().put(PRESEARCHNODEINDEX, String.valueOf(searchNodeIndex));
            return;
        }
        ArrayList searchNodes = new ArrayList();
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ROOTNODE), TreeNode.class);
        rootNode.getTreeNodeListByText(searchNodes, searchText, 20);
        if (searchNodes.size() >= 1) {
            TreeNode searchNode = (TreeNode)searchNodes.get(0);
            TreeView treeView = (TreeView)this.getView().getControl(CONTROL_ORGPROJECTTREE);
            treeView.treeNodeClick(searchNode.getParentid(), searchNode.getId());
            treeView.focusNode(searchNode);
            treeView.expand(searchNode.getId());
            this.getPageCache().put(PRESEARCHTEXT, searchText);
            this.getPageCache().put(PRESEARCHNODES, SerializationUtils.toJsonString(searchNodes));
            this.getPageCache().put(PRESEARCHNODEINDEX, "0");
        }
    }
}

