/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.billtpl;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTaxTplPropertyChanged;
import kd.pccs.concs.formplugin.billtpl.BillOrgTplFormPlugin;
import kd.pccs.concs.formplugin.f7.ProjectF7SelectListener;

public class BillOrgTaxTplFormPlugin
extends BillOrgTplFormPlugin {
    @Override
    protected void initPropertyChanged() {
        this.propertyChanged = new BillOrgTaxTplPropertyChanged(this, this.getModel());
    }

    @Override
    protected void registerProjectF7() {
        new ProjectF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("project"));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTaxInfo();
    }

    protected void initTaxInfo() {
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiTaxRate = billObj.getBoolean("multitaxrateflag");
        if (isMultiTaxRate) {
            billObj.set("bd_taxrate", null);
        } else {
            DynamicObject dbTaxRateObj = billObj.getDynamicObject("bd_taxrate");
            if (null != dbTaxRateObj) {
                billObj.set("taxrate", dbTaxRateObj.get("taxrate"));
            }
        }
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        ((BillOrgTaxTplPropertyChanged)this.propertyChanged).taxEntry_sumChanged();
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        FieldEdit fieldEdit;
        String ctrlName;
        super.beforeFieldPostBack(e);
        if (e.getSource() instanceof FieldEdit && ("taxentry_notaxamt".equals(ctrlName = (fieldEdit = (FieldEdit)e.getSource()).getKey()) || "notaxamt".equals(ctrlName))) {
            int rowIndex = e.getRowIndex();
            DynamicObject model = this.getModel().getDataEntity(true);
            BigDecimal amount = null;
            if (rowIndex < 0) {
                amount = model.getBigDecimal("amount");
            } else {
                DynamicObjectCollection taxEntrys = model.getDynamicObjectCollection("taxentry");
                DynamicObject entry = (DynamicObject)taxEntrys.get(rowIndex);
                amount = entry.getBigDecimal("taxentry_amount");
            }
            BigDecimal noTaxAmt = NumberUtil.toBigDecimal((Object)e.getValue());
            if (NumberUtil.compareTo((Object)noTaxAmt.abs(), (Object)amount.abs()) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d\u5927\u4e8e\u542b\u7a0e\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574", (String)"BillOrgTaxTplFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                if (rowIndex < 0) {
                    this.getView().updateView(ctrlName);
                } else {
                    this.getView().updateView(ctrlName, rowIndex);
                }
            }
        }
    }
}

