/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.billtpl;

import java.math.BigDecimal;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.base.AbstractPropertyChanged;
import org.apache.commons.lang.StringUtils;

public class BillOrgTaxTplPropertyChanged
extends AbstractPropertyChanged {
    public BillOrgTaxTplPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String ctrlName = e.getProperty().getName();
        if (StringUtils.isEmpty((String)ctrlName)) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        switch (ctrlName) {
            case "oriamt": {
                this.oriAmtChanged(newValue, oldValue);
                break;
            }
            case "amount": {
                this.amountChanged(newValue, oldValue);
                break;
            }
            case "bd_taxrate": {
                this.taxRateChanged(newValue, oldValue);
                break;
            }
            case "notaxamt": {
                this.noTaxAmtChanged(newValue, oldValue);
                break;
            }
            case "taxentry_oriamt": {
                this.taxEntry_oriAmtChanged(rowIndex, newValue, oldValue);
                this.taxEntry_sumChanged();
                break;
            }
            case "taxentry_amount": {
                this.taxEntry_amountChanged(rowIndex, newValue, oldValue);
                this.taxEntry_sumChanged();
                break;
            }
            case "taxentry_taxrate": {
                this.taxEntry_taxRateChanged(rowIndex, newValue, oldValue);
                this.taxEntry_sumChanged();
                break;
            }
            case "taxentry_notaxamt": {
                this.taxEntry_noTaxAmtChanged(rowIndex, newValue, oldValue);
                this.taxEntry_sumChanged();
                break;
            }
        }
    }

    protected void oriAmtChanged(Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiCurrency = billObj.getBoolean("foreigncurrencyflag");
        boolean isMultiTaxRate = billObj.getBoolean("multitaxrateflag");
        if (isMultiCurrency && (!isMultiTaxRate || isMultiTaxRate && NumberUtil.isZero((Object)billObj.get("amount")))) {
            BigDecimal exchangeRate = billObj.getBigDecimal("exchangerate");
            BigDecimal amount = NumberUtil.multiply((Object)newValue, (Object)exchangeRate);
            this.getModel().setValue("amount", (Object)amount);
        }
    }

    protected void amountChanged(Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiCurrency = billObj.getBoolean("foreigncurrencyflag");
        boolean isMultiTaxRate = billObj.getBoolean("multitaxrateflag");
        if (!isMultiCurrency) {
            this.getModel().setValue("oriamt", newValue);
        }
        if (!isMultiTaxRate) {
            BigDecimal taxRate = NumberUtil.divide((Object)billObj.get("taxrate"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
            BigDecimal noTaxAmt = NumberUtil.divide((Object)billObj.get("amount"), (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)taxRate));
            this.getModel().setValue("notaxamt", (Object)noTaxAmt);
        }
    }

    protected void taxRateChanged(Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiTaxRate = billObj.getBoolean("multitaxrateflag");
        if (!isMultiTaxRate) {
            BigDecimal taxRate = null;
            DynamicObject dbTaxRateObj = (DynamicObject)newValue;
            if (null != dbTaxRateObj) {
                taxRate = dbTaxRateObj.getBigDecimal("taxrate");
            }
            this.getModel().setValue("taxrate", (Object)taxRate);
            taxRate = NumberUtil.divide((Object)taxRate, (Object)NumberUtil.ONE_HUNDRED, (int)4);
            BigDecimal noTaxAmt = NumberUtil.divide((Object)billObj.get("amount"), (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)taxRate));
            this.getModel().setValue("notaxamt", (Object)noTaxAmt);
        }
    }

    protected void noTaxAmtChanged(Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiTaxRate = billObj.getBoolean("multitaxrateflag");
        if (!isMultiTaxRate) {
            this.getModel().setValue("tax", (Object)NumberUtil.subtract((Object)billObj.get("amount"), (Object)newValue));
        }
    }

    protected void taxEntry_oriAmtChanged(int rowIndex, Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiCurrency = billObj.getBoolean("foreigncurrencyflag");
        if (isMultiCurrency) {
            BigDecimal exchangeRate = billObj.getBigDecimal("exchangerate");
            BigDecimal amount = NumberUtil.multiply((Object)newValue, (Object)exchangeRate);
            this.getModel().setValue("taxentry_amount", (Object)amount, rowIndex);
        }
    }

    protected void taxEntry_amountChanged(int rowIndex, Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        DynamicObject taxEntryObj = this.getModel().getEntryRowEntity("taxentry", rowIndex);
        boolean isMultiCurrency = billObj.getBoolean("foreigncurrencyflag");
        boolean isMultiTaxRate = billObj.getBoolean("multitaxrateflag");
        if (!isMultiCurrency) {
            this.getModel().setValue("taxentry_oriamt", newValue, rowIndex);
        }
        if (isMultiTaxRate) {
            BigDecimal taxRate = null;
            DynamicObject dbTaxRateObj = taxEntryObj.getDynamicObject("taxentry_taxrate");
            if (null != dbTaxRateObj) {
                taxRate = dbTaxRateObj.getBigDecimal("taxrate");
            }
            BigDecimal noTaxAmt = NumberUtil.divide((Object)taxEntryObj.get("taxentry_amount"), (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)NumberUtil.divide((Object)taxRate, (Object)NumberUtil.ONE_HUNDRED, (int)4)));
            this.getModel().setValue("taxentry_notaxamt", (Object)noTaxAmt, rowIndex);
        }
    }

    protected void taxEntry_taxRateChanged(int rowIndex, Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiTaxRate = billObj.getBoolean("multitaxrateflag");
        if (isMultiTaxRate) {
            BigDecimal taxRate = null;
            DynamicObject dbTaxRateObj = (DynamicObject)newValue;
            if (null != dbTaxRateObj) {
                taxRate = dbTaxRateObj.getBigDecimal("taxrate");
            }
            DynamicObject taxEntryObj = this.getModel().getEntryRowEntity("taxentry", rowIndex);
            taxRate = NumberUtil.divide((Object)taxRate, (Object)NumberUtil.ONE_HUNDRED, (int)4);
            BigDecimal noTaxAmt = NumberUtil.divide((Object)taxEntryObj.get("taxentry_amount"), (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)taxRate));
            this.getModel().setValue("taxentry_notaxamt", (Object)noTaxAmt, rowIndex);
        }
    }

    protected void taxEntry_noTaxAmtChanged(int rowIndex, Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiTaxRate = billObj.getBoolean("multitaxrateflag");
        if (isMultiTaxRate) {
            DynamicObject taxEntryObj = this.getModel().getEntryRowEntity("taxentry", rowIndex);
            this.getModel().setValue("taxentry_tax", (Object)NumberUtil.subtract((Object)taxEntryObj.get("taxentry_amount"), (Object)newValue), rowIndex);
        }
    }

    public void taxEntry_sumChanged() {
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiTaxRate = billObj.getBoolean("multitaxrateflag");
        if (!isMultiTaxRate) {
            return;
        }
        boolean isMultiCurrency = billObj.getBoolean("foreigncurrencyflag");
        EntryGrid taxEntryCtrl = (EntryGrid)this.getView().getControl("taxentry");
        BigDecimal oriAmt = taxEntryCtrl.getSum("taxentry_oriamt");
        BigDecimal amount = taxEntryCtrl.getSum("taxentry_amount");
        if (isMultiCurrency) {
            this.getModel().getDataEntity().set("amount", (Object)amount);
            this.getView().updateView("amount");
            this.getModel().setValue("oriamt", (Object)oriAmt);
        } else {
            this.getModel().getDataEntity().set("oriamt", (Object)oriAmt);
            this.getView().updateView("oriamt");
            this.getModel().setValue("amount", (Object)amount);
        }
        BigDecimal tax = taxEntryCtrl.getSum("taxentry_tax");
        BigDecimal notaxamt = taxEntryCtrl.getSum("taxentry_notaxamt");
        BigDecimal taxRate = NumberUtil.multiply((Object)NumberUtil.divide((Object)tax, (Object)notaxamt, (int)4), (Object)NumberUtil.ONE_HUNDRED);
        this.getModel().setValue("tax", (Object)tax);
        this.getModel().setValue("notaxamt", (Object)notaxamt);
        this.getModel().setValue("taxrate", (Object)taxRate);
    }
}

