/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.billtpl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BaseDataColumnDependFieldSetEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.common.util.PermissionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BillOrgTplListPlugin
extends AbstractListPlugin {
    protected String getAppId() {
        return MetaDataUtil.getAppIdByView((IFormView)this.getView());
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fileName;
        super.filterColumnSetFilter(args);
        List customQFilters = args.getCustomQFilters();
        FilterColumn cfc = (FilterColumn)args.getSource();
        MainEntityType entityType = cfc.getEntityType();
        switch (fileName = cfc.getFilterField().getFieldName()) {
            case "org.id": 
            case "org.name": {
                HasPermOrgResult permOrgResult = PermissionUtil.getAllViewPermOrgs((String)entityType.getAppId(), (String)entityType.getName());
                if (!permOrgResult.hasAllOrgPerm()) {
                    List orgIds = permOrgResult.getHasPermOrgs();
                    customQFilters.add(new QFilter("id", "in", (Object)orgIds));
                }
                Optional.ofNullable(this.getControlFilters()).ifPresent(filters -> {
                    List projectFilters = filters.getFilter("project.id");
                    if (CollectionUtils.isNotEmpty((Collection)projectFilters)) {
                        projectFilters.clear();
                    }
                });
                break;
            }
            case "project.id": 
            case "project.name": 
            case "project.fullname": {
                List orgList;
                ControlFilters controlFilters = this.getControlFilters();
                if (controlFilters == null) {
                    FilterColumnSetFilterEvent args2 = (FilterColumnSetFilterEvent)args;
                    orgList = args2.getCommonFilterValue("org.id");
                } else {
                    orgList = controlFilters.getFilter("org.id");
                }
                this.setProjectFilter(customQFilters, orgList, entityType.getName());
                break;
            }
        }
    }

    public void baseDataColumnDependFieldSet(BaseDataColumnDependFieldSetEvent args) {
        super.baseDataColumnDependFieldSet(args);
        args.addDependField("project.fullname", "org.id", "org.id");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List customQFilters = args.getCustomQFilters();
        this.filterContainerBeforeProjectF7Select(fieldName, customQFilters);
    }

    protected void filterContainerBeforeProjectF7Select(String fieldName, List<QFilter> customQFilters) {
        if (!("project.id".equals(fieldName) || "project.name".equals(fieldName) || "project.fullname".equals(fieldName))) {
            return;
        }
        IListView listView = (IListView)this.getView();
        FormShowParameter parameter = listView.getFormShowParameter();
        this.setProjectFilter(customQFilters, listView.getSelectedMainOrgIds(), parameter.getFormId());
    }

    protected void setProjectFilter(List<QFilter> customQFilters, List<? extends Object> orgList, String entityId) {
        customQFilters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        if (null == orgList || orgList.size() == 0 || StringUtils.isEmpty((String)orgList.get(0).toString())) {
            HasPermOrgResult permOrgResult = PermissionUtil.getAllViewPermOrgs((String)this.getAppId(), (String)entityId);
            if (!permOrgResult.hasAllOrgPerm()) {
                List orgIds = permOrgResult.getHasPermOrgs();
                customQFilters.add(new QFilter("org", "in", (Object)orgIds));
            }
        } else {
            customQFilters.add(new QFilter("org", "in", orgList));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.setFilterByProject(e);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        for (DynamicObject object : e.getPageData()) {
            this.handleApplayAmtAndAuditAmtDisplay(object);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkHasAddNewPerm(args);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
    }

    protected void handleApplayAmtAndAuditAmtDisplay(DynamicObject object) {
        DataEntityPropertyCollection properties = object.getDynamicObjectType().getProperties();
        boolean flag = false;
        if (properties.containsKey((Object)"applyoriamt") && properties.containsKey((Object)"oriamt")) {
            flag = true;
        }
        Object billStatus = object.get("billstatus");
        if (flag && (BillStatusEnum.SAVED.getValue().equals(billStatus) || BillStatusEnum.SUBMITTED.getValue().equals(billStatus))) {
            if (properties.containsKey((Object)"applyoriamt") && NumberUtil.isZero((Object)object.getBigDecimal("applyoriamt"))) {
                object.set("applyoriamt", (Object)object.getBigDecimal("oriamt"));
            }
            if (properties.containsKey((Object)"applyamt") && NumberUtil.isZero((Object)object.getBigDecimal("applyamt"))) {
                object.set("applyamt", (Object)object.getBigDecimal("amount"));
            }
            if (properties.containsKey((Object)"oriamt")) {
                object.set("oriamt", null);
            }
            if (properties.containsKey((Object)"amount")) {
                object.set("amount", null);
            }
        }
    }

    protected void checkHasAddNewPerm(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (!OperationUtil.isNewOp((String)operateKey)) {
            return;
        }
        IListView listView = (IListView)this.getView();
        FormShowParameter parameter = listView.getFormShowParameter();
        Long mainOrgId = null;
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        mainOrgId = null != selectedMainOrgIds && selectedMainOrgIds.size() > 0 ? (Long)selectedMainOrgIds.get(0) : Long.valueOf(RequestContext.get().getOrgId());
        if (OperationUtil.isNewOp((String)operateKey)) {
            if (null == mainOrgId) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u6240\u5c5e\u7ec4\u7ec7,\u4e0d\u80fd\u65b0\u589e!", (String)"BillOrgTplListPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (!PermissionUtil.checkPermissionById((String)"47156aff000000ac", (Long)RequestContext.get().getCurrUserId(), (Long)mainOrgId, (String)parameter.getAppId(), (String)parameter.getFormId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u65b0\u589e\u6743\u9650", (String)"BillOrgTplListPlugin_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    protected ListSelectedRow getselectedRow() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows.size() > 0) {
            return selectedRows.get(0);
        }
        return null;
    }

    protected void setFilterByProject(SetFilterEvent evt) {
        ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
        if (null == controlFilters) {
            return;
        }
        List filter = controlFilters.getFilter("project.id");
        if (filter.size() > 0 && !filter.get(0).equals("")) {
            return;
        }
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null == filterContainer) {
            return;
        }
        if (PermissionUtil.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            return;
        }
        Optional<Control> filterGridViewOp = filterContainer.getItems().stream().filter(item -> item instanceof FilterGridView).findFirst();
        if (!filterGridViewOp.isPresent()) {
            return;
        }
        FilterGridView filterGridView = (FilterGridView)filterGridViewOp.get();
        if (filterGridView.getItems().size() == 0) {
            return;
        }
        Optional<Control> projectFilterOp = filterGridView.getItems().stream().filter(item -> ((CommonFilterColumn)item).getFieldName().startsWith("project.")).findFirst();
        if (!projectFilterOp.isPresent()) {
            return;
        }
        CommonFilterColumn projectFilter = (CommonFilterColumn)projectFilterOp.get();
        Set<Object> projectIdSet = new HashSet(projectFilter.getComboItems().size());
        for (ComboItem comboItem : projectFilter.getComboItems()) {
            if ("".equals(comboItem.getValue())) continue;
            projectIdSet.add(Long.valueOf(comboItem.getValue()));
        }
        projectIdSet = this.setFilterByAuthorizedProject(controlFilters.getFilter("org.id"));
        List filters = evt.getQFilters();
        filters.add(new QFilter("project.id", "in", projectIdSet));
    }

    protected Set<Long> setFilterByAuthorizedProject(List<?> orgIdList) {
        return Collections.emptySet();
    }
}

