/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.chgcfmbill;

import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.util.CurrencyHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTaxTplPropertyChanged;

public class ChgCfmillPropertyChanged
extends BillOrgTaxTplPropertyChanged {
    public ChgCfmillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String filedName;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        IDataEntityProperty pro = e.getProperty();
        switch (filedName = pro.getName()) {
            case "project": {
                this.projectOnChange();
                break;
            }
            case "contractbill": {
                this.contractOnChange(e);
                break;
            }
            case "org": {
                this.orgOnChange();
                break;
            }
            case "chgaudit": {
                this.chgAuditOnChange(e);
                break;
            }
        }
    }

    protected void projectOnChange() {
        this.getModel().setValue("contractbill", null);
        this.getView().updateView("contractbill");
    }

    protected void contractOnChange(PropertyChangedArgs propertychangedargs) {
        ChangeData cd = propertychangedargs.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        if (null == newVal) {
            return;
        }
        DynamicObject model = this.getModel().getDataEntity(true);
        this.getModel().setValue("chgaudit", null);
        DynamicObject contractBill = this.getModel().getDataEntity().getDynamicObject("contractbill");
        model.set("project", (Object)contractBill.getDynamicObject("project"));
        model.set("supplier", (Object)contractBill.getDynamicObject("partyb"));
        DynamicObject conOriCurrency = contractBill.getDynamicObject("oricurrency");
        if (null != conOriCurrency) {
            conOriCurrency = BusinessDataServiceHelper.loadSingle((Object)conOriCurrency.getPkValue(), (String)"bd_currency");
            model.set("oricurrency", (Object)conOriCurrency);
        }
        model.set("exchangerate", (Object)contractBill.getBigDecimal("exchangerate"));
        model.set("taxrate", (Object)contractBill.getBigDecimal("taxrate"));
        DynamicObject org = contractBill.getDynamicObject("org");
        DynamicObject currency = CurrencyHelper.getCurrency((Long)org.getLong("id"));
        currency = BusinessDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency");
        model.set("currency", (Object)currency);
        model.set("org", (Object)org);
        model.set("applyoriamt", null);
        model.set("applyamt", null);
        model.set("amount", null);
        model.set("notaxamt", null);
        model.set("tax", null);
        model.set("oriamt", null);
        this.getModel().setValue("multitaxrateflag", (Object)contractBill.getBoolean("multitaxrateflag"));
        this.getModel().setValue("foreigncurrencyflag", (Object)contractBill.getBoolean("foreigncurrencyflag"));
        model.set("bd_taxrate", contractBill.get("bd_taxrate"));
        model.set("taxrate", contractBill.get("taxrate"));
        contractBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "taxentry_taxrate", "taxentry_content"), (QFilter[])new QFilter[]{new QFilter("id", "=", contractBill.getPkValue())});
        DynamicObjectCollection conTaxEntry = contractBill.getDynamicObjectCollection("taxentry");
        DynamicObjectCollection entrys = model.getDynamicObjectCollection("taxentry");
        entrys.clear();
        conTaxEntry.forEach(conBillEntry -> {
            DynamicObject entry = entrys.addNew();
            entry.set("taxentry_content", conBillEntry.get("taxentry_content"));
            entry.set("taxentry_taxrate", (Object)conBillEntry.getDynamicObject("taxentry_taxrate"));
        });
        this.getView().updateView();
    }

    protected void orgOnChange() {
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject org = model.getDynamicObject("org");
        if (null == org) {
            model.set("currency", null);
        } else {
            DynamicObject currency = CurrencyHelper.getCurrency((Long)org.getLong("id"));
            currency = BusinessDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency");
            model.set("currency", (Object)currency);
        }
        this.getModel().setValue("contractbill", null);
        this.getView().updateView("currency");
    }

    protected void chgAuditOnChange(PropertyChangedArgs propertychangedargs) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        ChangeData cd = propertychangedargs.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        DynamicObject chgAuditBill = dataEntity.getDynamicObject("chgaudit");
        DynamicObjectCollection chgCfmTaxEntryCol = dataEntity.getDynamicObjectCollection("taxentry");
        chgCfmTaxEntryCol.clear();
        if (null != newVal && null != chgAuditBill && null != chgAuditBill.get("billid")) {
            DynamicObject conChgBill;
            dataEntity.set("changereason", chgAuditBill.get("changereason"));
            dataEntity.set("urgentdegree", chgAuditBill.get("urgentdegree"));
            dataEntity.set("chgtype", chgAuditBill.get("billtype"));
            this.getModel().setValue("oriamt", chgAuditBill.get("oriamt"));
            this.getModel().setValue("amount", chgAuditBill.get("amount"));
            DynamicObject contractBill = dataEntity.getDynamicObject("contractbill");
            if (null == contractBill) {
                this.getModel().setValue("contractbill", chgAuditBill.get("contractbill"));
            }
            if (null != (conChgBill = BusinessDataServiceHelper.loadSingle((Object)chgAuditBill.get("billid"), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conchgbill"))) && conChgBill.getBoolean("multitaxrateflag")) {
                DynamicObjectCollection conChgTaxEntryCol = conChgBill.getDynamicObjectCollection("taxentry");
                for (DynamicObject conChgTaxEntry : conChgTaxEntryCol) {
                    DynamicObject chgCfmTaxEntry = chgCfmTaxEntryCol.addNew();
                    chgCfmTaxEntry.set("taxentry_content", conChgTaxEntry.get("taxentry_content"));
                    chgCfmTaxEntry.set("taxentry_oriamt", conChgTaxEntry.get("taxentry_oriamt"));
                    chgCfmTaxEntry.set("taxentry_amount", conChgTaxEntry.get("taxentry_amount"));
                    chgCfmTaxEntry.set("taxentry_taxrate", conChgTaxEntry.get("taxentry_taxrate"));
                    chgCfmTaxEntry.set("taxentry_notaxamt", conChgTaxEntry.get("taxentry_notaxamt"));
                    chgCfmTaxEntry.set("taxentry_tax", conChgTaxEntry.get("taxentry_tax"));
                }
                EntryGrid control = (EntryGrid)this.getView().getControl("taxentry");
                this.getModel().setValue("tax", (Object)control.getSum("taxentry_tax"));
                this.getModel().setValue("notaxamt", (Object)control.getSum("taxentry_notaxamt"));
            }
        } else {
            dataEntity.set("applyoriamt", null);
            dataEntity.set("applyamt", null);
            dataEntity.set("amount", null);
            dataEntity.set("notaxamt", null);
            dataEntity.set("tax", null);
            dataEntity.set("oriamt", null);
            dataEntity.set("changereason", null);
            dataEntity.set("urgentdegree", null);
            dataEntity.set("chgtype", null);
        }
        this.getView().updateView();
    }
}

