/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.conchgbill;

import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.util.CurrencyHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTaxTplPropertyChanged;

public class ConChgBillPropertyChanged
extends BillOrgTaxTplPropertyChanged {
    public ConChgBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String filedName;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        IDataEntityProperty pro = e.getProperty();
        switch (filedName = pro.getName()) {
            case "project": {
                this.projectOnChange();
                break;
            }
            case "contractbill": {
                this.contractOnChange(newVal);
                break;
            }
        }
    }

    protected void projectOnChange() {
        this.getModel().setValue("contractbill", null);
        this.getView().updateView("contractbill");
    }

    protected void contractOnChange(Object newVal) {
        if (null == newVal) {
            return;
        }
        DynamicObject model = this.getModel().getDataEntity(true);
        DynamicObject contractBill = this.getModel().getDataEntity().getDynamicObject("contractbill");
        model.set("project", (Object)contractBill.getDynamicObject("project"));
        model.set("supplier", (Object)contractBill.getDynamicObject("partyb"));
        DynamicObject conOriCurrency = contractBill.getDynamicObject("oricurrency");
        if (null != conOriCurrency) {
            conOriCurrency = BusinessDataServiceHelper.loadSingle((Object)conOriCurrency.getPkValue(), (String)"bd_currency");
            model.set("oricurrency", (Object)conOriCurrency);
        }
        model.set("exchangerate", (Object)contractBill.getBigDecimal("exchangerate"));
        DynamicObject org = contractBill.getDynamicObject("org");
        DynamicObject currency = CurrencyHelper.getCurrency((Long)org.getLong("id"));
        currency = BusinessDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency");
        model.set("currency", (Object)currency);
        model.set("org", (Object)org);
        model.set("applyoriamt", null);
        model.set("applyamt", null);
        model.set("amount", null);
        model.set("notaxamt", null);
        model.set("tax", null);
        model.set("oriamt", null);
        this.getModel().setValue("multitaxrateflag", (Object)contractBill.getBoolean("multitaxrateflag"));
        this.getModel().setValue("foreigncurrencyflag", (Object)contractBill.getBoolean("foreigncurrencyflag"));
        model.set("taxrate", (Object)contractBill.getBigDecimal("taxrate"));
        model.set("bd_taxrate", (Object)contractBill.getDynamicObject("bd_taxrate"));
        contractBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "taxentry_taxrate", "taxentry_content"), (QFilter[])new QFilter[]{new QFilter("id", "=", contractBill.getPkValue())});
        DynamicObjectCollection conTaxEntry = contractBill.getDynamicObjectCollection("taxentry");
        DynamicObjectCollection entrys = model.getDynamicObjectCollection("taxentry");
        entrys.clear();
        conTaxEntry.forEach(conBillEntry -> {
            DynamicObject entry = entrys.addNew();
            entry.set("taxentry_content", conBillEntry.get("taxentry_content"));
            entry.set("taxentry_taxrate", (Object)conBillEntry.getDynamicObject("taxentry_taxrate"));
        });
        this.getView().updateView();
    }
}

