/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.conpayplan;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ConPayPlanHelper;
import kd.pccs.concs.common.constant.FiCasConst;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.DynamicObjectUtil;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTplFormPlugin;
import kd.pccs.concs.formplugin.conpayplan.ConPayPlanPropertyChanged;
import kd.pccs.concs.formplugin.f7.PaymentTypeF7SelectListener;

public class ConPayPlanFormPlugin
extends BillOrgTplFormPlugin {
    public static final String PARENTPAGE = "parentPage";
    public static final String ORICURRENCY_FIELDID = "e7jTmTTBfs";
    public static final String CURRENCY_FIELDID = "8XuNYSfc5W";
    public static final String TITLEPANELFLEX = "titlepanelflex";
    public static final String CONTENTPANEL = "contentpanel";
    public static final String FS_BASEINFO = "fs_baseinfo";
    public static final String DELETEENTRY = "deleteentry";

    protected String getAppId(FormShowParameter showParameter) {
        return null == this.getView() ? showParameter.getAppId() : this.getAppId();
    }

    @Override
    protected void initPropertyChanged() {
        this.propertyChanged = new ConPayPlanPropertyChanged(this, this.getModel());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerPaymentTypeF7();
    }

    protected void registerPaymentTypeF7() {
        new PaymentTypeF7SelectListener((AbstractFormPlugin)this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("schentry_paymenttype")).setCustomQFilter((evt, qFilters) -> {
            if (!"schentry_paymenttype".equals(evt.getProperty().getName())) {
                return;
            }
            DynamicObjectCollection scheduleEntry = this.getModel().getEntryEntity("conpayplanschedule");
            for (DynamicObject scheduleEntryRow : scheduleEntry) {
                DynamicObject paymentType = scheduleEntryRow.getDynamicObject("schentry_paymenttype");
                if (paymentType == null || !FiCasConst.PRE_PAYMENT.equals(paymentType.getPkValue())) continue;
                qFilters.add(new QFilter("id", "!=", (Object)FiCasConst.PRE_PAYMENT));
                return;
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conrevisebill").equals(parentView.getEntityId())) {
            DynamicObject conReviseObj = this.getView().getParentView().getModel().getDataEntity();
            DynamicObject conPayPlanObj = this.getModel().getDataEntity(true);
            List pks = QueryServiceHelper.queryPrimaryKeys((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", conReviseObj.getDynamicObject("contractbill").getPkValue())}, null, (int)1);
            if (null != pks && pks.size() > 0) {
                DynamicObject tempObj = BusinessDataServiceHelper.loadSingle(pks.get(0), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan"));
                DynamicObjectUtil.copy((DynamicObject)tempObj, (DynamicObject)conPayPlanObj);
                conPayPlanObj.set("billstatus", (Object)BillStatusEnum.SAVED.getValue());
            }
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        EntryAp entryAp = this.createConPayPlanDataViewEntry((FormShowParameter)e.getSource());
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "conpayplandata_view");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        EntryAp dynamicEntryAp = this.createConPayPlanDataViewEntry(formShowParameter);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("conpayplandata_view");
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
        OperationStatus status = formShowParameter.getStatus();
        if ((OperationUtil.isAddNewOp((OperationStatus)status) || OperationUtil.isEditOp((OperationStatus)status)) && this.isOpenFromContractBill(formShowParameter)) {
            DynamicObject conObj = this.getView().getParentView().getModel().getDataEntity();
            DynamicObject conPayPlanObj = this.getModel().getDataEntity();
            conPayPlanObj.set("project", conObj.get("project"));
            conPayPlanObj.set("oriamt", conObj.get("oriamt"));
            conPayPlanObj.set("amount", conObj.get("amount"));
            conPayPlanObj.set("oricurrency", conObj.get("oricurrency"));
            conPayPlanObj.set("currency", conObj.get("currency"));
            conPayPlanObj.set("handler", conObj.get("handler"));
            conPayPlanObj.set("bizdate", conObj.get("bizdate"));
            conPayPlanObj.set("org", conObj.get("org"));
            conPayPlanObj.set("billno", conObj.get("billno"));
            conPayPlanObj.set("billname", conObj.get("billname"));
            IFormView parentView = this.getView().getParentView();
            if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill").equals(parentView.getEntityId())) {
                DynamicObject conF7Obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill_f7")));
                conF7Obj.set("id", conObj.getPkValue());
                conPayPlanObj.set("contractbill", (Object)conF7Obj);
            } else if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conrevisebill").equals(parentView.getEntityId())) {
                conPayPlanObj.set("contractbill", null);
                conPayPlanObj.set("conrevisebill", conObj.getPkValue());
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().startsWith("localm")) {
            DecimalEdit decimalEdit = new DecimalEdit();
            decimalEdit.setKey(e.getKey());
            decimalEdit.setView(this.getView());
            decimalEdit.setEntryKey("conpayplandata_view");
            e.setControl((Control)decimalEdit);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (null != this.getView().getFormShowParameter().getCustomParam(PARENTPAGE)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TITLEPANELFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{FS_BASEINFO});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FS_BASEINFO});
        }
        List<String> fieldNameList = this.getMonths(this.getView().getFormShowParameter()).stream().map(payMonth -> ConPayPlanHelper.getLocalMonthColKey((int)payMonth)).collect(Collectors.toList());
        fieldNameList.add("localsum");
        fieldNameList.add("schentry_payamt");
        fieldNameList.add("schentry_preflushamt");
        DynamicObject contractObj = this.getModel().getDataEntity().getDynamicObject("contractbill");
        String entityId = MetaDataUtil.getEntityId((String)this.getAppId(this.getView().getFormShowParameter()), (String)"contractbill_f7");
        if (null != contractObj && QueryServiceHelper.exists((String)entityId, (Object)contractObj.getPkValue())) {
            contractObj = BusinessDataServiceHelper.loadSingle((Object)contractObj.getPkValue(), (String)entityId);
            boolean isForeignCurrency = contractObj.getBoolean("foreigncurrencyflag");
            this.getView().setVisible(Boolean.valueOf(isForeignCurrency), fieldNameList.toArray(new String[0]));
        } else {
            this.getView().setVisible(Boolean.FALSE, fieldNameList.toArray(new String[0]));
        }
        this.schentry_localsumUp();
        ConPayPlanHelper.genPlanEntryViewData((String)this.getAppId(), (DynamicObject)this.getModel().getDataEntity(true));
        this.getView().updateView("conpayplandata_view");
        ((ConPayPlanPropertyChanged)this.propertyChanged).schentry_sumUp();
    }

    @Override
    protected void initContractInfo() {
    }

    private LocaleString getPayMonthName(int payMonth) {
        String payMonthStr = String.valueOf(payMonth);
        String result = payMonthStr.substring(0, 4) + "-" + payMonthStr.substring(4);
        return new LocaleString(result);
    }

    private LocaleString getLocalPayMonthName(int payMonth) {
        String payMonthStr = String.valueOf(payMonth);
        String result = payMonthStr.substring(0, 4) + "-" + payMonthStr.substring(4);
        LocaleString localLocaleString = new LocaleString(result + ResManager.loadKDString((String)"\uff08\u672c\u5e01\uff09", (String)"ConPayPlanFormPlugin_3", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        return localLocaleString;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("conpayplandata_view");
        TextProp textProp = new TextProp();
        textProp.setName("col1");
        textProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u65f6\u95f4", (String)"ConPayPlanFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0])));
        textProp.setDbIgnore(true);
        entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        List<Integer> months = this.getMonths(this.getView().getFormShowParameter());
        for (int payMonth : months) {
            this.createAmountProp(ConPayPlanHelper.getMonthColKey((int)payMonth), this.getPayMonthName(payMonth), "oricurrency", entryType);
            this.createAmountProp(ConPayPlanHelper.getLocalMonthColKey((int)payMonth), this.getLocalPayMonthName(payMonth), "currency", entryType);
        }
        LocaleString sumLocaleString = new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ConPayPlanFormPlugin_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        this.createAmountProp("sum", sumLocaleString, "oricurrency", entryType);
        LocaleString localSumLocaleString = new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1\uff08\u672c\u5e01\uff09", (String)"ConPayPlanFormPlugin_2", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        this.createAmountProp("localsum", localSumLocaleString, "currency", entryType);
    }

    protected void createAmountProp(String name, LocaleString displayName, String propName, EntryType entryType) {
        AmountProp decimalProp = new AmountProp();
        decimalProp.setName(name);
        decimalProp.setDisplayName(displayName);
        decimalProp.setDbIgnore(true);
        decimalProp.setAlias("");
        decimalProp.setControlPropName(propName);
        entryType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
    }

    protected EntryAp createConPayPlanDataViewEntry(FormShowParameter showParameter) {
        String appId = this.getAppId(showParameter);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)appId, (String)"conpayplan"));
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        formMeta.bindEntityMetadata(entityMetadata);
        EntryAp planEntryAp = (EntryAp)formMeta.getItem("2w0GabZ2JQ");
        List planApItems = planEntryAp.getItems();
        EntryFieldAp fieldApText = new EntryFieldAp();
        fieldApText.setId("col1");
        fieldApText.setKey(fieldApText.getId());
        fieldApText.setName(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u65f6\u95f4", (String)"ConPayPlanFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0])));
        TextField field = new TextField();
        field.setId(fieldApText.getId());
        field.setKey(fieldApText.getId());
        field.setEntityMetadata(entityMetadata);
        fieldApText.setField((Field)field);
        planApItems.add(fieldApText);
        List<Integer> months = this.getMonths(showParameter);
        for (int payMonth : months) {
            this.createAmtFieldAp(entityMetadata, planApItems, ConPayPlanHelper.getMonthColKey((int)payMonth), this.getPayMonthName(payMonth), ORICURRENCY_FIELDID);
        }
        LocaleString sumLocaleString = new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ConPayPlanFormPlugin_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        this.createSumFieldAp(entityMetadata, planApItems, sumLocaleString, "sum", ORICURRENCY_FIELDID);
        for (int payMonth : months) {
            this.createAmtFieldAp(entityMetadata, planApItems, ConPayPlanHelper.getLocalMonthColKey((int)payMonth), this.getLocalPayMonthName(payMonth), CURRENCY_FIELDID);
        }
        LocaleString localSumLocaleString = new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1\uff08\u672c\u5e01\uff09", (String)"ConPayPlanFormPlugin_2", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        this.createSumFieldAp(entityMetadata, planApItems, localSumLocaleString, "localsum", CURRENCY_FIELDID);
        return planEntryAp;
    }

    protected void createSumFieldAp(EntityMetadata entityMetadata, List<ControlAp<?>> planApItems, LocaleString name, String id, String currencyFieldId) {
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setId(id);
        fieldAp.setKey(fieldAp.getId());
        fieldAp.setName(name);
        AmountField paySumField = new AmountField();
        paySumField.setId(fieldAp.getId());
        paySumField.setKey(fieldAp.getId());
        paySumField.setPrecision(23);
        paySumField.setScale(2);
        paySumField.setZeroShow(true);
        paySumField.setEntityMetadata(entityMetadata);
        paySumField.setCurrencyFieldId(currencyFieldId);
        fieldAp.setField((Field)paySumField);
        planApItems.add((ControlAp<?>)fieldAp);
    }

    protected void createAmtFieldAp(EntityMetadata entityMetadata, List<ControlAp<?>> planApItems, String id, LocaleString name, String currencyFieldId) {
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setId(id);
        fieldAp.setKey(fieldAp.getId());
        fieldAp.setName(name);
        AmountField payOriAmtField = new AmountField();
        payOriAmtField.setId(fieldAp.getId());
        payOriAmtField.setKey(fieldAp.getId());
        payOriAmtField.setPrecision(23);
        payOriAmtField.setScale(2);
        payOriAmtField.setZeroShow(false);
        payOriAmtField.setEntityMetadata(entityMetadata);
        payOriAmtField.setCurrencyFieldId(currencyFieldId);
        fieldAp.setField((Field)payOriAmtField);
        planApItems.add((ControlAp<?>)fieldAp);
    }

    protected List<Integer> getMonths(FormShowParameter showParameter) {
        String filterKey = "id";
        String appId = this.getAppId(showParameter);
        if (this.isOpenFromContractBill(showParameter)) {
            filterKey = "conrevisebill";
            Object conIdObj = showParameter.getCustomParam(filterKey);
            if (null == conIdObj || "0".equals(conIdObj.toString())) {
                filterKey = "contractbill";
                conIdObj = showParameter.getCustomParam(filterKey);
            }
            Long conId = null;
            conId = conIdObj instanceof Long ? (Long)conIdObj : Long.valueOf(Long.parseLong(conIdObj.toString()));
            return ConPayPlanHelper.getPayPlanMonths((String)appId, (Long)conId, (String)filterKey);
        }
        return ConPayPlanHelper.getPayPlanMonths((String)appId, null, (String)filterKey);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DeleteEntry deleteEntry;
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals(DELETEENTRY) && (deleteEntry = (DeleteEntry)afterDoOperationEventArgs.getSource()).getEntityId().equals(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan"))) {
            DynamicObjectCollection conPayPlanSchedule = this.getModel().getEntryEntity("conpayplanschedule");
            if (!ConPayPlanHelper.checkHasPrePayment((String)this.getAppId(), (DynamicObjectCollection)conPayPlanSchedule)) {
                for (int i = 0; i < conPayPlanSchedule.size(); ++i) {
                    this.getModel().setValue("schentry_preflushoriamt", null, i);
                    this.getModel().setValue("schentry_preflushamt", null, i);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"schentry_preflushoriamt"});
                }
            }
        }
    }

    public boolean isOpenFromContractBill(FormShowParameter showParameter) {
        Object parentPage;
        if (null == showParameter) {
            showParameter = this.getView().getFormShowParameter();
        }
        if (null == (parentPage = showParameter.getCustomParam(PARENTPAGE))) {
            return false;
        }
        String appId = this.getAppId(showParameter);
        String parentPageStr = parentPage.toString();
        return MetaDataUtil.getEntityId((String)appId, (String)"contractbill").equals(parentPageStr) || MetaDataUtil.getEntityId((String)appId, (String)"contractbill_cc").equals(parentPageStr) || MetaDataUtil.getEntityId((String)appId, (String)"conrevisebill").equals(parentPageStr);
    }

    public boolean isMultiCurrency(FormShowParameter showParameter) {
        String entityId = "";
        String fieldName = "";
        String appId = this.getAppId(showParameter);
        if (this.isOpenFromContractBill(showParameter)) {
            entityId = "conrevisebill";
            fieldName = "foreigncurrencyflag";
            Object conIdObj = showParameter.getCustomParam(entityId);
            if (null == conIdObj || "0".equals(conIdObj.toString())) {
                entityId = "contractbill";
                fieldName = "foreigncurrencyflag";
                conIdObj = showParameter.getCustomParam(entityId);
            }
            if (null == conIdObj || "0".equals(conIdObj.toString())) {
                return false;
            }
            DynamicObject conObj = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)entityId), (String)String.join((CharSequence)",", "foreigncurrencyflag"), (QFilter[])new QFilter[]{new QFilter("id", "=", conIdObj)});
            if (null != conObj) {
                return conObj.getBoolean(fieldName);
            }
        }
        return false;
    }

    protected void schentry_localsumUp() {
        DynamicObjectCollection schEntryColl = this.getModel().getEntryEntity("conpayplanschedule");
        BigDecimal schentry_payamt = BigDecimal.ZERO;
        int isize = schEntryColl.size();
        for (int i = 0; i < isize; ++i) {
            DynamicObject entryObj = (DynamicObject)schEntryColl.get(i);
            DynamicObject payTypeObj = entryObj.getDynamicObject("schentry_paymenttype");
            if (null != payTypeObj && FiCasConst.PRE_PAYMENT.equals(payTypeObj.getPkValue())) continue;
            schentry_payamt = NumberUtil.add((Object)schentry_payamt, (Object)entryObj.getBigDecimal("schentry_payamt"));
        }
        HashMap<String, String> sumData = new HashMap<String, String>();
        sumData.put("schentry_payamt", NumberUtil.formatTo2ddString((Object)schentry_payamt));
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("conpayplanschedule");
        entryGrid.setFloatButtomData(sumData);
    }
}

